/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.html.HtmlStack;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.ArrayList;
import java.util.List;

public class JHPCData
extends JHElement {
    public String _text;

    public JHPCData(List list, String string, int n, int n2) {
        super(list);
        this._text = string;
        this._line = n;
        this._column = n2;
    }

    protected void processPCData(HtmlStack htmlStack, HtmlMetadata htmlMetadata) {
        Object object;
        JHOpenTag jHOpenTag = htmlStack.top();
        String string = jHOpenTag.getName();
        if ("title".equals(string)) {
            htmlMetadata.setTitle(this._text);
        } else if ("cite".equals(string)) {
            htmlMetadata.addCitation(this._text);
        } else if ("dfn".equals(string)) {
            htmlMetadata.addDef(this._text);
        } else if ("abbr".equals(string)) {
            object = new ArrayList(2);
            object.add(new Property("Text", PropertyType.STRING, (Object)this._text));
            for (String[] stringArray : jHOpenTag.getAttributes()) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                if (!"title".equals(string2)) continue;
                object.add(new Property("Title", PropertyType.STRING, (Object)string3));
                break;
            }
            htmlMetadata.addAbbr(new Property("Abbr", PropertyType.PROPERTY, PropertyArity.LIST, object));
        }
        object = this.getEntities(this._text).iterator();
        Utf8BlockMarker utf8BlockMarker = htmlMetadata.getUtf8BlockMarker();
        while (object.hasNext()) {
            String[] stringArray;
            stringArray = (String[])object.next();
            htmlMetadata.addEntity((String)stringArray);
            try {
                if (stringArray.charAt(1) != '#') continue;
                int n = Integer.parseInt(stringArray.substring(2, stringArray.length() - 1));
                utf8BlockMarker.markBlock(n);
            }
            catch (Exception exception) {}
        }
    }
}

