package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class WSGReducing extends WorkSheetGenerator {
	
	private ArrayList<ExerciseReducing> al_exercises;
	
	public WSGReducing(File exerciseFile, File solutionFile){
		super(lang.Messages.getString("reduce_fractions"), WorkSheetGenerator.TWO_COLUMN);
		al_exercises = new ArrayList<ExerciseReducing>();
		al_solutionLine = new ArrayList<String>();
		mkExercises(nb_of_exercises,10, 10);
		generateText();
		writeFile(
				exerciseFile,
				al_exercisesText,
				true
		);
		writeFile(
				solutionFile,
				al_solutionsText,
				false
		);
	}
	
	protected void mkExercises(int nb, int fractionmax, int factormax) {
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseReducing(fractionmax, factormax));
		}//for
	}

	@Override
	protected String writeOneLine(boolean isExercise, int nb) {
		String strReturn = "";
		int n1 = al_exercises.get(nb).getN1();
		int d1 = al_exercises.get(nb).getD1();
		int f1 = al_exercises.get(nb).getFactor();
		int n2 = al_exercises.get(nb+1).getN1();
		int d2 = al_exercises.get(nb+1).getD1();
		int f2 = al_exercises.get(nb+1).getFactor();
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$ = ";
			if(!isExercise){
				strReturn += "$\\frac{"+n1+" \\div "+f1+"}{"+d1+"\\div"+f1+"}$ = ";
				strReturn += "$\\frac{"+n1+"}{"+d1+"}$";
				al_solutionLine.add("$\\frac{"+n1+"}{"+d1+"}$");
			}
			strReturn += "&"; //-----------------------
			strReturn += String.valueOf(nb+2);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+(n2*f2)+"}{"+(d2*f2)+"}$ = ";
			if(!isExercise){
				strReturn += "$\\frac{"+n2+"\\div"+f2+"}{"+d2+"\\div"+f2+"}$ = ";
				strReturn += "$\\frac{"+n2+"}{"+d2+"}$";
				al_solutionLine.add("$\\frac{"+n2+"}{"+d2+"}$");
			}
			strReturn += "\\\\";
		return strReturn;
	}
	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	
//	@Override
//	protected String writeOneLine(boolean isExercise, int nb) {
//		String strReturn = "";
//		int n1 = al_exercises.get(nb).getN1();
//		int d1 = al_exercises.get(nb).getD1();
//		int f1 = al_exercises.get(nb).getFactor();
//			strReturn += String.valueOf(nb+1);
//			strReturn += "&"; //-----------------------
//			strReturn += "$\\frac{"+(n1*f1)+"}{"+(d1*f1)+"}$ = ";
//			if(!isExercise){
//				strReturn += "$\\frac{"+n1+" \\div "+f1+"}{"+d1+"\\div"+f1+"}$ = ";
//				strReturn += "$\\frac{"+n1+"}{"+d1+"}$";
//				al_solutionLine.add("$\\frac{"+n1+"}{"+d1+"}$");
//			}
//			strReturn += "&"; //-----------------------
//			strReturn += "\\\\";
//		return strReturn;
//	}

}