package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class WSGImproperFractions extends WorkSheetGenerator{
	private ArrayList<ExerciseImproperFractions> al_exercises;
	
	public WSGImproperFractions(File exerciseFile, File solutionFile, int max){
		super(lang.Messages.getString("improper_fracs"), WorkSheetGenerator.TWO_COLUMN);
		if (max == 10 || max == 100){
			al_exercises = new ArrayList<ExerciseImproperFractions>();
			al_solutionLine = new ArrayList<String>();
			mkExercises(nb_of_exercises, max);
			generateText();
			writeFile(
					exerciseFile,
					al_exercisesText,
					true
			);
			writeFile(
					solutionFile,
					al_solutionsText,
					false
			);
		}else{
			throw new IllegalArgumentException( "max has to be 10 or 100" );
		}
	}//Constructor
	
	protected void mkExercises(int nb, int max){
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseImproperFractions(max));
		}//for
	}//mkFractions
	

	@Override
	protected String writeOneLine(boolean isExercise, int nb){
		String strReturn = "";
		n1 = al_exercises.get(nb).getN();
		d1 = al_exercises.get(nb).getD();
		n2 = al_exercises.get(nb+1).getN();
		d2 = al_exercises.get(nb+1).getD();
		
		strReturn += String.valueOf(nb+1);
		strReturn += "&"; //------------------------
		strReturn += "$\\frac{"+n1+"}{"+d1+"}$ = ";
		int full_number = n1/d1;
		int rest = n1%d1;
		if(!isExercise){
			
			if(rest == 0){
				strReturn += full_number;
			}else{
				strReturn += "$\\frac{"+(full_number*d1)+"}{"+d1+"}$ + $\\frac{"+rest+"}{"+d1+"}$ = ";
				strReturn += full_number+" $\\frac{"+rest+"}{"+d1+"}$";
			}
		}
		if(isExercise){
			if(rest == 0){
				al_solutionLine.add(String.valueOf(full_number));
			}else{
				al_solutionLine.add(full_number+"$\\frac{"+rest+"}{"+d1+"}$");
			}
		}
		
		strReturn += "&"; //------------------------
		strReturn += String.valueOf(nb+2);
		strReturn += "&"; //------------------------
		strReturn += "$\\frac{"+n2+"}{"+d2+"}$ = ";

		full_number = n2/d2;
		rest = n2%d2;
		if(!isExercise){
			if(rest == 0){
				strReturn += full_number;
			}else{
				strReturn += "$\\frac{"+(full_number*d2)+"}{"+d2+"}$ + $\\frac{"+rest+"}{"+d2+"}$ = ";
				strReturn += full_number+" $\\frac{"+rest+"}{"+d2+"}$";
			}
		}
		if(isExercise){
			if(rest == 0){
				al_solutionLine.add(String.valueOf(full_number));
			}else{
				al_solutionLine.add(full_number+"$\\frac{"+rest+"}{"+d2+"}$");
			}
		}
		
		strReturn += "\\\\";
		return strReturn;
	}

}//class
