/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.ArrayList;
import org.antlr.misc.IntervalSet;
import org.antlr.test.BaseTest;

public class TestIntervalSet
extends BaseTest {
    public void testSingleElement() throws Exception {
        IntervalSet s = IntervalSet.of(99);
        String expecting = "99";
        TestIntervalSet.assertEquals((String)s.toString(), (String)expecting);
    }

    public void testIsolatedElements() throws Exception {
        IntervalSet s = new IntervalSet();
        s.add(1);
        s.add(122);
        s.add(65520);
        String expecting = "{1, 122, 65520}";
        TestIntervalSet.assertEquals((String)s.toString(), (String)expecting);
    }

    public void testMixedRangesAndElements() throws Exception {
        IntervalSet s = new IntervalSet();
        s.add(1);
        s.add(97, 122);
        s.add(48, 57);
        String expecting = "{1, 48..57, 97..122}";
        TestIntervalSet.assertEquals((String)s.toString(), (String)expecting);
    }

    public void testSimpleAnd() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(13, 15);
        String expecting = "13..15";
        String result = s.and(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testRangeAndIsolatedElement() throws Exception {
        IntervalSet s = IntervalSet.of(97, 122);
        IntervalSet s2 = IntervalSet.of(100);
        String expecting = "100";
        String result = s.and(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testEmptyIntersection() throws Exception {
        IntervalSet s = IntervalSet.of(97, 122);
        IntervalSet s2 = IntervalSet.of(48, 57);
        String expecting = "{}";
        String result = s.and(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotSingleElement() throws Exception {
        IntervalSet vocabulary = IntervalSet.of(1, 1000);
        vocabulary.add(2000, 3000);
        IntervalSet s = IntervalSet.of(50, 50);
        String expecting = "{1..49, 51..1000, 2000..3000}";
        String result = s.complement(vocabulary).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotSet() throws Exception {
        IntervalSet vocabulary = IntervalSet.of(1, 1000);
        IntervalSet s = IntervalSet.of(50, 60);
        s.add(5);
        s.add(250, 300);
        String expecting = "{1..4, 6..49, 61..249, 301..1000}";
        String result = s.complement(vocabulary).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotEqualSet() throws Exception {
        IntervalSet vocabulary = IntervalSet.of(1, 1000);
        IntervalSet s = IntervalSet.of(1, 1000);
        String expecting = "{}";
        String result = s.complement(vocabulary).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotSetEdgeElement() throws Exception {
        IntervalSet vocabulary = IntervalSet.of(1, 2);
        IntervalSet s = IntervalSet.of(1);
        String expecting = "2";
        String result = s.complement(vocabulary).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotSetFragmentedVocabulary() throws Exception {
        IntervalSet vocabulary = IntervalSet.of(1, 255);
        vocabulary.add(1000, 2000);
        vocabulary.add(9999);
        IntervalSet s = IntervalSet.of(50, 60);
        s.add(3);
        s.add(250, 300);
        s.add(10000);
        String expecting = "{1..2, 4..49, 61..249, 1000..2000, 9999}";
        String result = s.complement(vocabulary).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfCompletelyContainedRange() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(12, 15);
        String expecting = "{10..11, 16..20}";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfOverlappingRangeFromLeft() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(5, 11);
        String expecting = "12..20";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
        IntervalSet s3 = IntervalSet.of(5, 10);
        expecting = "11..20";
        result = s.subtract(s3).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfOverlappingRangeFromRight() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(15, 25);
        String expecting = "10..14";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
        IntervalSet s3 = IntervalSet.of(20, 25);
        expecting = "10..19";
        result = s.subtract(s3).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfCompletelyCoveredRange() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(1, 25);
        String expecting = "{}";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfRangeSpanningMultipleRanges() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        s.add(30, 40);
        s.add(50, 60);
        IntervalSet s2 = IntervalSet.of(5, 55);
        String expecting = "56..60";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
        IntervalSet s3 = IntervalSet.of(15, 55);
        expecting = "{10..14, 56..60}";
        result = s.subtract(s3).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSubtractOfWackyRange() throws Exception {
        IntervalSet s = IntervalSet.of(0, 113);
        s.add(115, 200);
        IntervalSet s2 = IntervalSet.of(0, 115);
        s2.add(117, 200);
        String expecting = "116";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSimpleEquals() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(10, 20);
        Boolean expecting = new Boolean(true);
        Boolean result = new Boolean(s.equals(s2));
        TestIntervalSet.assertEquals((Object)result, (Object)expecting);
        IntervalSet s3 = IntervalSet.of(15, 55);
        expecting = new Boolean(false);
        result = new Boolean(s.equals(s3));
        TestIntervalSet.assertEquals((Object)result, (Object)expecting);
    }

    public void testEquals() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        s.add(2);
        s.add(499, 501);
        IntervalSet s2 = IntervalSet.of(10, 20);
        s2.add(2);
        s2.add(499, 501);
        Boolean expecting = new Boolean(true);
        Boolean result = new Boolean(s.equals(s2));
        TestIntervalSet.assertEquals((Object)result, (Object)expecting);
        IntervalSet s3 = IntervalSet.of(10, 20);
        s3.add(2);
        expecting = new Boolean(false);
        result = new Boolean(s.equals(s3));
        TestIntervalSet.assertEquals((Object)result, (Object)expecting);
    }

    public void testSingleElementMinusDisjointSet() throws Exception {
        IntervalSet s = IntervalSet.of(15, 15);
        IntervalSet s2 = IntervalSet.of(1, 5);
        s2.add(10, 20);
        String expecting = "{}";
        String result = s.subtract(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testMembership() throws Exception {
        IntervalSet s = IntervalSet.of(15, 15);
        s.add(50, 60);
        TestIntervalSet.assertTrue((boolean)(s.member(0) ^ true));
        TestIntervalSet.assertTrue((boolean)(s.member(20) ^ true));
        TestIntervalSet.assertTrue((boolean)(s.member(100) ^ true));
        TestIntervalSet.assertTrue((boolean)s.member(15));
        TestIntervalSet.assertTrue((boolean)s.member(55));
        TestIntervalSet.assertTrue((boolean)s.member(50));
        TestIntervalSet.assertTrue((boolean)s.member(60));
    }

    public void testIntersectionWithTwoContainedElements() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(2, 2);
        s2.add(15);
        s2.add(18);
        String expecting = "{15, 18}";
        String result = s.and(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testIntersectionWithTwoContainedElementsReversed() throws Exception {
        IntervalSet s = IntervalSet.of(10, 20);
        IntervalSet s2 = IntervalSet.of(2, 2);
        s2.add(15);
        s2.add(18);
        String expecting = "{15, 18}";
        String result = s2.and(s).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testComplement() throws Exception {
        IntervalSet s = IntervalSet.of(100, 100);
        s.add(101, 101);
        IntervalSet s2 = IntervalSet.of(100, 102);
        String expecting = "102";
        String result = s.complement(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testComplement2() throws Exception {
        IntervalSet s = IntervalSet.of(100, 101);
        IntervalSet s2 = IntervalSet.of(100, 102);
        String expecting = "102";
        String result = s.complement(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testComplement3() throws Exception {
        IntervalSet s = IntervalSet.of(1, 96);
        s.add(99, 65534);
        String expecting = "97..98";
        String result = s.complement(1, 65534).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testMergeOfRangesAndSingleValues() throws Exception {
        IntervalSet s = IntervalSet.of(0, 41);
        s.add(42);
        s.add(43, 65534);
        String expecting = "0..65534";
        String result = s.toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testMergeOfRangesAndSingleValuesReverse() throws Exception {
        IntervalSet s = IntervalSet.of(43, 65534);
        s.add(42);
        s.add(0, 41);
        String expecting = "0..65534";
        String result = s.toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testMergeWhereAdditionMergesTwoExistingIntervals() throws Exception {
        IntervalSet s = IntervalSet.of(42);
        s.add(10);
        s.add(0, 9);
        s.add(43, 65534);
        s.add(11, 41);
        String expecting = "0..65534";
        String result = s.toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testMergeWithDoubleOverlap() throws Exception {
        IntervalSet s = IntervalSet.of(1, 10);
        s.add(20, 30);
        s.add(5, 25);
        String expecting = "1..30";
        String result = s.toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testSize() throws Exception {
        IntervalSet s = IntervalSet.of(20, 30);
        s.add(50, 55);
        s.add(5, 19);
        String expecting = "32";
        String result = String.valueOf(s.size());
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testToList() throws Exception {
        IntervalSet s = IntervalSet.of(20, 25);
        s.add(50, 55);
        s.add(5, 5);
        String expecting = "[5, 20, 21, 22, 23, 24, 25, 50, 51, 52, 53, 54, 55]";
        ArrayList foo = new ArrayList();
        String result = String.valueOf(s.toList());
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }

    public void testNotRIntersectionNotT() throws Exception {
        IntervalSet s = IntervalSet.of(0, 115);
        s.add(117, 200);
        IntervalSet s2 = IntervalSet.of(0, 113);
        s2.add(115, 200);
        String expecting = "{0..113, 115, 117..200}";
        String result = s.and(s2).toString();
        TestIntervalSet.assertEquals((String)result, (String)expecting);
    }
}

