/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List transitions;
    protected int k;
    protected int acceptStateReachable;
    protected boolean resolvedWithPredicates;
    protected boolean abortedDueToRecursionOverflow;
    protected boolean abortedDueToMultipleRecursiveAlts;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt;
    protected Set nfaConfigurations;
    protected Set closureBusy;
    protected OrderedHashSet reachableLabels;

    public Transition transition(int i) {
        return (Transition)this.transitions.get(i);
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public void addTransition(Transition t) {
        this.transitions.add(t);
    }

    public int addTransition(DFAState target, Label label) {
        this.transitions.add(new Transition(label, (State)target));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int trans) {
        return (Transition)this.transitions.get(trans);
    }

    public void removeTransition(int trans) {
        this.transitions.remove(trans);
    }

    public void addNFAConfiguration(NFAState state, NFAConfiguration c) {
        Label label;
        if (this.nfaConfigurations.contains(c)) {
            return;
        }
        this.nfaConfigurations.add(c);
        this.cachedHashCode += c.state + c.alt;
        if (state.transition(0) != null && !(label = state.transition((int)0).label).isEpsilon() && !label.isSemanticPredicate()) {
            if (state.transition(1) == null) {
                c.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public void addNFAConfiguration(NFAState state, int alt, NFAContext context, SemanticContext semanticContext) {
        NFAConfiguration c = new NFAConfiguration(state.stateNumber, alt, context, semanticContext);
        this.addNFAConfiguration(state, c);
    }

    protected void addReachableLabel(Label label) {
        IntSet t;
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet remainder = t = label.getSet();
        int n = this.reachableLabels.size();
        int i = 0;
        while (i < n) {
            Label rl = (Label)this.reachableLabels.get(i);
            IntSet s_i = rl.getSet();
            IntSet intersection = s_i.and(t);
            if (!intersection.isNil()) {
                this.reachableLabels.set(i, new Label(intersection));
                IntSet existingMinusNewElements = s_i.subtract(t);
                if (!existingMinusNewElements.isNil()) {
                    Label newLabel = new Label(existingMinusNewElements);
                    this.reachableLabels.add(newLabel);
                }
                if ((remainder = t.subtract(s_i)).isNil()) break;
                t = remainder;
            }
            ++i;
        }
        if (!remainder.isNil()) {
            Label newLabel = new Label(remainder);
            this.reachableLabels.add(newLabel);
        }
    }

    public OrderedHashSet getReachableLabels() {
        return this.reachableLabels;
    }

    public Set getNFAConfigurations() {
        return this.nfaConfigurations;
    }

    public void setNFAConfigurations(Set configs) {
        this.nfaConfigurations = configs;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        DFAState other = (DFAState)o;
        if (o == null) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.nfaConfigurations.size() != other.nfaConfigurations.size()) {
            return false;
        }
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration myConfig = (NFAConfiguration)iter.next();
            if (other.nfaConfigurations.contains(myConfig)) continue;
            return false;
        }
        return true;
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int alt = -1;
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (configuration.resolved) continue;
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = alt;
        return alt;
    }

    public int getUniqueAlt() {
        int alt = -1;
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        return alt;
    }

    public Set getDisabledAlternatives() {
        LinkedHashSet<Integer> disabled = new LinkedHashSet<Integer>();
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (!configuration.resolved) continue;
            disabled.add(Utils.integer(configuration.alt));
        }
        return disabled;
    }

    protected Set getNonDeterministicAlts() {
        int user_k = this.dfa.getUserMaxLookahead();
        if (user_k > 0 && user_k == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set getConflictingAlts() {
        Integer stateI;
        HashSet<Integer> nondeterministicAlts = new HashSet<Integer>();
        if (this.nfaConfigurations.size() <= 1) {
            return null;
        }
        Iterator iter = this.nfaConfigurations.iterator();
        HashMap<Integer, ArrayList<NFAConfiguration>> stateToConfigListMap = new HashMap<Integer, ArrayList<NFAConfiguration>>();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            Integer stateI2 = Utils.integer(configuration.state);
            ArrayList<NFAConfiguration> prevConfigs = (ArrayList<NFAConfiguration>)stateToConfigListMap.get(stateI2);
            if (prevConfigs == null) {
                prevConfigs = new ArrayList<NFAConfiguration>();
                stateToConfigListMap.put(stateI2, prevConfigs);
            }
            prevConfigs.add(configuration);
        }
        Set states = stateToConfigListMap.keySet();
        int numPotentialConflicts = 0;
        Iterator it = states.iterator();
        while (it.hasNext()) {
            stateI = (Integer)it.next();
            boolean thisStateHasPotentialProblem = false;
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int alt = 0;
            int i = 0;
            while (i < configsForState.size() && configsForState.size() > 1) {
                NFAConfiguration c = (NFAConfiguration)configsForState.get(i);
                if (alt == 0) {
                    alt = c.alt;
                } else if (!(c.alt == alt || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.equals("Tokens"))) {
                    ++numPotentialConflicts;
                    thisStateHasPotentialProblem = true;
                }
                ++i;
            }
            if (thisStateHasPotentialProblem) continue;
            stateToConfigListMap.put(stateI, null);
        }
        if (numPotentialConflicts == 0) {
            return null;
        }
        it = states.iterator();
        while (it.hasNext()) {
            stateI = (Integer)it.next();
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int i = 0;
            while (configsForState != null && i < configsForState.size()) {
                NFAConfiguration s = (NFAConfiguration)configsForState.get(i);
                int j = i + 1;
                while (j < configsForState.size()) {
                    NFAConfiguration t = (NFAConfiguration)configsForState.get(j);
                    if (s.alt != t.alt && s.context.conflictsWith(t.context)) {
                        nondeterministicAlts.add(Utils.integer(s.alt));
                        nondeterministicAlts.add(Utils.integer(t.alt));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (nondeterministicAlts.size() == 0) {
            return null;
        }
        return nondeterministicAlts;
    }

    public Set getAltSet() {
        HashSet<Integer> alts = new HashSet<Integer>();
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            alts.add(Utils.integer(configuration.alt));
        }
        if (alts.size() == 0) {
            return null;
        }
        return alts;
    }

    public Set getNFAStatesForAlt(int alt) {
        HashSet<Integer> alts = new HashSet<Integer>();
        Iterator iter = this.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (configuration.alt != alt) continue;
            alts.add(Utils.integer(configuration.state));
        }
        return alts;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        Iterator iter = this.nfaConfigurations.iterator();
        SemanticContext unionOfPredicatesFromAllAlts = null;
        boolean foundTruePred = false;
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null) {
                foundTruePred = true;
            }
            if (gatedPredExpr == null) continue;
            unionOfPredicatesFromAllAlts = unionOfPredicatesFromAllAlts == null ? gatedPredExpr : SemanticContext.or(unionOfPredicatesFromAllAlts, gatedPredExpr);
        }
        if (foundTruePred) {
            return null;
        }
        if (unionOfPredicatesFromAllAlts instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return unionOfPredicatesFromAllAlts;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int acceptStateReachable) {
        this.acceptStateReachable = acceptStateReachable;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.stateNumber + ":{");
        Iterator iter = this.nfaConfigurations.iterator();
        int i = 1;
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (i > 1) {
                buf.append(", ");
            }
            buf.append(configuration);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int k) {
        this.k = k;
        if (k > this.dfa.max_k) {
            this.dfa.max_k = k;
        }
    }

    private final /* synthetic */ void this() {
        this.transitions = new ArrayList(4);
        this.acceptStateReachable = -2;
        this.resolvedWithPredicates = false;
        this.abortedDueToRecursionOverflow = false;
        this.abortedDueToMultipleRecursiveAlts = false;
        this.cachedUniquelyPredicatedAlt = -2;
        this.nfaConfigurations = new HashSet();
        this.closureBusy = new HashSet();
        this.reachableLabels = new OrderedHashSet();
    }

    public DFAState(DFA dfa) {
        this.this();
        this.dfa = dfa;
    }
}

