/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)StartStopHandler.java	1.34 06/28/07
 */ 

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.Globals;

import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;

/**
 * Handler class which deals with starting/stoping the delivery of 
 * messages to a specific connection
 */
public class StartStopHandler extends PacketHandler 
{

    Hashtable hash = new Hashtable();

    public StartStopHandler() {
        hash.put("JMQStatus", new Integer(Status.OK));

    }

    /**
     * Method to handle Start and Stop messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
        Hashtable props = null;
        try {
            props = msg.getProperties();
        } catch (Exception ex) {
            throw new RuntimeException("Can not load props", ex);
        }
        Long lsid = (props == null ? null :
             (Long)props.get("JMQSessionID"));

        SessionUID suid = (lsid == null ? null :
              new SessionUID(lsid.longValue()));

        int status = Status.OK;
        String reason = null;

        switch (msg.getPacketType()) {
            case PacketType.START:
                if (suid != null) {
                    boolean bad = false;
                    Session s= Session.getSession(suid);
                    if (s != null && !s.getConnectionUID().equals(con.getConnectionUID()))
                        bad = true;
                    assert s != null;
                    // OK .. the client should never be sending us
                    // a bad session ID, but in reconnect it sometimes
                    // does
                    // handle it gracefully if the client does the 
                    // wrong thing
                    if (s == null || bad ) {
                       logger.log(Logger.INFO,"Internal Error: received "
                                 + "bad session id " + suid 
                                 + " when starting session");
                       if (bad) {
                           logger.log(logger.INFO,"Session " + suid +
                              " is bad because "
                             + " it is from a different connection "
                             + " [owning,current]=[" + s.getConnectionUID()
                             + "," + con.getConnectionUID() + "]"); 
                       }
                       status = Status.ERROR;
                       reason = "received bad session id " + s +
                                " when starting session";
                    } else {
                        s.resume("START_STOP");
                    }
                } else {
                    con.startConnection();
                }
                break;
            case PacketType.STOP:
                if (suid != null) {
                    boolean bad = false;
                    Session s= Session.getSession(suid);
                    if (s != null && !s.getConnectionUID().equals(con.getConnectionUID()))
                        bad = true;
                    assert s != null;

                    // OK .. the client should never be sending us
                    // a bad session ID, but in reconnect it sometimes
                    // does
                    // handle it gracefully if the client does the 
                    // wrong thing

                    if (s == null || bad) {
                       logger.log(Logger.INFO,"Internal Error: received "
                                 + "bad session id " + suid 
                                 + " when stopping session");
                       if (bad) {
                           logger.log(logger.INFO,"Session " + suid +
                              " is bad because "
                             + " it is from a different connection "
                             + " [owning,current]=[" + s.getConnectionUID()
                             + "," + con.getConnectionUID() + "]"); 
                       }
                       status = Status.ERROR;
                       reason = "received bad session id " + s +  
                                " when stopping session";
                    } else {
                         s.pause("START_STOP");
                    }
                } else {
                    con.stopConnection();
                }
                Packet pkt = new Packet(con.useDirectBuffers());
                pkt.setPacketType(PacketType.STOP_REPLY);
                pkt.setConsumerID(msg.getConsumerID());
                if (((IMQIPConnection)con).getDumpPacket() ||
                      ((IMQIPConnection)con).getDumpOutPacket())
                    hash.put("JMQReqID", msg.getSysMessageID().toString());

                hash.put("JMQStatus", new Integer(status));
                if (reason != null)
                    hash.put("JMQReason", reason);

                pkt.setProperties(hash);
                con.sendControlMessage(pkt);
                break;
        }
        return true;
    }

}
