/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)shimUtils.cpp	1.7 06/26/07
 */ 

#include "../basictypes/HandledObject.hpp"
#include "shimUtils.hpp"


/*
 *
 */
MQStatus 
freeHandledObject(const MQObjectHandle   handle,
                  const HandledObjectType objectType)
{
  MQError errorCode = MQ_SUCCESS;
  HandledObject * object = NULL;
  
  // Convert the handle to a HandledObject pointer.
  // If handle is invalid, then return an error
  object = getHandledObject(handle, objectType);
  CNDCHK( object == NULL, MQ_STATUS_INVALID_HANDLE );
  releaseHandledObject(object);
  object = NULL;

  // Delete the object
  ERRCHK( HandledObject::externallyDelete(handle) );

  //// The handle should be invalid now
  //ASSERT( HandledObject::getObject(handle) == NULL );
  
  RETURN_STATUS( MQ_SUCCESS );
Cleanup:
  RETURN_STATUS( errorCode );
}





/*
 *
 */
HandledObject *
getHandledObject(const MQObjectHandle   handle,
                 const HandledObjectType objectType)
{
  // Get the object associated with this handle
  // Return NULL if it is an invalid handle, the type of the
  // handle is an unexpected type, or the object's handle
  // has not been exported
  HandledObject * object = HandledObject::acquireExternalReference(handle);
  if ((object == NULL)                                || 
      ((object->getObjectType() != objectType) &&
       (object->getSuperObjectType() != objectType))  ||
      !object->getIsExported())
  {
    releaseHandledObject(object);
    return NULL;
  }

  return object;
}




/*
 *
 */
MQStatus 
releaseHandledObject(HandledObject * object)
{
  MQError errorCode = MQ_SUCCESS;
  
  CNDCHK( object == NULL, MQ_STATUS_INVALID_HANDLE );

  // This may delete the object, if it was deleted internally.
  ERRCHK( HandledObject::releaseExternalReference(object) );
  
  RETURN_STATUS( MQ_SUCCESS );
Cleanup:
  RETURN_STATUS( errorCode );
}
