/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

class PropertyDAOImpl
extends BaseDAOImpl
implements PropertyDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllNamesSQL;
    protected String selectAllSQL;

    PropertyDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQPROP41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("PROPVALUE").append(" = ?").append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("PROPVALUE").append(" FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectAllNamesSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(" FROM ").append(this.tableName).toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(", ").append("PROPVALUE").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQPROP41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void update(Connection connection, String string, Object object) throws BrokerException {
        boolean bl = false;
        String string2 = null;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            if (this.hasProperty(connection, string)) {
                if (object != null) {
                    string2 = this.updateSQL;
                    preparedStatement = connection.prepareStatement(string2);
                    Util.setObject(preparedStatement, 1, object);
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                } else {
                    string2 = this.deleteSQL;
                    preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
            } else if (object != null) {
                string2 = this.insertSQL;
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                Util.setObject(preparedStatement, 2, object);
                preparedStatement.executeUpdate();
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + string2 + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception);
            throw new BrokerException(this.br.getKString("B4112", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void delete(Connection connection, String string) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteSQL);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4232", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    public Object getProperty(Connection connection, String string) throws BrokerException {
        Object object;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                object = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            object = Util.readObject(resultSet, 1);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4126", string, (Throwable)iOException);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4231", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return object;
    }

    public List getPropertyNames(Connection connection) throws BrokerException {
        ArrayList<String> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<String>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllNamesSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        arrayList.add(string);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllNamesSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4113"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public Properties getProperties(Connection connection) throws BrokerException {
        Properties properties;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                properties = new Properties();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString("PROPNAME");
                        try {
                            Object object = Util.readObject(resultSet, 2);
                            properties.put(string, object);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4126", string, (Throwable)iOException);
                        }
                    }
                    if (Store.getDEBUG()) {
                        this.logger.log(4, "LOADED " + properties.size() + " PROPERTIES FROM DATABASE");
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4113"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return properties;
    }

    public boolean hasProperty(Connection connection, String string) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4231", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Properties(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

