/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;

public class JDBCStore
extends Store
implements DBConstants {
    private static boolean DEBUG = JDBCStore.getDEBUG();
    public static final String LOCK_STORE_PROP = "imq.persist.jdbc.lockstore.enabled";
    public static final int OLD_STORE_VERSION_350 = 350;
    public static final int OLD_STORE_VERSION_370 = 370;
    public static final int OLD_STORE_VERSION_400 = 400;
    public static final int STORE_VERSION = 410;
    DBManager dbmgr;
    DAOFactory daoFactory;
    private HashMap pendingDeleteDsts;
    private HashMap takeoverLockMap;
    private StoreSessionReaperTask sessionReaper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCStore() throws BrokerException {
        block15: {
            String string;
            this.pendingDeleteDsts = new HashMap(5);
            this.takeoverLockMap = new HashMap();
            this.sessionReaper = null;
            this.dbmgr = DBManager.getDBManager();
            this.daoFactory = this.dbmgr.getDAOFactory();
            String string2 = this.dbmgr.getOpenDBURL();
            if (string2 == null) {
                string2 = "not specified";
            }
            if ((string = this.dbmgr.getUser()) == null) {
                string = "not specified";
            }
            Object[] objectArray = new String[]{String.valueOf(410), this.dbmgr.getBrokerID(), string2, string};
            logger.logToAll(8, br.getString("B1067", objectArray));
            if (this.createStore) {
                logger.log(8, "B1170");
            } else {
                logger.log(8, "B1171");
            }
            Connection connection = null;
            try {
                connection = this.dbmgr.getConnection(true);
                if (!this.checkStore(connection)) {
                    this.closeDB(false);
                    return;
                }
                if (Globals.getHAEnabled()) {
                    try {
                        long l = 86400000L;
                        long l2 = 60000L + (long)(Math.random() * 240000.0);
                        this.sessionReaper = new StoreSessionReaperTask(this);
                        Globals.getTimer().schedule((TimerTask)this.sessionReaper, l2, l);
                        if (DEBUG) {
                            logger.log(4, "Store session reaper task has been successfully scheduled [delay=" + l2 + ", period=" + l + "]");
                        }
                        break block15;
                    }
                    catch (IllegalStateException illegalStateException) {
                        logger.log(8, "B3100", (Object)"Cannot schedule inactive store session reaper task, the broker is probably shutting down", (Throwable)illegalStateException);
                    }
                    break block15;
                }
                if (config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                    DBManager.lockTables(connection, true);
                }
            }
            finally {
                Util.close(null, null, connection);
            }
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore instantiated.");
        }
    }

    public final int getStoreVersion() {
        return 410;
    }

    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        this.storeMessage(destinationUID, packet, consumerUIDArray, nArray, this.getStoreSession(), true);
    }

    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        this.storeMessage(destinationUID, packet, null, null, this.getStoreSession(), true);
    }

    protected void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().insert(null, destinationUID, packet, consumerUIDArray, nArray, l, packet.getTimestamp(), bl);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.moveMessage() called for message: " + packet.getSysMessageID().getUniqueName() + " from " + destinationUID + " to " + destinationUID2);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().moveMessage(null, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeMessage() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().delete(null, destinationUID, sysMessageID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeAllMessages() for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().deleteByDestination(null, destination.getDestinationUID());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        return this.messageEnumeration(destination, this.dbmgr.getBrokerID());
    }

    public Enumeration messageEnumeration(Destination destination, String string) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.messageEnumeration() called for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Enumeration enumeration = this.daoFactory.getMessageDAO().messageEnumeration(destination, string);
                    return enumeration;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int getMessageCount(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getMessageCount() called for broker: " + string);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    int n = this.daoFactory.getMessageDAO().getMessageCount(null, string);
                    return n;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getMessageStorageInfo() called for destination: " + destination.getUniqueName());
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getMessageDAO().getMessageStorageInfo(null, destination);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        return this.getMessage(destinationUID, sysMessageID.toString());
    }

    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getMessage() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Packet packet = this.daoFactory.getMessageDAO().getMessage(null, destinationUID, string);
                    return packet;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeInterestStates() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().insert(null, destinationUID.toString(), sysMessageID, consumerUIDArray, nArray, true);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, destinationUID, sysMessageID, consumerUID, n);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n + ", expected: " + n2);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, destinationUID, sysMessageID, consumerUID, n, n2);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (sysMessageID == null || destinationUID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getInterestState() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(connection, destinationUID.toString(), sysMessageID.getUniqueName());
                    int n = this.daoFactory.getConsumerStateDAO().getState(connection, sysMessageID, consumerUID);
                    return n;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null || destinationUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getInterestStates() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getConsumerStateDAO().getStates(connection, sysMessageID);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getConsumerUIDs() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(connection, destinationUID.toString(), sysMessageID.getUniqueName());
                    ConsumerUID[] consumerUIDArray = this.daoFactory.getConsumerStateDAO().getConsumerUIDs(connection, sysMessageID).toArray(new ConsumerUID[0]);
                    return consumerUIDArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().insert(null, consumer, System.currentTimeMillis());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().delete(null, consumer);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Consumer[] consumerArray = this.daoFactory.getConsumerDAO().getAllConsumers(null).toArray(new Consumer[0]);
                    return consumerArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeDestination(Destination destination, boolean bl) throws BrokerException {
        this.storeDestination(destination, this.getStoreSession());
    }

    protected void storeDestination(Destination destination, long l) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().insert(null, destination, l, 0L, System.currentTimeMillis());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().update(null, destination);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl2 = this.daoFactory.getDestinationDAO().delete(null, destination);
                    if (destination.isAutoCreated() && Globals.getHAEnabled()) {
                        DestinationUID destinationUID = destination.getDestinationUID();
                        HashMap hashMap = this.pendingDeleteDsts;
                        synchronized (hashMap) {
                            if (bl2) {
                                this.pendingDeleteDsts.remove(destinationUID);
                            } else {
                                this.pendingDeleteDsts.put(destinationUID, destination.getType());
                            }
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapAutoCreatedDestinations() throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.reapAutoCreatedDestinations() called");
        }
        if (!Globals.getHAEnabled()) {
            return;
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.pendingDeleteDsts;
                    synchronized (hashMap) {
                        if (!this.pendingDeleteDsts.isEmpty()) {
                            DestinationDAO destinationDAO = this.daoFactory.getDestinationDAO();
                            Iterator iterator = this.pendingDeleteDsts.entrySet().iterator();
                            while (iterator.hasNext()) {
                                int n;
                                Map.Entry entry = iterator.next();
                                DestinationUID destinationUID = (DestinationUID)entry.getKey();
                                if (!destinationDAO.delete(null, destinationUID, n = ((Integer)entry.getValue()).intValue())) continue;
                                logger.log(4, "Auto-created destination " + destinationUID + " has been removed from HA Store");
                                iterator.remove();
                            }
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination getDestination(DestinationUID destinationUID) throws BrokerException {
        if (destinationUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getDestination() called with destination ID: " + destinationUID.toString());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Destination destination = this.daoFactory.getDestinationDAO().getDestination(null, destinationUID.toString());
                    return destination;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination[] getAllDestinations() throws IOException, BrokerException {
        return this.getAllDestinations(this.dbmgr.getBrokerID());
    }

    public Destination[] getAllDestinations(String string) throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllDestinations() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Destination[] destinationArray = this.daoFactory.getDestinationDAO().getAllDestinations(null, string).toArray(new Destination[0]);
                    return destinationArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        if (transactionUID == null || transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionState, this.getStoreSession());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeTransaction() called with id=" + transactionUID.longValue() + ", removeAcks=" + bl);
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    if (bl) {
                        this.daoFactory.getConsumerStateDAO().clearTransaction(connection, transactionUID);
                    }
                    this.daoFactory.getTransactionDAO().delete(connection, transactionUID);
                    connection.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (transactionUID == null || transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateTransactionState called with id=" + transactionUID.longValue() + ", ts=" + transactionState.getState());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionState(null, transactionUID, transactionState);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getTransactionDAO().getTransactionStatesByBroker(null, this.dbmgr.getBrokerID());
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getTransactionDAO().getRemoteTransactionStatesByBroker(null, this.dbmgr.getBrokerID());
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (transactionUID == null || transactionAcknowledgement == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateTransaction(null, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG && DEBUG) {
            logger.log(4, "JDBCStore.removeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().clearTransaction(null, transactionUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionAcks() throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getConsumerStateDAO().getAllTransactionAcks(null);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTransactionAcks() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionAcknowledgement[] transactionAcknowledgementArray = this.daoFactory.getConsumerStateDAO().getTransactionAcks(null, transactionUID).toArray(new TransactionAcknowledgement[0]);
                    return transactionAcknowledgementArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        this.storeTransaction(transactionUID, transactionInfo, this.getStoreSession());
    }

    protected void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, long l) throws BrokerException {
        if (transactionUID == null || transactionInfo == null) {
            throw new NullPointerException();
        }
        int n = 0;
        BrokerAddress brokerAddress = null;
        TransactionBroker[] transactionBrokerArray = null;
        if (transactionInfo.isCluster()) {
            n = 2;
            transactionBrokerArray = transactionInfo.getTransactionBrokers();
        } else if (transactionInfo.isRemote()) {
            n = 3;
            brokerAddress = transactionInfo.getTransactionHomeBroker();
        } else if (transactionInfo.isLocal()) {
            n = 1;
        } else {
            String string = "Illegal transaction type: " + transactionInfo.getType();
            logger.log(32, "B3100", string);
            throw new BrokerException(br.getKString("B3100", string));
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionInfo.getTransactionState(), brokerAddress, transactionBrokerArray, n, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (transactionUID == null || transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeClusterTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionState, null, transactionBrokerArray, 2, this.getStoreSession());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateClusterTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionBrokers(null, transactionUID, transactionBrokerArray);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateClusterTransactionBrokerState() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionBrokerState(null, transactionUID, n, transactionBroker);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteTransaction(TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (!Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in non-HA mode");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateRemoteTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                        for (TransactionAcknowledgement transactionAcknowledgement : transactionAcknowledgementArray) {
                            if (!transactionAcknowledgement.shouldStore()) continue;
                            this.daoFactory.getConsumerStateDAO().updateTransaction(connection, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                        }
                    }
                    this.daoFactory.getTransactionDAO().updateTransactionHomeBroker(connection, transactionUID, brokerAddress);
                    connection.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in HA mode");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeRemoteTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(connection, transactionUID, transactionState, brokerAddress, null, 3, this.getStoreSession());
                    if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                        for (TransactionAcknowledgement transactionAcknowledgement : transactionAcknowledgementArray) {
                            if (!transactionAcknowledgement.shouldStore()) continue;
                            this.daoFactory.getConsumerStateDAO().updateTransaction(connection, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                        }
                    }
                    connection.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.updateProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getPropertyDAO().update(null, string, object);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object getProperty(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object object = this.daoFactory.getPropertyDAO().getProperty(null, string);
                    return object;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    String[] stringArray = this.daoFactory.getPropertyDAO().getPropertyNames(null).toArray(new String[0]);
                    return stringArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Properties properties = this.daoFactory.getPropertyDAO().getProperties(null);
                    return properties;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeConfigChangeRecord() called");
        }
        if (l <= 0L) {
            String string = String.valueOf(l);
            logger.log(32, "B3074", string);
            throw new BrokerException(br.getKString("B3074", string));
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().insert(null, byArray, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public ArrayList getConfigChangeRecordsSince(long l) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    ArrayList arrayList = (ArrayList)this.daoFactory.getConfigRecordDAO().getRecordsSince(null, l);
                    return arrayList;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object[] getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object[] objectArray = this.daoFactory.getConfigRecordDAO().getAllRecords(null);
                    return objectArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().deleteAll(null);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    if (Globals.getHAEnabled()) {
                        this.daoFactory.getTransactionDAO().deleteAll(connection);
                        this.daoFactory.getDestinationDAO().deleteAll(connection);
                        this.daoFactory.getConsumerStateDAO().deleteAll(connection);
                        this.daoFactory.getMessageDAO().deleteAll(connection);
                    } else {
                        List list = this.daoFactory.getAllDAOs();
                        for (BaseDAO baseDAO : list) {
                            if (baseDAO instanceof VersionDAO || baseDAO instanceof BrokerDAO || baseDAO instanceof StoreSessionDAO) continue;
                            baseDAO.deleteAll(connection);
                        }
                    }
                    connection.commit();
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        throw new BrokerException(br.getKString("B4081"), exception2);
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void close(boolean bl) {
        this.setClosedAndWait();
        this.closeDB(true);
        if (DEBUG) {
            logger.log(4, "JDBCStore.close(" + bl + ") done.");
        }
    }

    public long getBrokerHeartbeat(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getBrokerDAO().getHeartbeat(null, string);
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllHeartbeats(null);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerHeartbeat(String string, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string, l);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 4);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerHeartbeat(String string, long l, long l2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string, l, l2);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 4);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void addBrokerInfo(String string, String string2, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, string, null, string2, n, brokerState.intValue(), l, l2);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void addBrokerInfo(HABrokerInfo hABrokerInfo, boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, hABrokerInfo.getId(), hABrokerInfo.getTakeoverBrokerID(), hABrokerInfo.getUrl(), hABrokerInfo.getVersion(), hABrokerInfo.getState(), -1L, hABrokerInfo.getHeartbeat());
                    List list = hABrokerInfo.getAllSessions();
                    if (list != null && !list.isEmpty()) {
                        StoreSessionDAO storeSessionDAO = this.daoFactory.getStoreSessionDAO();
                        for (HABrokerInfo.StoreSession storeSession : list) {
                            storeSessionDAO.insert(null, storeSession.getBrokerID(), storeSession.getID(), storeSession.getIsCurrent(), storeSession.getCreatedBy(), storeSession.getCreatedTS());
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateBrokerInfo(String string, String string2, String string3, int n, BrokerState brokerState, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().update(null, string, string2, string3, n, brokerState.intValue(), l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().getBrokerInfo(null, string);
                    return hABrokerInfo;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllBrokerInfos(boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfos(null, bl);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
        if (brokerState == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfosByState(null, brokerState);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public String getStoreSessionOwner(long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    String string = this.daoFactory.getStoreSessionDAO().getStoreSessionOwner(null, l);
                    return string;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public String getStoreSessionCreator(long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    String string = this.daoFactory.getStoreSessionDAO().getStoreSessionCreator(null, l);
                    return string;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateState(null, string, brokerState, brokerState2);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 5);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public BrokerState getBrokerState(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    BrokerState brokerState = this.daoFactory.getBrokerDAO().getState(null, string);
                    return brokerState;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object[] getAllBrokerStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object[] objectArray = this.daoFactory.getBrokerDAO().getAllStates(null);
                    return objectArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2, boolean bl, TakingoverTracker takingoverTracker) throws TakeoverLockException, BrokerException {
        TakeoverStoreInfo takeoverStoreInfo;
        Connection connection;
        block20: {
            this.checkClosedAndSetInProgress();
            takingoverTracker.setStage_BEFORE_GET_LOCK();
            connection = null;
            HashMap hashMap = this.takeoverLockMap;
            // MONITORENTER : hashMap
            takeoverStoreInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(string2);
            if (takeoverStoreInfo == null) break block20;
            logger.logToAll(16, "B2109", string2);
            // MONITOREXIT : hashMap
            try {
                Util.close(null, null, connection);
                return;
            }
            finally {
                this.setInProgress(false);
            }
        }
        connection = this.dbmgr.getConnection(true);
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            try {
                HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().takeover(connection, string, string2, l, brokerState, l2, brokerState2);
                takingoverTracker.setStage_AFTER_GET_LOCK();
                long l3 = System.currentTimeMillis();
                logger.logToAll(8, "B1168", string2, String.valueOf(l3));
                takeoverStoreInfo = new TakeoverStoreInfo(string2, hABrokerInfo, l3);
                this.takeoverLockMap.put(string2, takeoverStoreInfo);
                Map map = this.daoFactory.getMessageDAO().getMsgIDsAndDstIDsByBroker(connection, string2);
                takingoverTracker.setMessageMap(map);
                // MONITOREXIT : hashMap
            }
            catch (Exception exception) {
                try {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                catch (Throwable throwable) {
                    try {
                        Util.close(null, null, connection);
                        throw throwable;
                    }
                    finally {
                        this.setInProgress(false);
                    }
                }
            }
            try {
                Util.close(null, null, connection);
                return;
            }
            finally {
                this.setInProgress(false);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TakeoverStoreInfo takeOverBrokerStore(String string, String string2, TakingoverTracker takingoverTracker) throws BrokerException {
        this.checkClosedAndSetInProgress();
        takingoverTracker.setStage_BEFORE_TAKE_STORE();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            BrokerDAO brokerDAO = this.daoFactory.getBrokerDAO();
            HABrokerInfo hABrokerInfo = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    hABrokerInfo = brokerDAO.getBrokerInfo(connection, string2);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
            if (hABrokerInfo == null) {
                String string3 = br.getKString("B3169", string2);
                logger.log(32, "B3100", string3);
                throw new BrokerException(br.getKString("B3100", string3));
            }
            TakeoverStoreInfo takeoverStoreInfo = null;
            Object object = this.takeoverLockMap;
            synchronized (object) {
                takeoverStoreInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(string2);
            }
            if (takeoverStoreInfo == null || !string.equals(hABrokerInfo.getTakeoverBrokerID())) {
                logger.log(32, "B3173", string2);
                throw new BrokerException(br.getKString("B3173", string2));
            }
            retryStrategy = null;
            while (true) {
                try {
                    object = this.daoFactory.getDestinationDAO();
                    List list = object.getAllLocalDestinations(connection, string2);
                    takeoverStoreInfo.setDestinationList(list);
                    Object[] objectArray = new String[]{String.valueOf(list.size()), string2, list.toString()};
                    logger.log(8, br.getString("B1291", objectArray));
                    MessageDAO messageDAO = this.daoFactory.getMessageDAO();
                    Map map = messageDAO.getMsgIDsAndDstIDsByBroker(connection, string2);
                    takeoverStoreInfo.setMessageMap(map);
                    logger.log(8, br.getString("B1292", map.size(), string2));
                    TransactionDAO transactionDAO = this.daoFactory.getTransactionDAO();
                    List list2 = transactionDAO.getTransactionsByBroker(connection, string2);
                    takeoverStoreInfo.setTransactionList(list2);
                    logger.log(8, br.getString("B1293", list2.size(), string2));
                    List list3 = transactionDAO.getRemoteTransactionsByBroker(connection, string2);
                    takeoverStoreInfo.setRemoteTransactionList(list3);
                    logger.log(8, br.getString("B1294", list3.size(), string2));
                    takingoverTracker.setStage_BEFORE_DB_SWITCH_OWNER();
                    StoreSessionDAO storeSessionDAO = this.daoFactory.getStoreSessionDAO();
                    List list4 = storeSessionDAO.takeover(connection, string, string2);
                    Object[] objectArray2 = new String[]{String.valueOf(list4.size()), string2, list4.toString()};
                    logger.log(8, br.getString("B1295", objectArray2));
                    connection.commit();
                    takingoverTracker.setStage_AFTER_DB_SWITCH_OWNER();
                    Object object2 = this.takeoverLockMap;
                    synchronized (object2) {
                        this.takeoverLockMap.remove(string2);
                    }
                    takingoverTracker.setStage_AFTER_TAKE_STORE();
                    object2 = takeoverStoreInfo;
                    return object2;
                }
                catch (Exception exception) {
                    try {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.logToAll(8, "B1169", string2);
                        HABrokerInfo hABrokerInfo2 = takeoverStoreInfo.getSavedBrokerInfo();
                        try {
                            retryStrategy = null;
                            while (true) {
                                try {
                                    brokerDAO.updateHeartbeat(connection, string2, hABrokerInfo2.getHeartbeat());
                                    brokerDAO.update(connection, string2, null, hABrokerInfo2.getUrl(), hABrokerInfo2.getVersion(), hABrokerInfo2.getState(), hABrokerInfo2.getSessionID());
                                    connection.commit();
                                    HashMap hashMap = this.takeoverLockMap;
                                    synchronized (hashMap) {
                                        this.takeoverLockMap.remove(string2);
                                    }
                                }
                                catch (Exception exception2) {
                                    if (retryStrategy == null) {
                                        retryStrategy = new Util.RetryStrategy();
                                    }
                                    retryStrategy.assertShouldRetry(exception2);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception exception3) {
                            logger.logStack(32, "B3171", string2, (Throwable)exception3);
                        }
                        throw new BrokerException(br.getKString("B3172", string2), throwable);
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void updateTransactionAccessedTime(TransactionUID transactionUID, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateAccessedTime(null, transactionUID, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionState transactionState = this.daoFactory.getTransactionDAO().getTransactionState(null, transactionUID);
                    return transactionState;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    BrokerAddress brokerAddress = this.daoFactory.getTransactionDAO().getTransactionHomeBroker(null, transactionUID);
                    return brokerAddress;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionBroker[] transactionBrokerArray = this.daoFactory.getTransactionDAO().getTransactionBrokers(null, transactionUID);
                    return transactionBrokerArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public long getTransactionAccessedTime(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getTransactionDAO().getAccessedTime(null, transactionUID);
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionInfo transactionInfo = this.daoFactory.getTransactionDAO().getTransactionInfo(null, transactionUID);
                    return transactionInfo;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Collection getTransactions(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    List list = this.daoFactory.getTransactionDAO().getTransactionsByBroker(null, string);
                    return list;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int[] getTransactionUsageInfo(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    int[] nArray = this.daoFactory.getTransactionDAO().getTransactionUsageInfo(null, transactionUID);
                    return nArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getDestinationDAO().getDestinationConnectedTime(null, destination.getUniqueName());
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getMessageDAO().hasMessageBeenAcked(null, destinationUID, sysMessageID);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateDestinationConnectedTime(Destination destination, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().updateConnectedTime(null, destination, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDB(boolean bl) {
        Connection connection = null;
        try {
            if (bl) {
                connection = this.dbmgr.getConnection(true);
                if (!Globals.getHAEnabled() && config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                    DBManager.lockTables(connection, false);
                }
            }
        }
        catch (Exception exception) {
            logger.log(16, "B4103", exception);
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            catch (Exception exception) {}
        }
        this.dbmgr.close();
    }

    public String getStoreType() {
        return "jdbc";
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() throws BrokerException {
        String string = this.dbmgr.getOpenDBURL();
        String string2 = "(" + this.dbmgr.getBrokerID() + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("JDBC-based store", string + string2);
        hashtable.put("Store version", String.valueOf(410));
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Iterator iterator = this.daoFactory.getAllDAOs().iterator();
            while (iterator.hasNext()) {
                hashtable.putAll(((BaseDAO)iterator.next()).getDebugInfo(connection));
            }
        }
        finally {
            Util.close(null, null, connection);
        }
        return hashtable;
    }

    public void compactDestination(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    private boolean checkStore(Connection connection) throws BrokerException {
        boolean bl = true;
        int n = -1;
        if (this.checkOldStoreVersion(connection, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
            n = 400;
        } else if (this.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
            n = 370;
        } else if (this.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
            n = 350;
        }
        boolean bl2 = false;
        int n2 = 0;
        try {
            n2 = this.daoFactory.getVersionDAO().getStoreVersion(connection);
        }
        catch (BrokerException brokerException) {
            logger.log(16, brokerException.getMessage(), brokerException.getCause());
        }
        if (n2 > 0) {
            boolean bl3 = bl2 = n2 == 410;
            if (bl2) {
                if (this.dbmgr.checkStoreExists(connection) == -1) {
                    logger.log(32, "B3213");
                    throw new BrokerException(br.getKString("B3213"));
                }
            } else {
                String string = String.valueOf(n2);
                String string2 = String.valueOf(410);
                logger.log(32, "B3092", (Object)string, string2);
                throw new BrokerException(br.getKString("B3092", string, string2));
            }
            if (n > 0 && !this.removeStore) {
                logger.logToAll(8, "B1111");
            }
        }
        if (bl2) {
            if (this.removeStore) {
                try {
                    DBTool.dropTables(connection, null);
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(br.getKString("B3121", this.dbmgr.getOpenDBURL()), sQLException);
                }
                bl = false;
            } else if (this.resetStore) {
                this.clearAll(true);
            }
        } else {
            boolean bl4 = false;
            if (this.createStore) {
                bl4 = true;
            }
            boolean bl5 = false;
            String string = null;
            if (n > 0) {
                if (this.removeStore) {
                    bl5 = true;
                    string = "B1112";
                } else if (this.resetStore) {
                    bl4 = true;
                    bl5 = true;
                    string = "B1113";
                } else {
                    logger.logToAll(8, "B1109", new Integer(n));
                    if (this.upgradeNoBackup && !Broker.getBroker().force) {
                        this.getConfirmation();
                    }
                    if (!Globals.getHAEnabled()) {
                        new UpgradeStore(this, n).upgradeStore(connection);
                        return bl;
                    }
                }
            }
            if (!bl4) {
                logger.log(32, "B3132");
                throw new BrokerException(br.getKString("B3132"));
            }
            if (bl5) {
                logger.logToAll(8, string);
                try {
                    DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
                }
                catch (Exception exception) {
                    logger.logToAll(32, "B3133", exception);
                    throw new BrokerException(br.getKString("B3133"), exception);
                }
            }
            if (bl4) {
                logger.logToAll(8, "B1114");
                try {
                    DBTool.createTables(connection);
                }
                catch (Exception exception) {
                    String string3 = this.dbmgr.getCreateDBURL();
                    if (string3 == null || string3.length() == 0) {
                        string3 = this.dbmgr.getOpenDBURL();
                    }
                    String string4 = br.getKString("B3073", string3);
                    logger.logToAll(32, string4, exception);
                    throw new BrokerException(string4, exception);
                }
            }
        }
        return bl;
    }

    private long getStoreSession() throws BrokerException {
        if (Globals.getHAEnabled()) {
            return Globals.getStoreSession().longValue();
        }
        StoreSessionDAO storeSessionDAO = this.daoFactory.getStoreSessionDAO();
        return storeSessionDAO.getStoreSession(null, this.dbmgr.getBrokerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkOldStoreVersion(Connection var1_1, String var2_2, String var3_3, int var4_4) throws BrokerException {
        try {
            var5_5 = "SELECT " + var3_3 + " FROM " + var2_2;
            var6_7 = null;
            var7_8 = null;
            try {
                var6_7 = var1_1.createStatement();
                var7_8 = var6_7.executeQuery(var5_5);
                if (!var7_8.next()) ** GOTO lbl27
                var8_9 = var7_8.getInt(1);
                if (var8_9 == var4_4) {
                    var9_11 = true;
                }
                ** GOTO lbl-1000
            }
            catch (SQLException var8_10) {
                JDBCStore.logger.log(4, "Assume old store does not exist because : " + var8_10.getMessage());
                Util.close(var7_8, var6_7, null);
                return false;
            }
            catch (Throwable var11_14) {
                Util.close(var7_8, var6_7, null);
                throw var11_14;
            }
            Util.close(var7_8, var6_7, null);
            return var9_11;
lbl-1000:
            // 1 sources

            {
                var9_12 = String.valueOf(var8_9);
                var10_13 = String.valueOf(var4_4);
                JDBCStore.logger.log(32, "B3125", (Object)var9_12, var10_13);
                throw new BrokerException(JDBCStore.br.getKString("B3125", var9_12, var10_13));
lbl27:
                // 1 sources

                JDBCStore.logger.log(32, "B3131", var2_2);
                throw new BrokerException(JDBCStore.br.getKString("B3131", var2_2));
            }
        }
        catch (Exception var5_6) {
            JDBCStore.logger.log(32, "B4114", var5_6);
            throw new BrokerException(JDBCStore.br.getKString("B4114"), var5_6);
        }
    }

    boolean resetMessage() {
        return this.resetMessage;
    }

    boolean resetInterest() {
        return this.resetInterest;
    }

    static class StoreSessionReaperTask
    extends TimerTask {
        private boolean canceled = false;
        Logger logger = Globals.getLogger();
        JDBCStore store = null;

        public StoreSessionReaperTask(JDBCStore jDBCStore) {
            this.store = jDBCStore;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
            }
            try {
                object = this.store.daoFactory.getStoreSessionDAO();
                object.deleteInactiveStoreSession(null);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3177", exception);
            }
        }
    }
}

