/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConfigRecordDAOImpl
extends BaseDAOImpl
implements ConfigRecordDAO {
    protected String tableName;
    protected String insertSQL;
    protected String selectRecordsSinceSQL;
    protected String selectAllSQL;

    ConfigRecordDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCREC41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        this.selectRecordsSinceSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("CREATED_TS").append(" > ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQCREC41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, byte[] byArray, long l) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.insertSQL);
            Util.setBytes(preparedStatement, 1, byArray);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4083", String.valueOf(l)), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public List getRecordsSince(Connection connection, long l) throws BrokerException {
        ArrayList<byte[]> arrayList;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                arrayList = new ArrayList<byte[]>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectRecordsSinceSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList.add(byArray);
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectRecordsSinceSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", resultSet.getString(2), (Throwable)iOException2);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectRecordsSinceSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4082"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public Object[] getAllRecords(Connection connection) throws BrokerException {
        Object[] objectArray;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
                objectArray = new Object[]{arrayList, arrayList2};
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = -1L;
                        try {
                            l = resultSet.getLong(2);
                            arrayList.add(new Long(l));
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList2.add(byArray);
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectAllSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", String.valueOf(l), (Throwable)iOException2);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4082"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return objectArray;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Config Change Records(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

