/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tls;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.net.tls.TLSStreams;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.KeystoreUtil;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class TLSProtocol
extends TcpProtocol {
    private static boolean DEBUG = false;
    private static final int defaultPort = 11001;
    private static boolean TLS_ALLOWED = false;
    private static ServerSocketFactory ssfactory = null;
    protected static Logger logger = Globals.getLogger();
    protected static BrokerResources br = Globals.getBrokerResources();
    private static final Object classlock;

    public static void init() {
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
    }

    public static void destroy() {
        ssfactory = null;
        Object var0 = null;
        br = null;
    }

    public TLSProtocol() {
        this.canChangeBlocking = false;
        this.port = 11001;
        if (!TLS_ALLOWED) {
            Globals.getLogger().log(32, "B3123", Globals.getBrokerResources().getString("B0036"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0036")), 2);
        }
    }

    public ProtocolStreams accept() throws IOException {
        if (this.serversocket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Unable to accept on un-opened protocol"));
        }
        SSLSocket sSLSocket = (SSLSocket)this.serversocket.accept();
        try {
            sSLSocket.setTcpNoDelay(this.nodelay);
        }
        catch (SocketException socketException) {
            Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + sSLSocket.toString() + "]setTcpNoDelay(" + this.nodelay + "): " + socketException.toString(), socketException);
        }
        TLSStreams tLSStreams = this.createConnection(sSLSocket);
        return tLSStreams;
    }

    public String toString() {
        return "SSL/TLS [ " + this.port + "," + this.backlog + "]";
    }

    protected ServerSocket createSocket(String string, int n, int n2, boolean bl, boolean bl2) throws IOException {
        ServerSocketFactory serverSocketFactory = TLSProtocol.getServerSocketFactory();
        if (string != null && !string.equals("*")) {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.serversocket = serverSocketFactory.createServerSocket(n, n2, inetAddress);
        } else {
            this.serversocket = serverSocketFactory.createServerSocket(n, n2);
        }
        if (DEBUG && this.serversocket != null) {
            logger.log(4, "TLSProtocol: " + this.serversocket + " " + MQServerSocketFactory.serverSocketToString(this.serversocket) + ", backlog=" + n2 + "");
        }
        return this.serversocket;
    }

    protected TLSStreams createConnection(SSLSocket sSLSocket) throws IOException {
        return new TLSStreams(sSLSocket, this.inputBufferSize, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocketFactory getServerSocketFactory() throws IOException {
        Object object = classlock;
        synchronized (object) {
            if (ssfactory == null) {
                try {
                    String string = KeystoreUtil.getKeystoreLocation();
                    File file = new File(string);
                    if (!file.exists()) {
                        throw new IOException(br.getKString("B3019", string));
                    }
                    String string2 = KeystoreUtil.getKeystorePassword();
                    if (string2 == null) {
                        string2 = "";
                        logger.log(32, br.getKString("B3021"));
                    }
                    char[] cArray = string2.toCharArray();
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(new FileInputStream(string), cArray);
                    keyManagerFactory.init(keyStore, cArray);
                    TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
                    SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
                    ssfactory = MQServerSocketFactory.wrapFactory(sSLContext.getServerSocketFactory());
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    logger.logStack(32, br.getKString("B4022"), exception);
                    throw new IOException(exception.getMessage());
                }
            }
            return ssfactory;
        }
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            TLS_ALLOWED = licenseBase.getBooleanProperty("imq.enable_ssl", false);
        }
        catch (BrokerException brokerException) {
            TLS_ALLOWED = false;
        }
        classlock = new Object();
    }
}

