/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class TransactionUtil {
    private static final String[] transactionInfoMonitorItemNames = new String[]{"ClientID", "ConnectionString", "CreationTime", "NumAcks", "NumMsgs", "State", "StateLabel", "TransactionID", "User", "XID"};
    private static final String[] transactionInfoMonitorItemDesc = transactionInfoMonitorItemNames;
    private static final OpenType[] transactionInfoMonitorItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    private static CompositeType monitorCompType = null;

    public static int toExternalTransactionState(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return -1;
    }

    public static int toInternalTransactionState(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return -1;
    }

    public static String[] getTransactionIDs() {
        TransactionList transactionList = Globals.getTransactionList();
        Vector vector = transactionList.getTransactions(-1);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TransactionUID transactionUID = (TransactionUID)enumeration.nextElement();
            long l = transactionUID.longValue();
            stringArray[n] = Long.toString(l);
            ++n;
        }
        return stringArray;
    }

    public static CompositeData[] getTransactionInfo() throws BrokerException, OpenDataException {
        String[] stringArray = TransactionUtil.getTransactionIDs();
        if (stringArray == null) {
            return null;
        }
        CompositeData[] compositeDataArray = new CompositeData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            compositeDataArray[i] = TransactionUtil.getTransactionInfo(stringArray[i]);
        }
        return compositeDataArray;
    }

    public static CompositeData getTransactionInfo(String string) throws BrokerException, OpenDataException {
        CompositeData compositeData = null;
        TransactionUID transactionUID = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string == null) {
            throw new IllegalArgumentException(brokerResources.getString("B4269"));
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(brokerResources.getString("B4270", string));
        }
        transactionUID = new TransactionUID(l);
        if (transactionUID == null) {
            throw new BrokerException(brokerResources.getString("B4271", string));
        }
        compositeData = TransactionUtil.getTransactionInfo(transactionUID);
        return compositeData;
    }

    public static String getClientID(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (transactionState == null) {
            return null;
        }
        return transactionState.getClientID();
    }

    public static String getConnectionString(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (transactionState == null) {
            return null;
        }
        return transactionState.getConnectionString();
    }

    public static Long getCreationTime(TransactionUID transactionUID) {
        return new Long(System.currentTimeMillis() - transactionUID.age());
    }

    public static Long getNumAcks(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        return new Long(transactionList.retrieveNConsumedMessages(transactionUID));
    }

    public static Long getNumMsgs(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        return new Long(transactionList.retrieveNSentMessages(transactionUID));
    }

    public static Integer getState(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (transactionState == null) {
            return null;
        }
        return new Integer(TransactionUtil.toExternalTransactionState(transactionState.getState()));
    }

    public static String getStateLabel(TransactionUID transactionUID) {
        Integer n = TransactionUtil.getState(transactionUID);
        if (n == null) {
            return null;
        }
        return com.sun.messaging.jms.management.server.TransactionState.toString(n);
    }

    public static String getUser(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (transactionState == null) {
            return null;
        }
        return transactionState.getUser();
    }

    public static String getXID(TransactionUID transactionUID) {
        TransactionList transactionList = Globals.getTransactionList();
        if (transactionList == null) {
            return null;
        }
        JMQXid jMQXid = transactionList.UIDToXid(transactionUID);
        if (jMQXid == null) {
            return null;
        }
        return jMQXid.toString();
    }

    private static CompositeData getTransactionInfo(TransactionUID transactionUID) throws OpenDataException {
        Object[] objectArray = new Object[]{TransactionUtil.getClientID(transactionUID), TransactionUtil.getConnectionString(transactionUID), TransactionUtil.getCreationTime(transactionUID), TransactionUtil.getNumAcks(transactionUID), TransactionUtil.getNumMsgs(transactionUID), TransactionUtil.getState(transactionUID), TransactionUtil.getStateLabel(transactionUID), Long.toString(transactionUID.longValue()), TransactionUtil.getUser(transactionUID), TransactionUtil.getXID(transactionUID)};
        CompositeDataSupport compositeDataSupport = null;
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("TransactionMonitorInfo", "TransactionMonitorInfo", transactionInfoMonitorItemNames, transactionInfoMonitorItemDesc, transactionInfoMonitorItemTypes);
        }
        compositeDataSupport = new CompositeDataSupport(monitorCompType, transactionInfoMonitorItemNames, objectArray);
        return compositeDataSupport;
    }
}

