/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ConsumerUtil {
    private static final String[] consumerInfoMonitorItemNames = new String[]{"AcknowledgeMode", "AcknowledgeModeLabel", "ClientID", "ConnectionID", "ConsumerID", "DestinationName", "DestinationType", "Durable", "DurableActive", "DurableName", "FlowPaused", "Host", "LastAckTime", "NumMsgs", "NumMsgsPendingAcks", "Selector", "ServiceName", "User"};
    private static final String[] consumerInfoMonitorItemDesc = consumerInfoMonitorItemNames;
    private static final OpenType[] consumerInfoMonitorItemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    private static CompositeType monitorCompType = null;

    public static int toExternalAckMode(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static String toExternalAckModeString(int n) {
        switch (n) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 32768: {
                return "NO_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN";
    }

    public static int toInternalAckMode(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    public static HashMap getAllConsumersNoChildren() {
        Iterator iterator = Consumer.getAllConsumers();
        HashMap<ConsumerUID, Consumer> hashMap = new HashMap<ConsumerUID, Consumer>();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (consumer.getSubscription() != null) continue;
            hashMap.put(consumerUID, consumer);
        }
        return hashMap;
    }

    public static int getNumConsumersNoChildren() {
        return ConsumerUtil.getAllConsumersNoChildren().size();
    }

    public static boolean isDurable(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isDurableSubscriber();
        }
        return false;
    }

    public static boolean isDurableActive(ConsumerUID consumerUID) {
        if (!ConsumerUtil.isDurable(consumerUID)) {
            return false;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isActive();
        }
        return false;
    }

    public static ConnectionUID getConnectionUID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ConnectionUID connectionUID = null;
        if (ConsumerUtil.isDurable(consumerUID) && !ConsumerUtil.isDurableActive(consumerUID)) {
            return null;
        }
        if (consumer != null) {
            connectionUID = consumer.getConnectionUID();
        }
        return connectionUID;
    }

    public static Destination getDestination(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        Destination destination = null;
        if (consumer != null) {
            destination = consumer.getDestination();
        }
        return destination;
    }

    public static String[] getConsumerIDs() {
        int n = 0;
        HashSet hashSet = new HashSet(ConsumerUtil.getAllConsumersNoChildren().values());
        n = hashSet.size();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string;
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            stringArray[n2] = string = Long.toString(l);
            ++n2;
        }
        return stringArray;
    }

    public static CompositeData[] getConsumerInfo() throws BrokerException, OpenDataException {
        String[] stringArray = ConsumerUtil.getConsumerIDs();
        if (stringArray == null) {
            return null;
        }
        CompositeData[] compositeDataArray = new CompositeData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            compositeDataArray[i] = ConsumerUtil.getConsumerInfo(stringArray[i]);
        }
        return compositeDataArray;
    }

    public static CompositeData getConsumerInfo(String string) throws BrokerException, OpenDataException {
        CompositeData compositeData = null;
        ConsumerUID consumerUID = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string == null) {
            throw new IllegalArgumentException(brokerResources.getString("B4259"));
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(brokerResources.getString("B4260", string));
        }
        consumerUID = new ConsumerUID(l);
        if (consumerUID == null) {
            throw new BrokerException(brokerResources.getString("B4261", string));
        }
        compositeData = ConsumerUtil.getConsumerInfo(consumerUID);
        return compositeData;
    }

    private static Integer getAcknowledgeMode(ConsumerUID consumerUID) {
        return new Integer(ConsumerUtil.toExternalAckMode(consumerUID.getAckType()));
    }

    private static String getAcknowledgeModeLabel(ConsumerUID consumerUID) {
        return ConsumerUtil.toExternalAckModeString(consumerUID.getAckType());
    }

    private static String getClientID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getClientID();
    }

    private static String getConnectionID(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    private static String getDestinationName(ConsumerUID consumerUID) {
        Destination destination = ConsumerUtil.getDestination(consumerUID);
        if (destination == null) {
            return null;
        }
        return destination.getDestinationName();
    }

    private static String getDestinationType(ConsumerUID consumerUID) {
        Destination destination = ConsumerUtil.getDestination(consumerUID);
        if (destination == null) {
            return null;
        }
        return destination.isQueue() ? "q" : "t";
    }

    private static Boolean getDurable(ConsumerUID consumerUID) {
        return new Boolean(ConsumerUtil.isDurable(consumerUID));
    }

    private static Boolean getDurableActive(ConsumerUID consumerUID) {
        if (!ConsumerUtil.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        return new Boolean(ConsumerUtil.isDurableActive(consumerUID));
    }

    private static String getDurableName(ConsumerUID consumerUID) {
        if (!ConsumerUtil.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof Subscription) {
            return ((Subscription)consumer).getDurableName();
        }
        Subscription subscription = consumer.getSubscription();
        if (subscription != null) {
            return subscription.getDurableName();
        }
        return null;
    }

    private static Boolean getFlowPaused(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Boolean(consumer.getIsFlowPaused());
    }

    private static String getHost(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        String string = null;
        if (connectionInfo.remoteIP != null) {
            string = String.valueOf(IPAddress.rawIPToString(connectionInfo.remoteIP, true, true));
        }
        return string;
    }

    private static Long getLastAckTime(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.getLastAckTime());
    }

    private static Long getNumMsgs(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.totalMsgsDelivered());
    }

    private static Long getNumMsgsPendingAcks(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.numPendingAcks());
    }

    private static String getSelector(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getSelectorStr();
    }

    private static String getServiceName(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        String string = ConnectionUtil.getServiceOfConnection(connectionUID.longValue());
        return string;
    }

    private static String getUser(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = ConsumerUtil.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.user;
    }

    private static CompositeData getConsumerInfo(ConsumerUID consumerUID) throws OpenDataException {
        CompositeDataSupport compositeDataSupport = null;
        Consumer consumer = Consumer.getConsumer(consumerUID);
        Object[] objectArray = new Object[]{ConsumerUtil.getAcknowledgeMode(consumerUID), ConsumerUtil.getAcknowledgeModeLabel(consumerUID), ConsumerUtil.getClientID(consumerUID), ConsumerUtil.getConnectionID(consumerUID), Long.toString(consumerUID.longValue()), ConsumerUtil.getDestinationName(consumerUID), ConsumerUtil.getDestinationType(consumerUID), ConsumerUtil.getDurable(consumerUID), ConsumerUtil.getDurableActive(consumerUID), ConsumerUtil.getDurableName(consumerUID), ConsumerUtil.getFlowPaused(consumerUID), ConsumerUtil.getHost(consumerUID), ConsumerUtil.getLastAckTime(consumerUID), ConsumerUtil.getNumMsgs(consumerUID), ConsumerUtil.getNumMsgsPendingAcks(consumerUID), ConsumerUtil.getSelector(consumerUID), ConsumerUtil.getServiceName(consumerUID), ConsumerUtil.getUser(consumerUID)};
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("ConsumerMonitorInfo", "ConsumerMonitorInfo", consumerInfoMonitorItemNames, consumerInfoMonitorItemDesc, consumerInfoMonitorItemTypes);
        }
        compositeDataSupport = new CompositeDataSupport(monitorCompType, consumerInfoMonitorItemNames, objectArray);
        return compositeDataSupport;
    }
}

