/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class ClientIDHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    static boolean CAN_USE_SHARED_CONSUMERS = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block14: {
            block13: {
                Hashtable hashtable2;
                String string;
                int n;
                block12: {
                    boolean bl = packet.getIndempontent();
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setConsumerID(packet.getConsumerID());
                    packet2.setPacketType(51);
                    hashtable = new Hashtable<String, Object>();
                    n = 200;
                    string = null;
                    hashtable2 = null;
                    try {
                        hashtable2 = packet.getProperties();
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from clientID message " + packet, exception);
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError();
                    }
                }
                String string2 = null;
                boolean bl = false;
                String string3 = null;
                if (hashtable2 != null) {
                    string2 = (String)hashtable2.get("JMQClientID");
                    string3 = (String)hashtable2.get("JMQNamespace");
                    Boolean bl2 = (Boolean)hashtable2.get("JMQShare");
                    bl = bl2 == null ? string3 != null : bl2;
                } else assert (false);
                this.logger.log(4, "ClientID[" + string3 + "," + string2 + "," + bl + "] ");
                if (DEBUG) {
                    this.logger.log(4, "ClientIDHandler: registering clientID " + string2);
                }
                try {
                    n = 200;
                    string = null;
                    this.setClientID(iMQConnection, string2, string3, bl);
                }
                catch (BrokerException brokerException) {
                    n = brokerException.getStatusCode();
                    string = brokerException.getMessage();
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                if (IMQIPConnection.getDumpPacket()) break block13;
                IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                if (!IMQIPConnection.getDumpOutPacket()) break block14;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    private String validate(String string, Connection connection) throws BrokerException {
        String string2 = string;
        if (string != null) {
            if (string.startsWith("${u}")) {
                AccessController accessController = connection.getAccessController();
                String string3 = accessController.getAuthenticatedName().getName();
                string2 = "${u:" + string3 + "}" + string.substring(4);
            } else if (string.startsWith("${u:")) {
                string2 = null;
            } else if (string.indexOf("${%%}") != -1) {
                this.logger.log(4, "bad client id ${%%}");
                string2 = null;
            }
        }
        if (string2 == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4109", string == null ? "null" : string));
        }
        if (DEBUG) {
            this.logger.log(4, "ClientIDHandler:validated client ID:" + string2 + ":");
        }
        return string2;
    }

    public void setClientID(IMQConnection iMQConnection, String string, String string2, boolean bl) throws BrokerException {
        int n = 200;
        String string3 = null;
        try {
            String string4;
            String string5 = string4 = string == null ? null : this.validate(string, iMQConnection);
            if (bl && !CAN_USE_SHARED_CONSUMERS) {
                this.logger.log(16, "B4180", (Object)Globals.getBrokerResources().getKString("B0072"), string4);
                throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0072"), string4), "B4180", null, 405);
            }
            String string6 = (String)iMQConnection.getClientData("client id");
            if (DEBUG && string6 != null) {
                this.logger.log(4, "ClientIDHandler: replacing clientID " + string6 + " with " + string4);
            }
            if (!(string4 == null || string6 != null && string6.equals(string4))) {
                String string7;
                String string8 = string7 = string2 == null ? null : string2 + "${%%}" + string;
                if (string7 != null && !Globals.getClusterBroadcast().lockClientID(string7, iMQConnection.getConnectionUID(), false)) {
                    this.logger.log(8, "B1033", (Object)iMQConnection.getRemoteConnectionString(), string7);
                    Connection connection = Globals.getConnectionManager().matchProperty("client id", string7);
                    assert (connection == null || connection instanceof IMQConnection);
                    if (connection == null) {
                        this.logger.log(8, "B1135", string7);
                    } else {
                        this.logger.log(8, "B1134", (Object)string7, ((IMQConnection)connection).getRemoteConnectionString());
                    }
                    string3 = "conflict w/ clientID";
                    n = 409;
                    throw new BrokerException(string3, n);
                }
                if (n != 409 && !Globals.getClusterBroadcast().lockClientID(string4, iMQConnection.getConnectionUID(), bl)) {
                    this.logger.log(8, "B1033", (Object)iMQConnection.getRemoteConnectionString(), string4);
                    Connection connection = Globals.getConnectionManager().matchProperty("client id", string4);
                    assert (connection == null || connection instanceof IMQConnection);
                    if (connection == null) {
                        this.logger.log(8, "B1135", string4);
                    } else {
                        this.logger.log(8, "B1134", (Object)string4, ((IMQConnection)connection).getRemoteConnectionString());
                    }
                    string3 = "conflict w/ clientID";
                    n = 409;
                    throw new BrokerException(string3, n);
                }
            } else if (string6 != null && !string6.equals(string4)) {
                this.logger.log(4, "ClientIDHandler: removing old clientID " + string6);
                Globals.getClusterBroadcast().unlockClientID(string6, iMQConnection.getConnectionUID());
                iMQConnection.removeClientData("client id");
            }
            if (string4 != null && n != 409) {
                iMQConnection.addClientData("client id", string4);
            }
        }
        catch (BrokerException brokerException) {
            if (brokerException.getStatusCode() == 409) {
                throw brokerException;
            }
            this.logger.log(16, "B2024", string, iMQConnection.toString(), brokerException);
            n = 400;
            string3 = brokerException.getMessage();
            throw new BrokerException(string3, brokerException, n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            this.logger.log(16, "B3100", (Object)"unexpected error processing clientid ", throwable);
            string3 = throwable.getMessage();
            n = 500;
            throw new BrokerException(string3, throwable, n);
        }
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            CAN_USE_SHARED_CONSUMERS = licenseBase.getBooleanProperty("imq.enable_shared_sub", false);
        }
        catch (BrokerException brokerException) {
            CAN_USE_SHARED_CONSUMERS = false;
        }
    }
}

