/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TransactionBroker
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 4331266333483540901L;
    private static transient Logger logger = Globals.getLogger();
    static final int PENDING = 0;
    static final int COMPLETE = 1;
    BrokerAddress broker = null;
    int state = 0;

    public TransactionBroker() {
    }

    public TransactionBroker(BrokerAddress brokerAddress) {
        this.broker = brokerAddress;
        this.state = 0;
    }

    public TransactionBroker(BrokerAddress brokerAddress, boolean bl) {
        this(brokerAddress);
        if (bl) {
            this.state = 1;
        }
    }

    public BrokerAddress getBrokerAddress() {
        return this.broker;
    }

    public boolean isCompleted() {
        return this.state == 1;
    }

    public void setCompleted(boolean bl) {
        this.state = bl ? 1 : 0;
    }

    public boolean copyState(TransactionBroker transactionBroker) throws BrokerException {
        if (this.state == transactionBroker.state) {
            return false;
        }
        if (this.state == 0) {
            this.state = transactionBroker.state;
            return true;
        }
        throw new BrokerException("Can't update transaction broker state from " + TransactionBroker.toString(this.state) + " to " + TransactionBroker.toString(transactionBroker.state));
    }

    public int hashCode() {
        return this.broker.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionBroker)) {
            return false;
        }
        return this.broker.equals(((TransactionBroker)object).broker);
    }

    public BrokerAddress getCurrentBrokerAddress() {
        if (!Globals.getHAEnabled()) {
            return this.getBrokerAddress();
        }
        String string = null;
        UID uID = this.broker.getStoreSessionUID();
        if (uID == null) {
            return null;
        }
        string = Globals.getClusterManager().lookupStoreSessionOwner(uID);
        if (string == null) {
            return null;
        }
        if (string.equals(Globals.getMyAddress().getBrokerID())) {
            return Globals.getMyAddress();
        }
        return Globals.getClusterBroadcast().lookupBrokerAddress(string);
    }

    public boolean isSame(HAClusteredBroker hAClusteredBroker) {
        if (!Globals.getHAEnabled()) {
            return false;
        }
        UID uID = this.broker.getStoreSessionUID();
        return uID.equals(hAClusteredBroker.getStoreSessionUID());
    }

    public String toString() {
        if (!Globals.getHAEnabled()) {
            return "[" + this.broker.toString() + "]" + (this.state == 1 ? "" : TransactionBroker.toString(this.state));
        }
        BrokerAddress brokerAddress = this.getCurrentBrokerAddress();
        return "[" + this.broker.toString() + "(" + (brokerAddress == null ? "" : brokerAddress.toString()) + ")]" + (this.state == 1 ? "" : TransactionBroker.toString(this.state));
    }

    private static String toString(int n) {
        if (n == 0) {
            return "PENDING";
        }
        if (n == 1) {
            return "COMPLETE";
        }
        return "UNKNOWN";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.state = objectInput.readInt();
        this.broker = (BrokerAddress)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.state);
        objectOutput.writeObject(this.broker);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("This should never happen!");
        }
    }
}

