/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RollingFileOutputStream
extends OutputStream {
    long file_size = 0L;
    File outfile;
    long rollover_bytes = 0L;
    long rollover_ms = 0L;
    long file_creation_time = 0L;
    private int num_files = 9;
    private FileOutputStream out;
    private static SharedResources rb = SharedResources.getResources();

    public RollingFileOutputStream(File file, long l, long l2) throws IOException {
        this.outfile = file;
        this.setRolloverBytes(l);
        this.setRolloverSecs(l2);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new FileNotFoundException(rb.getString("S4001", file));
            }
            if (file.isDirectory()) {
                throw new FileNotFoundException(rb.getString("S4002", file));
            }
        }
        this.file_size = file.length();
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile(file, "rw");
        if (this.file_size == 0L) {
            this.out = new FileOutputStream(randomAccessFile.getFD());
            this.file_creation_time = System.currentTimeMillis();
            try {
                this.writeCreationTime(this.out, this.file_creation_time);
            }
            catch (IOException iOException) {
                throw new IOException(rb.getString("S4003", file));
            }
        }
        try {
            this.file_creation_time = this.readCreationTime(randomAccessFile);
        }
        catch (IOException iOException) {
            throw new IOException(rb.getString("S4004", file));
        }
        randomAccessFile.seek(randomAccessFile.length());
        this.out = new FileOutputStream(randomAccessFile.getFD());
        if (this.doRollover()) {
            this.rolloverFile();
        }
    }

    private void writeCreationTime(OutputStream outputStream, long l) throws IOException {
        String string = "# " + l + " Do not modify this line" + SharedResources.NL;
        outputStream.write(string.getBytes("us-ascii"));
    }

    private long readCreationTime(RandomAccessFile randomAccessFile) throws IOException, EOFException {
        byte by;
        int n;
        randomAccessFile.seek(0L);
        if (randomAccessFile.skipBytes(2) != 2) {
            throw new IOException("Could not skip bytes");
        }
        byte[] byArray = new byte[128];
        long l = 0L;
        for (n = 0; n < 128 && (by = randomAccessFile.readByte()) >= 48 && by <= 57; ++n) {
            byArray[n] = by;
        }
        int n2 = 0;
        --n;
        while (n >= 0) {
            l = (long)((double)l + (double)(byArray[n] - 48) * Math.pow(10.0, n2));
            ++n2;
            --n;
        }
        randomAccessFile.seek(randomAccessFile.length());
        return l;
    }

    public RollingFileOutputStream(File file, long l) throws IOException {
        this(file, 1024L, 0L);
    }

    public RollingFileOutputStream(File file) throws IOException {
        this(file, 1024L);
    }

    public void setNumFiles(int n) {
        this.num_files = n;
    }

    public int getNumFiles() {
        return this.num_files;
    }

    public synchronized void write(int n) throws IOException {
        ++this.file_size;
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.doRollover()) {
            this.rolloverFile();
        }
        this.file_size += (long)n2;
        this.out.write(byArray, n, n2);
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    void rolloverFile() throws IOException {
        File file;
        String string;
        File file2;
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if ((file2 = new File(RollingFileOutputStream.generateFilename(string = this.outfile.getAbsolutePath(), this.num_files))).exists()) {
            file2.delete();
        }
        for (int i = this.num_files - 1; i > 0; --i) {
            file2 = new File(RollingFileOutputStream.generateFilename(string, i));
            if (!file2.exists()) continue;
            file = new File(RollingFileOutputStream.generateFilename(string, i + 1));
            file2.renameTo(file);
        }
        file = new File(RollingFileOutputStream.generateFilename(string, 1));
        this.outfile.renameTo(file);
        this.out = new FileOutputStream(this.outfile);
        this.file_creation_time = System.currentTimeMillis();
        try {
            this.writeCreationTime(this.out, this.file_creation_time);
        }
        catch (Exception exception) {
            System.out.println("Got exception" + exception);
        }
        this.file_size = this.outfile.length();
    }

    public static String generateFilename(String string, int n) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string + "_" + n;
        }
        return string.substring(0, n2) + "_" + n + string.substring(n2);
    }

    boolean doRollover() {
        return this.rollover_bytes != 0L && this.file_size >= this.rollover_bytes || this.rollover_ms != 0L && System.currentTimeMillis() - this.file_creation_time > this.rollover_ms;
    }

    public void setRolloverSecs(long l) {
        this.rollover_ms = l * 1000L;
    }

    public long getRolloverSecs() {
        return this.rollover_ms / 1000L;
    }

    public void setRolloverBytes(long l) {
        this.rollover_bytes = l;
    }

    public long getRolloverBytes() {
        return this.rollover_bytes;
    }
}

