/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSearchable
extends Searchable
implements TreeModelListener,
PropertyChangeListener {
    private boolean _recursive = false;
    private transient List<TreePath> _treePathes;

    public TreeSearchable(JTree jTree) {
        super(jTree);
        if (jTree.getModel() != null) {
            jTree.getModel().addTreeModelListener(this);
        }
        jTree.addPropertyChangeListener("model", this);
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setRecursive(boolean bl) {
        this._recursive = bl;
        this.resetTreePathes();
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTree && ((JTree)this._component).getModel() != null) {
            ((JTree)this._component).getModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        if (!this.isRecursive()) {
            if (bl) {
                ((JTree)this._component).addSelectionInterval(n, n);
            } else {
                ((JTree)this._component).setSelectionRow(n);
            }
            ((JTree)this._component).scrollRowToVisible(n);
        } else {
            Object object = this.getElementAt(n);
            if (object instanceof TreePath) {
                TreePath treePath = (TreePath)object;
                if (bl) {
                    ((JTree)this._component).addSelectionPath(treePath);
                } else {
                    ((JTree)this._component).setSelectionPath(treePath);
                }
                ((JTree)this._component).scrollPathToVisible(treePath);
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (!this.isRecursive()) {
            int[] nArray = ((JTree)this._component).getSelectionRows();
            return nArray != null && nArray.length != 0 ? nArray[0] : -1;
        }
        TreePath[] treePathArray = ((JTree)this._component).getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            return this.getTreePathes().indexOf(treePathArray[0]);
        }
        return -1;
    }

    @Override
    protected Object getElementAt(int n) {
        if (n == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            return ((JTree)this._component).getPathForRow(n);
        }
        return this.getTreePathes().get(n);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            return ((JTree)this._component).getRowCount();
        }
        return this.getTreePathes().size();
    }

    protected void populateTreePaths() {
        this._treePathes = new ArrayList<TreePath>();
        Object object = ((JTree)this._component).getModel().getRoot();
        this.populateTreePaths0(object, new TreePath(object), ((JTree)this._component).getModel());
    }

    private void populateTreePaths0(Object object, TreePath treePath, TreeModel treeModel) {
        if (((JTree)this._component).isRootVisible() || treePath.getLastPathComponent() != ((JTree)this._component).getModel().getRoot()) {
            this._treePathes.add(treePath);
        }
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            Object object2 = treeModel.getChild(object, i);
            this.populateTreePaths0(object2, treePath.pathByAddingChild(object2), treeModel);
        }
    }

    protected void resetTreePathes() {
        this._treePathes = null;
    }

    protected List<TreePath> getTreePathes() {
        if (this._treePathes == null) {
            this.populateTreePaths();
        }
        return this._treePathes;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            return object2.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getOldValue()).removeTreeModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getNewValue()).addTreeModelListener(this);
            }
            this.resetTreePathes();
        }
    }
}

