/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AutoScroll {
    protected Timer _timer;
    protected boolean _autoScrolling = false;
    protected int _scrollDirection = 0;
    protected boolean _hasEntered;
    public static final int SCROLL_UP = 0;
    public static final int SCROLL_DOWN = 1;
    public static final int SCROLL_LEFT = 2;
    public static final int SCROLL_RIGHT = 4;
    protected Component _component;
    protected boolean _vertical = true;
    protected int _autoScrollInterval = 100;
    private boolean _componentSelfScrollable = true;

    protected AutoScroll(Component component) {
        this._component = component;
    }

    protected AutoScroll(Component component, boolean bl) {
        this._component = component;
        this._vertical = bl;
    }

    public int getAutoScrollInterval() {
        return this._autoScrollInterval;
    }

    public void setAutoScrollInterval(int n) {
        this._autoScrollInterval = n;
    }

    public void startAutoScrolling(int n) {
        if (this._autoScrolling) {
            this._timer.stop();
        }
        this._autoScrolling = true;
        this._scrollDirection = n;
        this.autoScrollingStarted(this._scrollDirection);
        this._timer = new Timer(this._autoScrollInterval, new AutoScrollActionHandler(this._scrollDirection));
        this._timer.start();
    }

    public void stopAutoScrolling() {
        this._autoScrolling = false;
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        this.autoScrollingEnded(this._scrollDirection);
    }

    public boolean isAutoScrolling() {
        return this._autoScrolling;
    }

    public int getScrollDirection() {
        return this._scrollDirection;
    }

    public boolean isComponentSelfScrollable() {
        return this._componentSelfScrollable;
    }

    public void setComponentSelfScrollable(boolean bl) {
        this._componentSelfScrollable = bl;
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._component) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._component);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._hasEntered = false;
        this.stopAutoScrolling();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.stopAutoScrolling();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._componentSelfScrollable && mouseEvent.getSource() == this._component) {
            return;
        }
        if (this._component.isVisible()) {
            MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent);
            Rectangle rectangle = new Rectangle();
            if (this._component instanceof JComponent) {
                ((JComponent)this._component).computeVisibleRect(rectangle);
            } else {
                rectangle = this._component.getBounds();
            }
            if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1 && mouseEvent2.getPoint().x >= rectangle.x && mouseEvent2.getPoint().x <= rectangle.x + rectangle.width - 1) {
                Point point;
                this._hasEntered = true;
                if (this._autoScrolling) {
                    this.stopAutoScrolling();
                }
                if (rectangle.contains(point = mouseEvent2.getPoint())) {
                    this.updateSelectionForEvent(mouseEvent2, false);
                }
            } else if (this._hasEntered) {
                int n = mouseEvent2.getPoint().y < rectangle.y ? 0 : (mouseEvent2.getPoint().x < rectangle.x ? 2 : (mouseEvent2.getPoint().y > rectangle.y + rectangle.height ? 1 : 4));
                if (this._autoScrolling && this._scrollDirection != n) {
                    this.stopAutoScrolling();
                    this.startAutoScrolling(n);
                } else if (!this._autoScrolling) {
                    this.startAutoScrolling(n);
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._component) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            if (this._component instanceof JComponent) {
                ((JComponent)this._component).computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    this.updateSelectionForEvent(mouseEvent, false);
                }
            } else {
                this.updateSelectionForEvent(mouseEvent, false);
            }
        }
    }

    public void autoScrollingStarted(int n) {
    }

    public void autoScrollingEnded(int n) {
    }

    public abstract void autoScrolling(int var1);

    public abstract void updateSelectionForEvent(MouseEvent var1, boolean var2);

    private class AutoScrollActionHandler
    implements ActionListener {
        private int _direction;

        AutoScrollActionHandler(int n) {
            this._direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoScroll.this.autoScrolling(this._direction);
        }
    }
}

