package org.broad.tribble.index;

import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * Interface for all index implementations.
 */
public interface Index {
    /**
     *
     * @param chr the chromosome
     * @param start the start position
     * @param end the end position
     * @return a list of blocks that contain the specified interval
     */
    List<Block> getBlocks(String chr, int start, int end);

    /**
     * does this index represent an up-to-date version
     * @return true if the index is up to date, false otherwise
     */
    public boolean isCurrentVersion();

    /**
     * get a list of the sequence names we've seen during indexing, in order
     * @return a LinkedHashSet, which guarantees the ordering
     */
    LinkedHashSet<String> getSequenceNames();

    /**
     * read in the index
     * @param stream an input stream to read from
     * @throws IOException if we have problems reading the index from the stream
     */
    public void read(LittleEndianInputStream stream)  throws IOException;

    /**
     * all indexes are writable to disk
     * @param stream the stream to write the index to
     * @throws IOException if the index is unable to write to the specified location
     */
    public void write(LittleEndianOutputStream stream) throws IOException;
}
