/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListByPathRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListUsersRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListUsersResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListByPathRequest) {
            LOG.debug((Object)("List users " + request));
            UserListByPathRequest req = (UserListByPathRequest)request;
            String path = req.getListPath();
            ListUsersRequest listUsersRequest = new ListUsersRequest();
            listUsersRequest.setPathPrefix(path);
            LOG.debug((Object)"List users by path prefix");
            ListUsersResult result = this.getClient().listUsers(listUsersRequest);
            for (User user : result.getUsers()) {
                LOG.info((Object)user.getArn());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

