/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupUploadPolicyRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.PutGroupPolicyRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupUploadPolicyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupUploadPolicyDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupUploadPolicyRequest) {
            GroupUploadPolicyRequest req = (GroupUploadPolicyRequest)request;
            LOG.debug((Object)("Uploading policy document" + req));
            if (req.getPolicyFile() == null && req.getPolicy() == null) {
                Utils.exit(1, "must specify policy document to upload", null);
            } else if (!(req.getPolicyFile() == null ^ req.getPolicy() == null)) {
                Utils.exit(1, "can specify only one of -f -o", null);
            }
            PutGroupPolicyRequest policyRequest = new PutGroupPolicyRequest();
            if (req.getPolicy() != null) {
                policyRequest.setPolicyDocument(req.getPolicy());
            } else {
                String policy = Utils.readFile(req.getPolicyFile());
                LOG.debug((Object)("Policy document from file is: " + policy));
                policyRequest.setPolicyDocument(policy);
            }
            policyRequest.setGroupName(req.getGroupName());
            policyRequest.setPolicyName(req.getPolicyName());
            this.getClient().putGroupPolicy(policyRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

