/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListCertsRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListSigningCertificatesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListSigningCertificatesResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.SigningCertificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListCertsDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListCertsDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListCertsRequest) {
            UserListCertsRequest req = (UserListCertsRequest)request;
            LOG.debug((Object)("Listing certs " + req));
            ListSigningCertificatesRequest certificatesRequest = new ListSigningCertificatesRequest();
            certificatesRequest.setUserName(req.getUserName());
            ListSigningCertificatesResult result = this.getClient().listSigningCertificates(certificatesRequest);
            for (SigningCertificate cert : result.getCertificates()) {
                LOG.info((Object)cert.getCertificateId());
                LOG.info((Object)cert.getStatus());
                if (!req.isReturnBody()) continue;
                LOG.info((Object)cert.getCertificateBody());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

