/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.ServerCertModRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.UpdateServerCertificateRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMServerCertModDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMServerCertModDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof ServerCertModRequest) {
            ServerCertModRequest modRequest = (ServerCertModRequest)request;
            LOG.debug((Object)("Modifying server certificate: " + modRequest));
            UpdateServerCertificateRequest updateSCRequest = new UpdateServerCertificateRequest();
            updateSCRequest.setServerCertificateName(modRequest.getServerCertificateName());
            updateSCRequest.setNewServerCertificateName(modRequest.getNewServerCertificateName());
            updateSCRequest.setNewPath(this.verifyPathAndAddSlashSuffix(modRequest.getNewPath()));
            this.getClient().updateServerCertificate(updateSCRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

