/* GSnes9x -- codes.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_CODES_H
#define GSNES9X_CODES_H

/* Callers. */
void             gg_codes_change_cb    (GtkWidget *widget, ROMPrefsData *rpd);
void             ar_codes_change_cb    (GtkWidget *widget, ROMPrefsData *rpd);
void             gf_codes_change_cb    (GtkWidget *widget, ROMPrefsData *rpd);
void             gg_codes_clean_cb     (GtkWidget *widget, ROMPrefsData *rpd);
void             ar_codes_clean_cb     (GtkWidget *widget, ROMPrefsData *rpd);
void             gf_codes_clean_cb     (GtkWidget *widget, ROMPrefsData *rpd);

/* Struct constructor. */
CodesListStruct* codes_list_struct_new ();
CodesListStruct* get_codes_clist       (ROMPrefsData *rpd, GSnes9xCheatCodes cd);

/* Dialog. */
void             codes_change_dialog   (ROMPrefsData *rpd, GSnes9xCheatCodes cd);

/* Dialog buttons. */
void             code_add_cb           (GtkWidget *widget, CodesListStruct *cls);
void             code_remove_cb        (GtkWidget *widget, CodesListStruct *cls);
void             code_set_cb           (GtkWidget *widget, CodesListStruct *cls);

/* Buttons related. */
void             code_add_ok_cb        (GtkWidget *widget, AddCodeStruct *add_code);
void             code_add_cancel_cb    (GtkWidget *widget, AddCodeStruct *add_code);
void             code_add_free_cb      (GtkWidget *widget, AddCodeStruct *add_code);
void             code_remove_ok_cb     (GtkWidget *widget, CodesListStruct *cls);

/* Setup. */
void             code_select_cb        (GtkWidget *clist, gint row, gint col,
					GdkEventButton *event, CodesListStruct *cls);
void             code_unselect_cb      (GtkWidget *clist, gint row, gint col,
					GdkEventButton *event, CodesListStruct *cls);
void             code_sort_column      (GtkWidget *clist,  gint column, gpointer data);

/* Close functions. */
void             code_repeated         (gchar *name);
void             codes_clean           (ROMPrefsData *rpd, GSnes9xCheatCodes cc);
void             code_dialog_free_cb   (GtkWidget *widget, CodesListStruct *cls);

#endif

/* codes.h ends here. */
