/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.servlet.compressionFilters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import samples.webapps.simple.servlet.compressionFilters.CompressionResponseStream;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected static final String info = "CompressionServletResponseWrapper";
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected int threshold = 0;
    private int debug = 0;
    protected String contentType = null;

    public CompressionServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.origResponse = httpServletResponse;
        if (this.debug > 1) {
            System.out.println("CompressionServletResponseWrapper constructor gets called");
        }
    }

    public void setContentType(String string) {
        if (this.debug > 1) {
            System.out.println("setContentType to " + string);
        }
        this.contentType = string;
        this.origResponse.setContentType(string);
    }

    public void setCompressionThreshold(int n) {
        if (this.debug > 1) {
            System.out.println("setCompressionThreshold to " + n);
        }
        this.threshold = n;
    }

    public void setDebugLevel(int n) {
        this.debug = n;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        if (this.debug > 1) {
            System.out.println("createOutputStream gets called");
        }
        CompressionResponseStream compressionResponseStream = new CompressionResponseStream(this.origResponse);
        compressionResponseStream.setDebugLevel(this.debug);
        compressionResponseStream.setBuffer(this.threshold);
        return compressionResponseStream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this.debug > 1) {
            System.out.println("flush buffer @ CompressionServletResponseWrapper");
        }
        ((CompressionResponseStream)this.stream).flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        if (this.debug > 1) {
            System.out.println("stream is set to " + this.stream + " in getOutputStream");
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        if (this.debug > 1) {
            System.out.println("stream is set to " + this.stream + " in getWriter");
        }
        String string = this.origResponse.getCharacterEncoding();
        if (this.debug > 1) {
            System.out.println("character encoding is " + string);
        }
        this.writer = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, string)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setContentLength(int n) {
    }

    private static String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("charset=");
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(n2 + 8);
        String string4 = string3.trim();
        return string4;
    }
}

