/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.message.stream.LazyStreamBasedMessage;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityRecipient;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCContract;
import com.sun.xml.ws.security.secconv.WSSCElementFactory;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.WSITProviderSecurityEnvironment;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.PolicyResolverImpl;
import com.sun.xml.wss.provider.wsit.WSITAuthContextBase;
import com.sun.xml.wss.provider.wsit.WSITServerAuthModule;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSITServerAuthContext
extends WSITAuthContextBase
implements ServerAuthContext {
    protected static final String TRUE = "true";
    private SessionManager sessionManager = SessionManager.getSessionManager();
    private Set trustConfig = null;
    private CallbackHandler handler = null;
    String operation = null;
    WSEndpoint endPoint = null;
    WSITServerAuthModule authModule = null;

    public WSITServerAuthContext(String operation, Subject subject, Map map) {
        super(map);
        Properties props;
        this.operation = operation;
        this.endPoint = (WSEndpoint)map.get("ENDPOINT");
        Iterator it = this.inMessagePolicyMap.values().iterator();
        SecurityPolicyHolder holder = (SecurityPolicyHolder)it.next();
        Set configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/server");
        this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/server");
        String isGF = System.getProperty("com.sun.aas.installRoot");
        if (isGF != null) {
            try {
                props = new Properties();
                this.populateConfigProperties(configAssertions, props);
                String jmacHandler = props.getProperty("jmac.callbackhandler");
                this.handler = this.loadGFHandler(false, jmacHandler);
                this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), (Throwable)ex);
            }
        } else {
            props = new Properties();
            this.handler = this.configureServerHandler(configAssertions, props);
            this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler, props);
        }
        this.authModule = new WSITServerAuthModule();
        try {
            this.authModule.initialize(null, null, null, map);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
        }
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        boolean isSCMessage;
        Packet packet = this.getRequestPacket(messageInfo);
        Packet ret = null;
        if (!this.optimized) {
            this.cacheMessage(packet);
        }
        try {
            ret = this.validateRequest(packet, clientSubject, serviceSubject, messageInfo.getMap());
        }
        catch (XWSSecurityException ex) {
            throw this.getSOAPFaultException(ex);
        }
        if (messageInfo.getMap().get("THERE_WAS_A_FAULT") != null) {
            this.setResponsePacket(messageInfo, ret);
            return AuthStatus.SEND_FAILURE;
        }
        boolean bl = isSCMessage = messageInfo.getMap().get("IS_SC_ISSUE") != null || messageInfo.getMap().get("IS_SC_CANCEL") != null;
        if (isSCMessage) {
            this.setResponsePacket(messageInfo, ret);
            return AuthStatus.SEND_SUCCESS;
        }
        this.setRequestPacket(messageInfo, ret);
        return AuthStatus.SUCCESS;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        String iTM = (String)messageInfo.getMap().get("IS_TRUST_MESSAGE");
        boolean isTrustMessage = iTM != null;
        Packet packet = (Packet)messageInfo.getMap().get("VALIDATE_REQ_PACKET");
        Packet retPacket = this.getResponsePacket(messageInfo);
        if (isTrustMessage) {
            retPacket = this.addAddressingHeaders(packet, retPacket.getMessage(), "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/Issue");
        }
        Packet ret = null;
        try {
            ret = this.secureResponse(retPacket, serviceSubject, messageInfo.getMap());
        }
        catch (XWSSecurityException ex) {
            throw this.getSOAPFaultException(ex);
        }
        this.setResponsePacket(messageInfo, ret);
        if (messageInfo.getMap().get("THERE_WAS_A_FAULT") != null) {
            return AuthStatus.SEND_FAILURE;
        }
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.issuedTokenContextMap.clear();
    }

    public Packet validateRequest(Packet packet, Subject clientSubject, Subject serviceSubject, Map sharedState) throws XWSSecurityException {
        WSDLBoundOperation cachedOperation;
        Message msg = packet.getMessage();
        boolean isSCIssueMessage = false;
        boolean isSCCancelMessage = false;
        boolean isTrustMessage = false;
        Object msgId = null;
        String action = null;
        boolean thereWasAFault = false;
        ProcessingContext ctx = this.initializeInboundProcessingContext(packet);
        ctx.setExtraneousProperty("javax.security.auth.Subject", clientSubject);
        ctx.setExtraneousProperty("OperationResolver", new PolicyResolverImpl(this.inMessagePolicyMap, this.inProtocolPM, this.cachedOperation(packet), this.pipeConfig, this.addVer, false));
        try {
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                msg = Messages.create(soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (WssSoapFaultException ex) {
            thereWasAFault = true;
            msg = Messages.create(ex, this.pipeConfig.getBinding().getSOAPVersion());
        }
        catch (XWSSecurityException xwse) {
            thereWasAFault = true;
            msg = Messages.create(xwse, this.pipeConfig.getBinding().getSOAPVersion());
        }
        catch (WebServiceException xwse) {
            thereWasAFault = true;
            msg = Messages.create(xwse, this.pipeConfig.getBinding().getSOAPVersion());
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), se);
            thereWasAFault = true;
            msg = Messages.create(se, this.pipeConfig.getBinding().getSOAPVersion());
        }
        if (thereWasAFault) {
            sharedState.put("THERE_WAS_A_FAULT", thereWasAFault);
            if (this.isAddressingEnabled()) {
                if (this.optimized) {
                    packet.setMessage(((JAXBFilterProcessingContext)ctx).getPVMessage());
                }
                Packet ret = packet.createServerResponse(msg, this.addVer, this.soapVersion, this.addVer.getDefaultFaultAction());
                return ret;
            }
            packet.setMessage(msg);
            return packet;
        }
        packet.setMessage(msg);
        if (this.isAddressingEnabled()) {
            List<PolicyAssertion> policies;
            action = this.getAction(packet);
            if ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT".equals(action)) {
                isSCIssueMessage = true;
                sharedState.put("IS_SC_ISSUE", TRUE);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel".equals(action)) {
                isSCCancelMessage = true;
                sharedState.put("IS_SC_CANCEL", TRUE);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue".equals(action)) {
                isTrustMessage = true;
                sharedState.put("IS_TRUST_MESSAGE", TRUE);
                packet.getMessage().getHeaders().getTo(this.addVer, this.pipeConfig.getBinding().getSOAPVersion());
                if (this.trustConfig != null) {
                    packet.invocationProperties.put("http://schemas.sun.com/ws/2006/05/trust/server", this.trustConfig.iterator());
                }
                packet.invocationProperties.put("SecurityEnvironment", this.secEnv);
            }
            if (isSCIssueMessage && !(policies = this.getInBoundSCP(packet.getMessage())).isEmpty()) {
                packet.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
            }
        }
        if (!isSCIssueMessage && (cachedOperation = this.cacheOperation(msg, packet)) == null && this.addVer != null) {
            cachedOperation = this.getWSDLOpFromAction(packet, true);
            packet.invocationProperties.put("WSDL_BOUND_OPERATION", cachedOperation);
        }
        sharedState.put("VALIDATE_REQ_PACKET", packet);
        Packet retPacket = null;
        if (isSCIssueMessage || isSCCancelMessage) {
            retPacket = this.invokeSecureConversationContract(packet, ctx, isSCIssueMessage, action);
            retPacket = this.secureResponse(retPacket, serviceSubject, sharedState);
        } else {
            retPacket = packet;
        }
        return retPacket;
    }

    public Packet secureResponse(Packet retPacket, Subject serviceSubject, Map sharedState) throws XWSSecurityException {
        boolean thereWasAFault;
        boolean isSCIssueMessage = sharedState.get("IS_SC_ISSUE") != null;
        boolean isSCCancelMessage = sharedState.get("IS_SC_CANCEL") != null;
        boolean isTrustMessage = sharedState.get("IS_TRUST_MESSAGE") != null;
        Packet packet = (Packet)sharedState.get("VALIDATE_REQ_PACKET");
        Boolean thereWasAFaultSTR = (Boolean)sharedState.get("THERE_WAS_A_FAULT");
        boolean bl = thereWasAFault = thereWasAFaultSTR != null ? thereWasAFaultSTR : false;
        if (thereWasAFault) {
            return retPacket;
        }
        if (!this.optimized) {
            try {
                SOAPMessage sm = retPacket.getMessage().readAsSOAPMessage();
                Message newMsg = Messages.create(sm);
                retPacket.setMessage(newMsg);
            }
            catch (SOAPException ex) {
                throw new WebServiceException((Throwable)ex);
            }
        }
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(retPacket, isSCIssueMessage);
        Message msg = retPacket.getMessage();
        try {
            if (ctx.getSecurityPolicy() != null && ((MessagePolicy)ctx.getSecurityPolicy()).size() > 0) {
                if (!this.optimized || msg.isFault()) {
                    SOAPMessage soapMessage = msg.readAsSOAPMessage();
                    soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                    msg = Messages.create(soapMessage);
                } else {
                    msg = this.secureOutboundMessage(msg, ctx);
                }
            }
        }
        catch (WssSoapFaultException ex) {
            sharedState.put("THERE_WAS_A_FAULT", true);
            msg = Messages.create(this.getSOAPFault(ex));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se);
        }
        finally {
            if (this.isSCCancel(retPacket)) {
                this.removeContext(packet);
            }
        }
        this.resetCachedOperation(retPacket);
        retPacket.setMessage(msg);
        return retPacket;
    }

    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        if (debug) {
            DumpFilter.process(ctx);
        }
        ctx.setSOAPMessage(message);
        NewSecurityRecipient.validateMessage(ctx);
        return ctx.getSOAPMessage();
    }

    protected Message verifyInboundMessage(Message message, ProcessingContext ctx) throws XWSSecurityException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
        SecurityRecipient recipient = new SecurityRecipient(((LazyStreamBasedMessage)message).readMessage(), this.soapVersion);
        return recipient.validateMessage(context);
    }

    protected ProcessingContext initializeOutgoingProcessingContext(Packet packet, boolean isSCMessage) {
        ProcessingContextImpl ctx = null;
        if (this.optimized) {
            ctx = new JAXBFilterProcessingContext(packet.invocationProperties);
            ((JAXBFilterProcessingContext)ctx).setAddressingVersion(this.addVer);
            ((JAXBFilterProcessingContext)ctx).setSOAPVersion(this.soapVersion);
        } else {
            ctx = new ProcessingContextImpl(packet.invocationProperties);
        }
        ctx.setTimestampTimeout(this.timestampTimeOut);
        try {
            MessagePolicy policy = null;
            if (packet.getMessage().isFault()) {
                policy = this.getOutgoingFaultPolicy(packet);
                if (this.optimized) {
                    ctx = new ProcessingContextImpl(packet.invocationProperties);
                }
            } else if (this.isRMMessage(packet)) {
                SecurityPolicyHolder holder = (SecurityPolicyHolder)this.outProtocolPM.get("RM");
                policy = holder.getMessagePolicy();
            } else if (this.isSCCancel(packet)) {
                SecurityPolicyHolder holder = (SecurityPolicyHolder)this.outProtocolPM.get("SC");
                policy = holder.getMessagePolicy();
            } else {
                policy = this.getOutgoingXWSSecurityPolicy(packet, isSCMessage);
            }
            if (debug && policy != null) {
                policy.dumpMessages(true);
            }
            if (policy != null) {
                ctx.setSecurityPolicy(policy);
            }
            ctx.setIssuedTokenContextMap(this.issuedTokenContextMap);
            ctx.setAlgorithmSuite(this.getAlgoSuite(this.getBindingAlgorithmSuite(packet)));
            ctx.setSecurityEnvironment(this.secEnv);
            ctx.isInboundMessage(false);
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
        }
        return ctx;
    }

    private void removeContext(Packet packet) {
        String strId;
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        if (sct != null && (strId = sct.getIdentifier().toString()) != null) {
            this.issuedTokenContextMap.remove(strId);
            this.sessionManager.terminateSession(strId);
        }
    }

    protected MessagePolicy getOutgoingXWSSecurityPolicy(Packet packet, boolean isSCMessage) {
        SecurityPolicyHolder sph;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            return this.getOutgoingXWSBootstrapPolicy(scToken);
        }
        MessagePolicy mp = null;
        WSDLBoundOperation operation = this.cachedOperation(packet);
        if (this.outMessagePolicyMap == null) {
            return new MessagePolicy();
        }
        if (this.isTrustMessage(packet)) {
            operation = this.getWSDLOpFromAction(packet, false);
            this.cacheOperation(operation, packet);
        }
        if ((sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(operation)) == null) {
            return new MessagePolicy();
        }
        mp = sph.getMessagePolicy();
        return mp;
    }

    protected MessagePolicy getOutgoingFaultPolicy(Packet packet) {
        WSDLBoundOperation cachedOp = this.cachedOperation(packet);
        if (cachedOp != null) {
            WSDLOperation operation = cachedOp.getOperation();
            try {
                SOAPBody body = packet.getMessage().readAsSOAPMessage().getSOAPBody();
                NodeList nodes = body.getElementsByTagName("detail");
                if (nodes.getLength() == 0) {
                    nodes = body.getElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
                }
                if (nodes.getLength() > 0) {
                    Node node = nodes.item(0);
                    Node faultNode = node.getFirstChild();
                    if (faultNode == null) {
                        return null;
                    }
                    String uri = faultNode.getNamespaceURI();
                    QName faultDetail = null;
                    faultDetail = uri != null && uri.length() > 0 ? new QName(faultNode.getNamespaceURI(), faultNode.getLocalName()) : new QName(faultNode.getNodeName());
                    WSDLFault fault = operation.getFault(faultDetail);
                    SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(cachedOp);
                    SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
                    MessagePolicy faultPolicy = faultPolicyHolder == null ? new MessagePolicy() : faultPolicyHolder.getMessagePolicy();
                    return faultPolicy;
                }
            }
            catch (SOAPException sx) {
                // empty catch block
            }
        }
        return null;
    }

    private CallbackHandler configureServerHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Class hdlr = this.loadClass(ret);
                Object obj = hdlr.newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            RealmAuthenticationAdapter adapter = this.getRealmAuthenticationAdapter(this.endPoint);
            return new DefaultCallbackHandler("server", props, adapter);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0043_ERROR_CONFIGURE_SERVER_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0043_ERROR_CONFIGURE_SERVER_HANDLER(), e);
        }
    }

    protected boolean bindingHasIssuedTokenPolicy() {
        return this.hasIssuedTokens;
    }

    protected boolean bindingHasSecureConversationPolicy() {
        return this.hasSecureConversation;
    }

    protected boolean bindingHasRMPolicy() {
        return this.hasReliableMessaging;
    }

    private Packet invokeSecureConversationContract(Packet packet, ProcessingContext ctx, boolean isSCTIssue, String action) {
        List<PolicyAssertion> policies;
        IssuedTokenContextImpl ictx = new IssuedTokenContextImpl();
        Message msg = packet.getMessage();
        Message retMsg = null;
        String retAction = null;
        try {
            Subject subject = SubjectAccessor.getRequesterSubject(ctx);
            ictx.setRequestorSubject(subject);
            WSSCElementFactory eleFac = WSSCElementFactory.newInstance();
            JAXBElement rstEle = (JAXBElement)msg.readPayloadAsJAXB(jaxbContext.createUnmarshaller());
            RequestSecurityToken rst = eleFac.createRSTFrom(rstEle);
            URI requestType = rst.getRequestType();
            RequestSecurityTokenResponse rstr = null;
            WSSCContract scContract = WSSCFactory.newWSSCContract(null);
            if (requestType.toString().equals("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue")) {
                List<PolicyAssertion> policies2 = this.getOutBoundSCP(packet.getMessage());
                rstr = scContract.issue(rst, ictx, (SecureConversationToken)((Object)policies2.get(0)));
                retAction = "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT";
                SecurityContextToken sct = (SecurityContextToken)ictx.getSecurityToken();
                String sctId = sct.getIdentifier().toString();
                Session session = this.sessionManager.getSession(sctId);
                if (session == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0044_ERROR_SESSION_CREATION());
                    throw new WSSecureConversationException(LogStringsMessages.WSITPVD_0044_ERROR_SESSION_CREATION());
                }
                packet.invocationProperties.put("com.sun.xml.ws.sessionid", sctId);
                packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
                IssuedTokenContext itctx = session.getSecurityInfo().getIssuedTokenContext();
                itctx.setRequestorSubject(ictx.getRequestorSubject());
                ((ProcessingContextImpl)ctx).getIssuedTokenContextMap().put(sctId, itctx);
            } else if (requestType.toString().equals("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel")) {
                retAction = "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel";
                rstr = scContract.cancel(rst, ictx, this.issuedTokenContextMap);
            } else {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0045_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
                throw new UnsupportedOperationException(LogStringsMessages.WSITPVD_0045_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
            }
            retMsg = Messages.create(jaxbContext.createMarshaller(), (Object)eleFac.toJAXBElement(rstr), this.soapVersion);
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0001_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0001_PROBLEM_MAR_UNMAR(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        Packet retPacket = this.addAddressingHeaders(packet, retMsg, retAction);
        if (isSCTIssue && !(policies = this.getOutBoundSCP(packet.getMessage())).isEmpty()) {
            retPacket.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
        }
        return retPacket;
    }

    private Packet addAddressingHeaders(Packet packet, Message retMsg, String action) {
        Packet retPacket = packet.createServerResponse(retMsg, this.addVer, this.soapVersion, action);
        retPacket.proxy = packet.proxy;
        retPacket.invocationProperties.putAll(packet.invocationProperties);
        return retPacket;
    }

    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, true);
        this.inMessagePolicyMap.put(operation, sph);
        return sph;
    }

    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, false);
        this.outMessagePolicyMap.put(operation, sph);
        return sph;
    }

    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.outProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, true, false, true));
    }

    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.inProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, true, true, true));
    }

    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private RealmAuthenticationAdapter getRealmAuthenticationAdapter(WSEndpoint wSEndpoint) {
        Object obj;
        String className = "javax.servlet.ServletContext";
        Class<?> ret = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                ret = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (ret == null) {
            loader = this.getClass().getClassLoader();
            try {
                ret = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (ret != null && (obj = wSEndpoint.getContainer().getSPI(ret)) != null) {
            return RealmAuthenticationAdapter.newInstance(obj);
        }
        return null;
    }
}

