/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class SignatureFilter {
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        block51: {
            SignaturePolicy resolvedPolicy;
            block54: {
                WSSPolicy policy;
                block52: {
                    WSSPolicy keyBinding;
                    block56: {
                        WSSPolicy originalKeyBinding;
                        block57: {
                            block55: {
                                block53: {
                                    if (context.isInboundMessage()) break block51;
                                    policy = (WSSPolicy)context.getSecurityPolicy();
                                    resolvedPolicy = (SignaturePolicy)policy;
                                    if (context.makeDynamicPolicyCallback()) break block52;
                                    keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                                    SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
                                    if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                                        try {
                                            AuthenticationTokenPolicy.X509CertificateBinding binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding.clone();
                                            String certIdentifier = binding.getCertificateIdentifier();
                                            String algorithm = binding.getKeyAlgorithm();
                                            if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(algorithm)) {
                                                X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                                binding.setX509Certificate(cert);
                                            } else if (certIdentifier == null || "".equals(certIdentifier)) {
                                                WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                                                if (ckBinding == null) {
                                                    ckBinding = (WSSPolicy)binding.newPrivateKeyBinding();
                                                }
                                                if (context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) {
                                                    SignatureKeyCallback.PrivKeyCertRequest request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getDefaultPrivKeyCertRequest(context.getExtraneousProperties());
                                                    binding.setX509Certificate(request.getX509Certificate());
                                                    if (request.getX509Certificate() == null) {
                                                        log.log(Level.SEVERE, "WSS1421.no.default.x509certificate.provided");
                                                        throw new XWSSecurityException("No default X509Certificate was provided");
                                                    }
                                                    ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                                                } else {
                                                    X509Certificate cert = context.getSecurityEnvironment().getDefaultCertificate(context.getExtraneousProperties());
                                                    if (cert == null) {
                                                        log.log(Level.SEVERE, "WSS1421.no.default.x509certificate.provided");
                                                        throw new XWSSecurityException("No default X509Certificate was provided");
                                                    }
                                                    binding.setX509Certificate(cert);
                                                    PrivateKey pk = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                                                    ((PrivateKeyBinding)ckBinding).setPrivateKey(pk);
                                                }
                                            } else if (context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) {
                                                SignatureKeyCallback.AliasPrivKeyCertRequest request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getAliasPrivKeyCertRequest(certIdentifier);
                                                binding.setX509Certificate(request.getX509Certificate());
                                                if (request.getX509Certificate() == null) {
                                                    log.log(Level.SEVERE, "WSS1421.no.default.x509certificate.provided");
                                                    throw new XWSSecurityException("No X509Certificate was provided");
                                                }
                                                WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                                                if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                                    ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                                                } else {
                                                    if (ckBinding != null) {
                                                        log.log(Level.SEVERE, "WSS1416.unsupported.keybinding");
                                                        throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
                                                    }
                                                    ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(request.getPrivateKey());
                                                }
                                            } else {
                                                X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, true);
                                                binding.setX509Certificate(cert);
                                                WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                                                PrivateKey key = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), certIdentifier);
                                                if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                                    ((PrivateKeyBinding)ckBinding).setPrivateKey(key);
                                                } else {
                                                    if (ckBinding != null) {
                                                        log.log(Level.SEVERE, "WSS1416.unsupported.keybinding");
                                                        throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
                                                    }
                                                    ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(key);
                                                }
                                            }
                                            context.setX509CertificateBinding(binding);
                                        }
                                        catch (Exception e) {
                                            log.log(Level.SEVERE, "WSS1417.exception.processing.signature", new Object[]{e.getMessage()});
                                            throw new XWSSecurityException(e);
                                        }
                                    }
                                    if (!PolicyTypeUtil.samlTokenPolicy(keyBinding)) break block53;
                                    keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                                    AuthenticationTokenPolicy.SAMLAssertionBinding binding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                                    binding.isReadOnly(true);
                                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                                    dynamicContext.inBoundMessage(false);
                                    context.getExtraneousProperties().get("Saml_Assertion_Client_Cache");
                                    AuthenticationTokenPolicy.SAMLAssertionBinding resolvedSAMLBinding = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), binding, dynamicContext);
                                    if (resolvedSAMLBinding.getAssertion() == null && resolvedSAMLBinding.getAuthorityBinding() == null) {
                                        log.log(Level.SEVERE, "WSS1418.saml.info.notset");
                                        throw new XWSSecurityException("None of SAML Assertion, SAML AuthorityBinding information was set into  the Policy by the CallbackHandler");
                                    }
                                    policy.setKeyBinding(resolvedSAMLBinding);
                                    resolvedPolicy = (SignaturePolicy)policy;
                                    context.getExtraneousProperties().put("Saml_Assertion_Client_Cache", resolvedSAMLBinding.getAssertion());
                                    break block54;
                                }
                                if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
                                    try {
                                        boolean sendEKSHA1;
                                        String dataEncAlgo = null;
                                        dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                                        SymmetricKeyBinding binding = (SymmetricKeyBinding)keyBinding.clone();
                                        String keyIdentifier = binding.getKeyIdentifier();
                                        SecretKey sKey = null;
                                        WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                                        boolean wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                                        boolean wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                                        boolean wss10 = !wss11Sender;
                                        boolean bl = sendEKSHA1 = wss11Receiver && wss11Sender && SignatureFilter.getReceivedSecret(context) != null;
                                        if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                                            try {
                                                if (!sendEKSHA1) {
                                                    AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                                    String certIdentifier = ckBindingClone.getCertificateIdentifier();
                                                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                                    ckBindingClone.setX509Certificate(cert);
                                                    context.setX509CertificateBinding(ckBindingClone);
                                                }
                                            }
                                            catch (Exception e) {
                                                log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                                                throw new XWSSecurityException(e);
                                            }
                                        }
                                        if (!binding.getKeyIdentifier().equals(MessageConstants._EMPTY)) {
                                            sKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keyIdentifier, true);
                                        } else if (sendEKSHA1) {
                                            sKey = SignatureFilter.getReceivedSecret(context);
                                        } else if (wss11Sender || wss10) {
                                            sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                                        }
                                        binding.setSecretKey(sKey);
                                        context.setSymmetricKeyBinding(binding);
                                    }
                                    catch (Exception e) {
                                        log.log(Level.SEVERE, "WSS1414.error.extracting.symmetrickey", new Object[]{e.getMessage()});
                                        throw new XWSSecurityException(e);
                                    }
                                }
                                if (!PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) break block55;
                                IssuedTokenKeyBinding itkb = (IssuedTokenKeyBinding)keyBinding;
                                SecurityUtil.resolveIssuedToken(context, itkb);
                                break block54;
                            }
                            if (!PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) break block56;
                            DerivedTokenKeyBinding dtk = (DerivedTokenKeyBinding)keyBinding.clone();
                            originalKeyBinding = dtk.getOriginalKeyBinding();
                            if (!PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) break block57;
                            String dataEncAlgo = null;
                            dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                            SymmetricKeyBinding symmBinding = (SymmetricKeyBinding)originalKeyBinding.clone();
                            SecretKey sKey = null;
                            boolean wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                            boolean wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                            boolean wss10 = !wss11Sender;
                            boolean sendEKSHA1 = wss11Receiver && wss11Sender && SignatureFilter.getReceivedSecret(context) != null;
                            WSSPolicy ckBinding = (WSSPolicy)originalKeyBinding.getKeyBinding();
                            if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                                try {
                                    if (!sendEKSHA1) {
                                        AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                        String certIdentifier = ckBindingClone.getCertificateIdentifier();
                                        X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                        ckBindingClone.setX509Certificate(cert);
                                        context.setX509CertificateBinding(ckBindingClone);
                                    }
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                                    throw new XWSSecurityException(e);
                                }
                            }
                            if (sendEKSHA1) {
                                sKey = SignatureFilter.getReceivedSecret(context);
                            } else if (wss11Sender || wss10) {
                                sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                            }
                            symmBinding.setSecretKey(sKey);
                            context.setSymmetricKeyBinding(symmBinding);
                            break block54;
                        }
                        if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
                            SecureConversationTokenKeyBinding sctBinding = (SecureConversationTokenKeyBinding)originalKeyBinding;
                            SecurityUtil.resolveSCT(context, sctBinding);
                            break block54;
                        } else if (PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) {
                            IssuedTokenKeyBinding itkb = (IssuedTokenKeyBinding)originalKeyBinding;
                            SecurityUtil.resolveIssuedToken(context, itkb);
                        }
                        break block54;
                    }
                    if (!PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
                        log.log(Level.SEVERE, "WSS1419.unsupported.keybinding.signature");
                        throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
                    }
                    SecureConversationTokenKeyBinding sctBinding = (SecureConversationTokenKeyBinding)keyBinding;
                    SecurityUtil.resolveSCT(context, sctBinding);
                    break block54;
                }
                ((SignaturePolicy)policy).isReadOnly(true);
                try {
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                    throw new XWSSecurityException(e);
                }
            }
            context.setSecurityPolicy(resolvedPolicy);
            SignatureFilter.sign(context);
            return;
        }
        if (context.makeDynamicPolicyCallback()) {
            WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
            SignaturePolicy resolvedPolicy = null;
            ((SignaturePolicy)policy).isReadOnly(true);
            try {
                DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                dynamicContext.inBoundMessage(true);
                DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                throw new XWSSecurityException(e);
            }
            context.setSecurityPolicy(resolvedPolicy);
        }
        SignatureProcessor.verify(context);
    }

    private static void sign(FilterProcessingContext context) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            com.sun.xml.ws.security.opt.impl.dsig.SignatureProcessor.sign((JAXBFilterProcessingContext)context);
        } else {
            SignatureProcessor.sign(context);
        }
    }

    private static SecretKey getReceivedSecret(FilterProcessingContext context) {
        SecretKey sKey = null;
        sKey = (SecretKey)context.getExtraneousProperty("SecretKeyValue");
        return sKey;
    }
}

