/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.addressing.policy.Address;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.mex.client.MetadataClient;
import com.sun.xml.ws.mex.client.PortInfo;
import com.sun.xml.ws.mex.client.schema.Metadata;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.XmlPolicyModelMarshaller;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrustPluginImpl
implements TrustPlugin {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private final Configuration config;
    private static WSTrustElementFactory fact = WSTrustElementFactory.newInstance();
    private static final String PRE_CONFIGURED_STS = "PreconfiguredSTS";
    private static final String NAMESPACE = "namespace";
    private static final String CONFIG_NAMESPACE = "";
    private static final String ENDPOINT = "endPoint";
    private static final String METADATA = "metadata";
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String REQUEST_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    private static final String CLAIMS = "Claims";
    private static final String DIALECT = "Dialect";

    public TrustPluginImpl(Configuration config) {
        this.config = config;
    }

    public IssuedTokenContext process(PolicyAssertion token, PolicyAssertion localToken, String appliesTo) {
        IssuedToken issuedToken = (IssuedToken)((Object)token);
        RequestSecurityTokenTemplate rstTemplate = issuedToken.getRequestSecurityTokenTemplate();
        URI stsURI = this.getSTSURI(issuedToken);
        URI wsdlLocation = null;
        QName serviceName = null;
        QName portName = null;
        if (stsURI != null) {
            URI metadataAddress = this.getAddressFromMetadata(issuedToken);
            wsdlLocation = metadataAddress != null ? metadataAddress : stsURI;
        } else if (localToken != null && PRE_CONFIGURED_STS.equals(localToken.getName().getLocalPart())) {
            String portNameStr;
            String serviceNameStr;
            String wsdlLocationStr;
            String metadataStr;
            Map<QName, String> attrs = localToken.getAttributes();
            String namespace = attrs.get(new QName(CONFIG_NAMESPACE, NAMESPACE));
            String stsEPStr = attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT));
            if (stsEPStr == null) {
                stsEPStr = attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT.toLowerCase()));
            }
            if (stsEPStr != null) {
                stsURI = URI.create(stsEPStr);
            }
            if ((metadataStr = attrs.get(new QName(CONFIG_NAMESPACE, METADATA))) != null) {
                wsdlLocation = URI.create(metadataStr);
            }
            if ((wsdlLocationStr = attrs.get(new QName(CONFIG_NAMESPACE, WSDL_LOCATION))) != null) {
                wsdlLocation = URI.create(wsdlLocationStr);
            }
            if ((serviceNameStr = attrs.get(new QName(CONFIG_NAMESPACE, SERVICE_NAME))) != null && namespace != null) {
                serviceName = new QName(namespace, serviceNameStr);
            }
            if (wsdlLocation == null) {
                wsdlLocation = stsURI;
            }
            if ((portNameStr = attrs.get(new QName(CONFIG_NAMESPACE, PORT_NAME))) != null && namespace != null) {
                portName = new QName(namespace, portNameStr);
            }
        }
        if (stsURI == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
            throw new WebServiceException(LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
        }
        RequestSecurityTokenResponse result = null;
        try {
            RequestSecurityToken request = this.createRequest(rstTemplate, appliesTo);
            Claims claims = this.getClaims(token, appliesTo);
            if (claims != null) {
                request.setClaims(claims);
            }
            result = this.invokeRST(request, wsdlLocation, serviceName, portName, stsURI.toString());
            IssuedTokenContextImpl itc = new IssuedTokenContextImpl();
            WSTrustClientContract contract = WSTrustFactory.createWSTrustClientContract(this.config);
            contract.handleRSTR(request, result, itc);
            return itc;
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WebServiceException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), (Throwable)ex);
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WebServiceException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo));
        }
        catch (WSTrustException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WebServiceException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo));
        }
    }

    private RequestSecurityToken createRequest(RequestSecurityTokenTemplate rstTemplate, String appliesTo) throws URISyntaxException, WSTrustException, NumberFormatException {
        String keyType;
        URI requestType = URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
        AppliesTo applTo = null;
        if (appliesTo != null) {
            applTo = WSTrustUtil.createAppliesTo(appliesTo);
        }
        int len = 32;
        long keySize = rstTemplate.getKeySize();
        if (keySize > 0L) {
            len = (int)keySize / 8;
        }
        SecureRandom secRandom = new SecureRandom();
        byte[] nonce = new byte[len];
        secRandom.nextBytes(nonce);
        BinarySecret binarySecret = fact.createBinarySecret(nonce, "http://schemas.xmlsoap.org/ws/2005/02/trust/Nonce");
        Entropy entropy = fact.createEntropy(binarySecret);
        URI tokenType = URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        if (rstTemplate.getTokenType() != null) {
            tokenType = new URI(rstTemplate.getTokenType().trim());
        }
        URI context = null;
        Claims claims = null;
        Lifetime lifetime = null;
        RequestSecurityToken rst = fact.createRSTForIssue(tokenType, requestType, context, applTo, claims, entropy, lifetime);
        if (keySize > 0L) {
            rst.setKeySize(keySize);
        }
        if ((keyType = rstTemplate.getKeyType()) != null) {
            rst.setKeyType(new URI(keyType.trim()));
        }
        rst.setComputedKeyAlgorithm(URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1"));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1006_CREATED_RST_ISSUE(this.elemToString(rst)));
        }
        return rst;
    }

    private RequestSecurityTokenResponse invokeRST(RequestSecurityToken request, URI wsdlLocation, QName serviceName, QName portName, String stsURI) throws RemoteException, WSTrustException {
        if (serviceName == null || portName == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1012_SERVICE_PORTNAME_MEX(serviceName, portName));
            }
            QName[] names = TrustPluginImpl.doMexRequest(wsdlLocation.toString(), stsURI);
            serviceName = names[0];
            portName = names[1];
        }
        Service service = null;
        try {
            String url = wsdlLocation.toString();
            service = Service.create((URL)new URL(url), (QName)serviceName);
        }
        catch (MalformedURLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), ex);
            throw new WebServiceException(LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), (Throwable)ex);
        }
        Dispatch dispatch = service.createDispatch(portName, fact.getContext(), Service.Mode.PAYLOAD, new WebServiceFeature[]{new RespectBindingFeature(), new AddressingFeature(false)});
        if (stsURI != null) {
            dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", stsURI);
        }
        dispatch.getRequestContext().put("isTrustMessage", "true");
        dispatch.getRequestContext().put("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
        RequestSecurityTokenResponse rstr = fact.createRSTRFrom((JAXBElement)dispatch.invoke((Object)fact.toJAXBElement(request)));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1014_RESPONSE_INVOKING_RST(this.elemToString(rstr)));
        }
        return rstr;
    }

    protected static QName[] doMexRequest(String wsdlLocation, String stsURI) throws WSTrustException {
        QName[] serviceInfo = new QName[2];
        MetadataClient mexClient = new MetadataClient();
        Metadata metadata = mexClient.retrieveMetadata(wsdlLocation);
        if (metadata != null) {
            List<PortInfo> ports = mexClient.getServiceInformation(metadata);
            for (PortInfo port : ports) {
                String uri = port.getAddress();
                if (!uri.equals(stsURI)) continue;
                serviceInfo[0] = port.getServiceName();
                serviceInfo[1] = port.getPortName();
                break;
            }
            if (serviceInfo[0] == null || serviceInfo[1] == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
                throw new WSTrustException(LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation.toString()));
            throw new WSTrustException(LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation.toString()));
        }
        return serviceInfo;
    }

    private URI getSTSURI(IssuedToken issuedToken) {
        Address address;
        Issuer issuer = issuedToken.getIssuer();
        if (issuer != null && (address = issuer.getAddress()) != null) {
            return address.getURI();
        }
        return null;
    }

    private URI getAddressFromMetadata(IssuedToken issuedToken) {
        PolicyAssertion assertion;
        Iterator<PolicyAssertion> iterator;
        PolicyAssertion issuer = (PolicyAssertion)((Object)issuedToken.getIssuer());
        PolicyAssertion addressingMetadata = null;
        PolicyAssertion metadata = null;
        PolicyAssertion metadataSection = null;
        PolicyAssertion metadataReference = null;
        Address address = null;
        if (issuer != null) {
            address = ((Issuer)((Object)issuer)).getAddress();
            if (issuer.hasNestedAssertions()) {
                iterator = issuer.getNestedAssertionsIterator();
                while (iterator.hasNext()) {
                    assertion = iterator.next();
                    if (!WSTrustUtil.isAddressingMetadata(assertion)) continue;
                    addressingMetadata = assertion;
                    break;
                }
            }
        }
        if (addressingMetadata != null && addressingMetadata.hasNestedAssertions()) {
            iterator = addressingMetadata.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadata(assertion)) continue;
                metadata = assertion;
                break;
            }
        }
        if (metadata != null && metadata.hasNestedAssertions()) {
            iterator = metadata.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadataSection(assertion)) continue;
                metadataSection = assertion;
                break;
            }
        }
        if (metadataSection != null && metadataSection.hasNestedAssertions()) {
            iterator = metadataSection.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadataReference(assertion)) continue;
                metadataReference = assertion;
                break;
            }
        }
        if (metadataReference != null && metadataReference.hasNestedAssertions()) {
            iterator = metadataReference.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!PolicyUtil.isAddress(assertion)) continue;
                address = (Address)((Object)assertion);
            }
        }
        if (address != null) {
            return address.getURI();
        }
        return null;
    }

    private Claims getClaims(PolicyAssertion token, String appliesTo) throws WSTrustException {
        ClaimsImpl claims = null;
        Iterator<PolicyAssertion> tokens = token.getNestedAssertionsIterator();
        while (tokens.hasNext()) {
            PolicyAssertion cToken = tokens.next();
            if (!REQUEST_SECURITY_TOKEN_TEMPLATE.equals(cToken.getName().getLocalPart())) continue;
            Iterator<PolicyAssertion> cTokens = cToken.getNestedAssertionsIterator();
            while (cTokens.hasNext()) {
                PolicyAssertion gToken = cTokens.next();
                if (!CLAIMS.equals(gToken.getName().getLocalPart())) continue;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLOutputFactory xof = XMLOutputFactory.newInstance();
                    XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
                    AssertionSet set = AssertionSet.createAssertionSet(Arrays.asList(gToken));
                    Policy policy = Policy.createPolicy(Arrays.asList(set));
                    PolicySourceModel sourceModel = PolicyModelGenerator.getGenerator().translate(policy);
                    XmlPolicyModelMarshaller pm = (XmlPolicyModelMarshaller)XmlPolicyModelMarshaller.getXmlMarshaller(true);
                    pm.marshal(sourceModel, (Object)writer);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(baos.toByteArray()));
                    Element claimsEle = (Element)doc.getElementsByTagNameNS("*", CLAIMS).item(0);
                    claims = new ClaimsImpl(ClaimsImpl.fromElement(claimsEle));
                    writer.close();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WST_0045_ERROR_UNMARSHALL_CLAIMS(appliesTo), e);
                    throw new WebServiceException(LogStringsMessages.WST_0045_ERROR_UNMARSHALL_CLAIMS(appliesTo), (Throwable)e);
                }
            }
        }
        return claims;
    }

    private String elemToString(RequestSecurityToken rst) {
        try {
            Marshaller marshaller = fact.getContext().createMarshaller();
            JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)((Object)rst));
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal(rstElement, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_1004_ERROR_MARSHAL_TO_STRING("RST"), e);
            throw new WebServiceException(LogStringsMessages.WST_1004_ERROR_MARSHAL_TO_STRING("RST"), (Throwable)e);
        }
    }

    private String elemToString(RequestSecurityTokenResponse rstr) {
        try {
            Marshaller marshaller = fact.getContext().createMarshaller();
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal(rstrElement, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_1004_ERROR_MARSHAL_TO_STRING("RSTR"), e);
            throw new WebServiceException(LogStringsMessages.WST_1004_ERROR_MARSHAL_TO_STRING("RSTR"), (Throwable)e);
        }
    }
}

