/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.secconv.WSSCClientContract;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.WSTrustConstants;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import java.io.StringWriter;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.soap.SOAPFaultException;

public class NewWSSCPlugin {
    Configuration config;
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private static WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance();
    private static final int DEFAULT_KEY_SIZE = 256;
    private static final String SC_ASSERTION = "SecureConversationAssertion";
    private static final String FOR_ISSUE = "For Issue";
    private static final String FOR_CANCEL = "For Cancel";

    public NewWSSCPlugin(Configuration config) {
        this.config = config;
    }

    public RequestSecurityToken createIssueRequest(PolicyAssertion token) {
        SecureConversationToken scToken = (SecureConversationToken)((Object)token);
        AssertionSet assertions = this.getAssertions(scToken);
        Trust10 trust10 = null;
        Binding symBinding = null;
        for (PolicyAssertion policyAssertion : assertions) {
            if (PolicyUtil.isTrust10(policyAssertion)) {
                trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding(policyAssertion)) continue;
            symBinding = (SymmetricBinding)((Object)policyAssertion);
        }
        int skl = 256;
        boolean reqClientEntropy = false;
        if (symBinding != null) {
            AlgorithmSuite algoSuite = symBinding.getAlgorithmSuite();
            skl = algoSuite.getMinSKLAlgorithm();
            if (skl < 1) {
                skl = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSSC_1006_SYM_BIN_KEYSIZE(skl, 256));
            }
        }
        if (trust10 != null) {
            Set trustReqdProps = trust10.getRequiredProperties();
            reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityToken(reqClientEntropy, skl);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_ISSUE), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_ISSUE), ex);
        }
        catch (WSTrustException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0021_PROBLEM_CREATING_RST_TRUST(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0021_PROBLEM_CREATING_RST_TRUST(), ex);
        }
        return rst;
    }

    public Packet createIssuePacket(PolicyAssertion token, RequestSecurityToken rst, WSDLPort wsdlPort, WSBinding binding, JAXBContext jbCxt, String endPointAddress, Packet packet) {
        Packet ret = this.createSendRequestPacket(token, wsdlPort, binding, jbCxt, rst, "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT", endPointAddress, packet);
        return ret;
    }

    public RequestSecurityTokenResponse getRSTR(JAXBContext jbCxt, Packet respPacket) {
        JAXBElement rstrEle;
        Unmarshaller unmarshaller;
        try {
            unmarshaller = jbCxt.createUnmarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
        }
        Message response = respPacket.getMessage();
        RequestSecurityTokenResponse rstr = null;
        if (!response.isFault()) {
            rstrEle = null;
            try {
                rstrEle = (JAXBElement)response.readPayloadAsJAXB(unmarshaller);
            }
            catch (JAXBException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
            }
        } else {
            try {
                throw new SOAPFaultException(response.readAsSOAPMessage().getSOAPBody().getFault());
            }
            catch (SOAPException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
            }
        }
        rstr = eleFac.createRSTRFrom(rstrEle);
        return rstr;
    }

    public IssuedTokenContext processRSTR(IssuedTokenContext context, RequestSecurityToken rst, RequestSecurityTokenResponse rstr, String endPointAddress) {
        try {
            this.processRequestSecurityTokenResponse(rst, rstr, context);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
        context.setEndpointAddress(endPointAddress);
        return context;
    }

    private AssertionSet getAssertions(SecureConversationToken scToken) {
        return scToken.getBootstrapPolicy().getAssertionSet();
    }

    public RequestSecurityToken createCancelRequest(IssuedTokenContext ctx) {
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityTokenForCancel(ctx);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
        }
        return rst;
    }

    public Packet createCancelPacket(RequestSecurityToken rst, WSDLPort wsdlPort, WSBinding binding, JAXBContext jbCxt, String endPointAddress) {
        Packet ret = this.createSendRequestPacket(null, wsdlPort, binding, jbCxt, rst, "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel", endPointAddress, null);
        return ret;
    }

    public IssuedTokenContext processCancellation(IssuedTokenContext ctx, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, JAXBContext jbCxt, String endPointAddress) {
        RequestSecurityToken rst = null;
        try {
            rst = this.createRequestSecurityTokenForCancel(ctx);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0024_ERROR_CREATING_RST(FOR_CANCEL), ex);
        }
        RequestSecurityTokenResponse rstr = this.sendRequest(null, wsdlPort, binding, securityPipe, jbCxt, rst, "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel", endPointAddress, null);
        try {
            this.processRequestSecurityTokenResponse(rst, rstr, ctx);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
        return ctx;
    }

    private Packet createSendRequestPacket(PolicyAssertion issuedToken, WSDLPort wsdlPort, WSBinding binding, JAXBContext jbCxt, RequestSecurityToken rst, String action, String endPointAddress, Packet packet) {
        Marshaller marshaller;
        try {
            marshaller = jbCxt.createMarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
        }
        Message request = Messages.create(marshaller, (Object)eleFac.toJAXBElement(rst), binding.getSOAPVersion());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1009_SEND_REQ_MESSAGE(this.printMessageAsString(request)));
        }
        Packet reqPacket = new Packet(request);
        if (issuedToken != null) {
            reqPacket.invocationProperties.put(SC_ASSERTION, issuedToken);
        }
        if (packet != null) {
            for (WSTrustConstants.STS_PROPERTIES stsProperty : WSTrustConstants.STS_PROPERTIES.values()) {
                reqPacket.invocationProperties.put(stsProperty.toString(), packet.invocationProperties.get(stsProperty.toString()));
            }
        }
        reqPacket.setEndPointAddressString(endPointAddress);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1008_SET_EP_ADDRESS(endPointAddress));
        }
        try {
            reqPacket = this.addAddressingHeaders(reqPacket, wsdlPort, binding, action);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
        }
        if (packet != null) {
            reqPacket.contentNegotiation = packet.contentNegotiation;
        }
        return reqPacket;
    }

    private RequestSecurityTokenResponse sendRequest(PolicyAssertion issuedToken, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, JAXBContext jbCxt, RequestSecurityToken rst, String action, String endPointAddress, Packet packet) {
        JAXBElement rstrEle;
        Unmarshaller unmarshaller;
        Marshaller marshaller;
        try {
            marshaller = jbCxt.createMarshaller();
            unmarshaller = jbCxt.createUnmarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0016_PROBLEM_MAR_UNMAR(), ex);
        }
        Message request = Messages.create(marshaller, (Object)eleFac.toJAXBElement(rst), binding.getSOAPVersion());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1009_SEND_REQ_MESSAGE(this.printMessageAsString(request)));
        }
        Packet reqPacket = new Packet(request);
        if (issuedToken != null) {
            reqPacket.invocationProperties.put(SC_ASSERTION, issuedToken);
        }
        if (packet != null) {
            for (WSTrustConstants.STS_PROPERTIES stsProperty : WSTrustConstants.STS_PROPERTIES.values()) {
                reqPacket.invocationProperties.put(stsProperty.toString(), packet.invocationProperties.get(stsProperty.toString()));
            }
        }
        reqPacket.setEndPointAddressString(endPointAddress);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1008_SET_EP_ADDRESS(endPointAddress));
        }
        try {
            reqPacket = this.addAddressingHeaders(reqPacket, wsdlPort, binding, action);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0017_PROBLEM_ADD_ADDRESS_HEADERS(), ex);
        }
        if (packet != null) {
            reqPacket.contentNegotiation = packet.contentNegotiation;
        }
        Packet respPacket = securityPipe.process(reqPacket);
        Message response = respPacket.getMessage();
        RequestSecurityTokenResponse rstr = null;
        if (!response.isFault()) {
            rstrEle = null;
            try {
                rstrEle = (JAXBElement)response.readPayloadAsJAXB(unmarshaller);
            }
            catch (JAXBException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0018_ERR_JAXB_RSTR(), ex);
            }
        } else {
            try {
                throw new SOAPFaultException(response.readAsSOAPMessage().getSOAPBody().getFault());
            }
            catch (SOAPException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
                throw new RuntimeException(LogStringsMessages.WSSC_0022_PROBLEM_CREATING_FAULT(), ex);
            }
        }
        rstr = eleFac.createRSTRFrom(rstrEle);
        return rstr;
    }

    private RequestSecurityToken createRequestSecurityToken(boolean reqClientEntropy, int skl) throws WSSecureConversationException, WSTrustException {
        URI tokenType = URI.create("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        URI requestType = URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
        SecureRandom random = new SecureRandom();
        byte[] rawValue = new byte[skl / 8];
        random.nextBytes(rawValue);
        BinarySecret secret = eleFac.createBinarySecret(rawValue, "http://schemas.xmlsoap.org/ws/2005/02/trust/Nonce");
        Entropy entropy = reqClientEntropy ? eleFac.createEntropy(secret) : null;
        RequestSecurityToken rst = null;
        rst = eleFac.createRSTForIssue(tokenType, requestType, null, null, null, entropy, null);
        rst.setKeySize(skl);
        rst.setKeyType(URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey"));
        rst.setComputedKeyAlgorithm(URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1"));
        return rst;
    }

    private RequestSecurityToken createRequestSecurityTokenForCancel(IssuedTokenContext ctx) throws WSSecureConversationException {
        URI requestType = null;
        requestType = URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel");
        CancelTarget target = eleFac.createCancelTarget((SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference());
        RequestSecurityToken rst = eleFac.createRSTForCancel(requestType, target);
        return rst;
    }

    private void processRequestSecurityTokenResponse(RequestSecurityToken rst, RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        WSSCClientContract contract = WSSCFactory.newWSSCClientContract(this.config);
        contract.handleRSTR(rst, rstr, context);
    }

    private String printMessageAsString(Message message) {
        StringWriter writer = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter streamWriter = factory.createXMLStreamWriter(writer);
            message.writeTo(streamWriter);
            streamWriter.flush();
            return writer.toString();
        }
        catch (XMLStreamException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0025_PROBLEM_PRINTING_MSG(), ex);
        }
    }

    private Packet addAddressingHeaders(Packet packet, WSDLPort wsdlPort, WSBinding binding, String action) throws WSSecureConversationException {
        HeaderList headers = packet.getMessage().getHeaders();
        headers.fillRequestAddressingHeaders(packet, binding.getAddressingVersion(), binding.getSOAPVersion(), false, action);
        return packet;
    }
}

