/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.Token;
import com.sun.xml.ws.security.opt.api.reference.Reference;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyName;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TokenBuilder
implements com.sun.xml.ws.security.opt.api.keyinfo.TokenBuilder {
    protected static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.token", "com.sun.xml.wss.logging.impl.opt.token.LogStrings");
    protected JAXBFilterProcessingContext context = null;
    protected SecurityHeader securityHeader = null;
    protected static WSSElementFactory elementFactory = null;
    protected KeyInfo keyInfo = null;

    public TokenBuilder(JAXBFilterProcessingContext context) {
        this.context = context;
        this.securityHeader = context.getSecurityHeader();
        elementFactory = new WSSElementFactory(context.getSOAPVersion());
    }

    protected com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken createBinarySecurityToken(AuthenticationTokenPolicy.X509CertificateBinding binding, X509Certificate x509Cert) throws XWSSecurityException {
        BinarySecurityToken bst;
        Token token;
        if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER.equals(binding.getIncludeToken())) {
            return null;
        }
        String id = this.getID(binding);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "X509 Token id: " + id);
        }
        if ((token = (Token)((Object)this.securityHeader.getChildElement(id))) != null) {
            if (token instanceof com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken) {
                return (com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken)token;
            }
            throw new XWSSecurityException("Found two tokens with same Id attribute");
        }
        try {
            bst = elementFactory.createBinarySecurityToken(id, x509Cert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1801_BST_CREATION_FAILED());
            throw new XWSSecurityException("Error occured while constructing BinarySecurityToken", ex);
        }
        this.context.getSecurityHeader().add(bst);
        return bst;
    }

    protected SecurityTokenReference buildSTR(String strId, Reference ref) {
        SecurityTokenReference str = elementFactory.createSecurityTokenReference(ref);
        if (this.context.getSecurityPolicy() instanceof SignaturePolicy) {
            str.setId(strId);
        }
        SSEData data = new SSEData(str, false, this.context.getNamespaceContext());
        this.context.getElementCache().put(strId, data);
        return str;
    }

    protected SecurityTokenReference buildSTR(Reference ref) {
        SecurityTokenReference str = elementFactory.createSecurityTokenReference(ref);
        return str;
    }

    protected KeyInfo buildKeyInfo(Reference ref, String strId) {
        this.keyInfo = elementFactory.createKeyInfo(this.buildSTR(strId, ref));
        return this.keyInfo;
    }

    protected KeyInfo buildKeyInfo(SecurityTokenReference str) {
        this.keyInfo = elementFactory.createKeyInfo(str);
        return this.keyInfo;
    }

    protected KeyInfo buildKIWithKeyName(String name) {
        KeyName kn = new KeyName();
        kn.setKeyName(name);
        this.keyInfo = elementFactory.createKeyInfo(kn);
        return this.keyInfo;
    }

    protected DirectReference buildDirectReference(String id, String valueType) {
        DirectReference dr = elementFactory.createDirectReference();
        dr.setURI("#" + id);
        if (valueType != null) {
            dr.setValueType(valueType);
        }
        return dr;
    }

    protected KeyIdentifier buildKeyInfoWithKI(AuthenticationTokenPolicy.X509CertificateBinding binding, String refType) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = elementFactory.createKeyIdentifier();
        keyIdentifier.setValueType(refType);
        keyIdentifier.updateReferenceValue(binding.getX509Certificate());
        keyIdentifier.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        if (keyIdentifier.getValue() == null || keyIdentifier.getValue().length() == 0) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1852_KEY_IDENTIFIER_EMPTY());
            throw new XWSSecurityException(LogStringsMessages.WSS_1852_KEY_IDENTIFIER_EMPTY());
        }
        this.buildKeyInfo(keyIdentifier, binding.getSTRID());
        return keyIdentifier;
    }

    protected KeyIdentifier buildKeyInfoWithEKSHA1(String ekSHA1Ref) {
        KeyIdentifier keyIdentifier = elementFactory.createKeyIdentifier();
        keyIdentifier.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1");
        keyIdentifier.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        keyIdentifier.setReferenceValue(ekSHA1Ref);
        this.buildKeyInfo(keyIdentifier, null);
        return keyIdentifier;
    }

    protected String getID(WSSPolicy policy) {
        String id = policy.getUUID();
        if (id == null || id.length() == 0) {
            return this.context.generateID();
        }
        return id;
    }

    public javax.xml.crypto.dsig.keyinfo.KeyInfo getKeyInfo() {
        return this.keyInfo;
    }
}

