/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedElements
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.EncryptedElements,
SecurityAssertionValidator {
    private String xpathVersion;
    private ArrayList<String> targetList;
    private static List<String> emptyList = Collections.emptyList();
    private boolean populated = false;
    private static QName XPathVersion = new QName("XPathVersion");
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;

    public EncryptedElements() {
    }

    public EncryptedElements(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public void addTarget(String target) {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        this.targetList.add(target);
    }

    public void removeTarget(String target) {
        if (this.targetList != null) {
            this.targetList.remove(target);
        }
    }

    @Override
    public Iterator<String> getTargets() {
        this.populate();
        if (this.targetList != null) {
            return this.targetList.iterator();
        }
        return emptyList.iterator();
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            Iterator<PolicyAssertion> it;
            this.xpathVersion = this.getAttributeValue(XPathVersion);
            if (this.hasNestedAssertions() && (it = this.getNestedAssertionsIterator()).hasNext()) {
                PolicyAssertion assertion = it.next();
                if (PolicyUtil.isXPath(assertion)) {
                    this.addTarget(assertion.getValue());
                } else if (!assertion.isOptional()) {
                    Constants.log_invalid_assertion(assertion, isServer, "EncryptedElements");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

