/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl;

import com.sun.xml.ws.security.DerivedKeyToken;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DerivedKeyTokenImpl
implements DerivedKeyToken {
    private long length = 32L;
    private long offset = 0L;
    private long generation = 0L;
    private String label = "WS-SecureConversationWS-SecureConversation";
    private byte[] secret;
    private byte[] nonce;

    public DerivedKeyTokenImpl(long offset, long length, byte[] secret) {
        this.offset = offset;
        this.length = length;
        this.secret = secret;
        try {
            this.nonce = new byte[18];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.nonce);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such algorithm found" + e.getMessage());
        }
    }

    public DerivedKeyTokenImpl(long offset, long length, byte[] secret, byte[] nonce) {
        this.offset = offset;
        this.length = length;
        this.secret = secret;
        this.nonce = nonce;
    }

    public DerivedKeyTokenImpl(long offset, long length, byte[] secret, byte[] nonce, String label) {
        this.offset = offset;
        this.length = length;
        this.secret = secret;
        this.nonce = nonce;
        if (label != null) {
            this.label = label;
        }
    }

    public DerivedKeyTokenImpl(long generation, byte[] secret) {
        this.generation = generation;
        this.secret = secret;
        try {
            this.nonce = new byte[18];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.nonce);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such algorithm found" + e.getMessage());
        }
    }

    public URI getAlgorithm() {
        try {
            return new URI("http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public long getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getType() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
    }

    public Object getTokenValue() {
        return null;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public SecretKey generateSymmetricKey(String algorithm) throws Exception {
        try {
            byte[] temp = this.label.getBytes("UTF-8");
            byte[] seed = new byte[temp.length + this.nonce.length];
            System.arraycopy(temp, 0, seed, 0, temp.length);
            System.arraycopy(this.nonce, 0, seed, temp.length, this.nonce.length);
            byte[] tempBytes = SecurityUtil.P_SHA1(this.secret, seed, (int)(this.offset + this.length));
            byte[] key = new byte[(int)this.length];
            for (int i = 0; i < key.length; ++i) {
                key[i] = tempBytes[i + (int)this.offset];
            }
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            return keySpec;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }
}

