/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.protocol;

import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.protocol.Messages;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AcknowledgementHandler {
    private static final Logger logger = Logger.getLogger(AcknowledgementHandler.class.getName());
    protected SequenceConfig config;

    public AcknowledgementHandler(SequenceConfig seqConfig) {
        this.config = seqConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAcknowledgement(OutboundSequence sequence, SequenceAcknowledgementElement element) throws InvalidMessageNumberException {
        OutboundSequence outboundSequence = sequence;
        synchronized (outboundSequence) {
            sequence.setBufferRemaining(element.getBufferRemaining());
            List<SequenceAcknowledgementElement.AcknowledgementRange> ranges = element.getAcknowledgementRange();
            List<BigInteger> nacks = element.getNack();
            if (nacks != null && !nacks.isEmpty()) {
                int size = sequence.getNextIndex() + 1;
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                for (int i = 1; i < sequence.getNextIndex(); ++i) {
                    list.set(i, true);
                }
                for (BigInteger big : nacks) {
                    int index = (int)big.longValue();
                    list.set(index, false);
                }
                for (int i = 1; i < sequence.getNextIndex(); ++i) {
                    Message mess = sequence.get(i);
                    if (!((Boolean)list.get(i)).booleanValue()) continue;
                    this.acknowledgeIfValid(sequence, i);
                }
            } else {
                for (SequenceAcknowledgementElement.AcknowledgementRange range : ranges) {
                    int lower = range.getLower().intValue();
                    int upper = range.getUpper().intValue();
                    if (sequence.isLast() && upper == sequence.getNextIndex()) {
                        --upper;
                    }
                    for (int i = lower; i <= upper; ++i) {
                        this.acknowledgeIfValid(sequence, i);
                    }
                }
            }
        }
    }

    private void acknowledgeIfValid(OutboundSequence seq, int i) {
        try {
            Message mess = seq.get(i);
            if (mess != null) {
                seq.acknowledge(i);
            }
        }
        catch (InvalidMessageNumberException e) {
            logger.fine(Messages.ACKNOWLEDGEMENT_MESSAGE.format(seq.getId(), i));
        }
    }
}

