/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Sequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.Identifier;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import java.net.URI;
import javax.xml.bind.Marshaller;

public abstract class InboundSequence
extends Sequence {
    protected SequenceConfig config;
    protected URI acksTo;
    protected OutboundSequence outboundSequence;
    private String strId;

    public InboundSequence() {
    }

    public InboundSequence(URI acksTo, SequenceConfig config) {
        this.acksTo = acksTo;
        this.config = config;
        this.rmConstants = config.getRMConstants();
    }

    public synchronized SequenceAcknowledgementElement generateSequenceAcknowledgement(AckRequestedElement reqElement, Marshaller marshaller) throws InvalidMessageNumberException {
        boolean gap;
        SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
        Identifier id = new Identifier();
        id.setValue(this.getId());
        ackElement.setIdentifier(id);
        if (this.config != null && this.config.flowControl) {
            ackElement.setBufferRemaining(this.maxMessages - this.storedMessages);
        }
        int maxMessageNumber = 0;
        if (reqElement != null) {
            maxMessageNumber = (int)reqElement.getMaxMessageNumber();
        }
        if (maxMessageNumber == 0) {
            maxMessageNumber = this.nextIndex - 1;
        }
        int lower = 1;
        int current = 1;
        boolean bl = gap = this.get(current) == null;
        while (current <= maxMessageNumber) {
            if (gap) {
                if (this.get(current) != null) {
                    lower = current;
                    gap = false;
                }
            } else if (this.get(current) == null) {
                ackElement.addAckRange(lower, current - 1);
                gap = true;
            }
            ++current;
        }
        if (!gap) {
            ackElement.addAckRange(lower, current - 1);
        }
        return ackElement;
    }

    public synchronized void handleAckRequested(AckRequestedElement reqElement, Marshaller marshaller) throws InvalidMessageNumberException {
        SequenceAcknowledgementElement ackElement = this.generateSequenceAcknowledgement(reqElement, marshaller);
        this.outboundSequence.setSequenceAcknowledgement(ackElement);
    }

    public OutboundSequence getOutboundSequence() {
        return this.outboundSequence;
    }

    public String getStrId() {
        return this.strId;
    }

    public void setStrId(String strId) {
        this.strId = strId;
    }

    public SequenceConfig getSequenceConfig() {
        return this.config;
    }

    public String getSessionId() {
        return this.strId != null ? this.strId : this.getId();
    }
}

