/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.rm.Messages;
import com.sun.xml.ws.rm.RMBuilder;
import com.sun.xml.ws.rm.Sequence;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.protocol.SequenceElement;

public class Message {
    protected com.sun.xml.ws.api.message.Message message;
    protected Sequence sequence = null;
    protected int messageNumber = 0;
    protected boolean isWaiting = false;
    protected boolean isComplete = false;
    protected Message relatedMessage = null;
    protected SequenceElement sequenceElement = null;
    protected SequenceAcknowledgementElement sequenceAcknowledgementElement = null;
    protected AckRequestedElement ackRequestedElement = null;
    public boolean isTwoWayRequest = false;
    public boolean isOneWayResponse = false;
    public static final String namespaceURI = RMBuilder.getConstants().getNamespaceURI();

    public Message(com.sun.xml.ws.api.message.Message message) {
        this.message = message;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public Message getRelatedMessage() {
        return this.relatedMessage;
    }

    public void setRelatedMessage(Message mess) {
        mess.copyContents();
        this.relatedMessage = mess;
    }

    public Header getHeader(String name) {
        if (this.message == null || !this.message.hasHeaders()) {
            return null;
        }
        return this.message.getHeaders().get(namespaceURI, name, true);
    }

    public void addHeader(Header header) {
        this.message.getHeaders().add(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Sequence sequence = this.sequence;
        synchronized (sequence) {
            return this.isComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Sequence sequence = this.sequence;
        synchronized (sequence) {
            this.message = null;
            this.isComplete = true;
        }
    }

    public synchronized void block() {
        this.isWaiting = true;
        try {
            while (!this.isComplete && this.isWaiting) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void resume() {
        this.isWaiting = false;
        this.notify();
    }

    public synchronized boolean isWaiting() {
        return this.isWaiting;
    }

    public com.sun.xml.ws.api.message.Message getCopy() {
        return this.message == null ? null : this.message.copy();
    }

    public void copyContents() {
        if (this.message != null) {
            com.sun.xml.ws.api.message.Message newmessage;
            this.message = newmessage = this.message.copy();
        }
    }

    public String toString() {
        AckRequestedElement ael;
        SequenceAcknowledgementElement sael;
        String ret = Messages.MESSAGE_NUMBER_STRING.format(this.messageNumber);
        ret = ret + Messages.SEQUENCE_STRING.format(this.getSequence() != null ? this.getSequence().getId() : "null");
        SequenceElement sel = this.getSequenceElement();
        if (null != sel) {
            ret = ret + sel.toString();
        }
        if (null != (sael = this.getSequenceAcknowledgementElement())) {
            ret = ret + sael.toString();
        }
        if (null != (ael = this.getAckRequestedElement())) {
            ret = ret + ael.toString();
        }
        return ret;
    }

    public SequenceAcknowledgementElement getSequenceAcknowledgementElement() {
        return this.sequenceAcknowledgementElement;
    }

    public void setSequenceAcknowledgementElement(SequenceAcknowledgementElement el) {
        this.sequenceAcknowledgementElement = el;
    }

    public SequenceElement getSequenceElement() {
        return this.sequenceElement;
    }

    public void setSequenceElement(SequenceElement el) {
        this.sequenceElement = el;
    }

    public AckRequestedElement getAckRequestedElement() {
        return this.ackRequestedElement;
    }

    public void setAckRequestedElement(AckRequestedElement el) {
        this.ackRequestedElement = el;
    }
}

