/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.InvocationProcessingException;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.InvocationProcessor;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.InvocationProcessingState;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class FilteringInvocationProcessor
implements InvocationProcessor {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(FilteringInvocationProcessor.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter originalWriter;
    private final XMLStreamWriter mirrorWriter;
    private final LinkedList<InvocationBuffer> invocationBuffers;
    private final StateMachineContext[] stateMachineContexts;
    private final List<StateMachineContext> startBufferingCandidates;
    private final List<StateMachineContext> stopBufferingCandidates;
    private final List<StateMachineContext> startFilteringCandidates;
    private int filteringCount;
    private boolean doFiltering;

    public FilteringInvocationProcessor(XMLStreamWriter writer, FilteringStateMachine ... stateMachines) throws XMLStreamException {
        this.originalWriter = writer;
        this.stateMachineContexts = new StateMachineContext[stateMachines.length];
        for (int i = 0; i < stateMachines.length; ++i) {
            this.stateMachineContexts[i] = new StateMachineContext(stateMachines[i]);
        }
        this.mirrorWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(new StringWriter());
        this.invocationBuffers = new LinkedList();
        this.startBufferingCandidates = new LinkedList<StateMachineContext>();
        this.stopBufferingCandidates = new LinkedList<StateMachineContext>();
        this.startFilteringCandidates = new LinkedList<StateMachineContext>();
    }

    public Object process(Invocation invocation) throws InvocationProcessingException {
        LOGGER.entering(invocation);
        try {
            XMLStreamWriter invocationTarget;
            InvocationBuffer buffer;
            this.startBufferingCandidates.clear();
            this.stopBufferingCandidates.clear();
            this.startFilteringCandidates.clear();
            block13: for (StateMachineContext context : this.stateMachineContexts) {
                InvocationProcessingState state = context.getStateMachine().getState(invocation, this.mirrorWriter);
                switch (state) {
                    case START_BUFFERING: 
                    case RESTART_BUFFERING: {
                        this.startBufferingCandidates.add(context);
                        if (state == InvocationProcessingState.START_BUFFERING) continue block13;
                    }
                    case STOP_BUFFERING: {
                        if (context.getBuffer() == null) continue block13;
                        this.stopBufferingCandidates.add(context);
                        continue block13;
                    }
                    case START_FILTERING: {
                        if (context.getBuffer() != null) {
                            this.startFilteringCandidates.add(context);
                        }
                        ++this.filteringCount;
                        continue block13;
                    }
                    case STOP_FILTERING: {
                        --this.filteringCount;
                        continue block13;
                    }
                }
            }
            int firstFilteredBufferIndex = this.invocationBuffers.size();
            for (StateMachineContext context : this.startFilteringCandidates) {
                buffer = context.getBuffer();
                context.setBuffer(null);
                int currentBufferIndex = this.invocationBuffers.indexOf(buffer);
                if (currentBufferIndex >= firstFilteredBufferIndex) continue;
                firstFilteredBufferIndex = currentBufferIndex;
            }
            while (this.invocationBuffers.size() > firstFilteredBufferIndex) {
                InvocationBuffer filteredBuffer = this.invocationBuffers.removeLast();
                filteredBuffer.clear();
            }
            for (StateMachineContext context : this.stopBufferingCandidates) {
                int bufferIndex;
                int newRefCount;
                buffer = context.getBuffer();
                context.setBuffer(null);
                if (buffer == null || (newRefCount = buffer.removeReference()) != 0 || (bufferIndex = this.invocationBuffers.indexOf(buffer)) == -1) continue;
                this.invocationBuffers.remove(bufferIndex);
                if (bufferIndex == 0) {
                    this.executeCommands(this.originalWriter, buffer);
                    continue;
                }
                this.invocationBuffers.get(bufferIndex - 1).getQueue().addAll(buffer.getQueue());
            }
            if (this.filteringCount == 0 && this.startBufferingCandidates.size() > 0) {
                InvocationBuffer buffer2 = new InvocationBuffer(this.startBufferingCandidates.size());
                this.invocationBuffers.addLast(buffer2);
                for (StateMachineContext context : this.startBufferingCandidates) {
                    context.setBuffer(buffer2);
                }
            }
            if (!this.doFiltering) {
                boolean bl = this.doFiltering = this.filteringCount > 0;
            }
            if (this.doFiltering) {
                this.doFiltering = this.filteringCount > 0;
                invocationTarget = this.mirrorWriter;
            } else if (this.invocationBuffers.isEmpty()) {
                invocation.execute(this.mirrorWriter);
                invocationTarget = this.originalWriter;
            } else {
                this.invocationBuffers.getLast().getQueue().offer(invocation);
                invocationTarget = this.mirrorWriter;
            }
            Object object = invocation.execute(invocationTarget);
            return object;
        }
        catch (IllegalArgumentException e) {
            throw LOGGER.logSevereException(new InvocationProcessingException(invocation, (Throwable)e));
        }
        catch (InvocationTargetException e) {
            throw LOGGER.logSevereException(new InvocationProcessingException(invocation, e.getCause()));
        }
        catch (IllegalAccessException e) {
            throw LOGGER.logSevereException(new InvocationProcessingException(invocation, (Throwable)e));
        }
        finally {
            LOGGER.exiting();
        }
    }

    private void executeCommands(XMLStreamWriter writer, InvocationBuffer invocationBuffer) throws IllegalAccessException, InvocationProcessingException {
        Queue<Invocation> invocationQueue = invocationBuffer.getQueue();
        while (!invocationQueue.isEmpty()) {
            Invocation command = invocationQueue.poll();
            try {
                command.execute(writer);
            }
            catch (InvocationTargetException e) {
                throw LOGGER.logSevereException(new InvocationProcessingException(command, (Throwable)e));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvocationBuffer {
        private final Queue<Invocation> queue = new LinkedList<Invocation>();
        private int referenceCount;

        InvocationBuffer(int refCount) {
            this.referenceCount = refCount;
        }

        public Queue<Invocation> getQueue() {
            return this.queue;
        }

        public int removeReference() {
            if (this.referenceCount > 0) {
                --this.referenceCount;
            }
            return this.referenceCount;
        }

        public void clear() {
            this.queue.clear();
            this.referenceCount = 0;
        }
    }

    private final class StateMachineContext {
        private final FilteringStateMachine stateMachine;
        private WeakReference<InvocationBuffer> bufferRef;

        StateMachineContext(FilteringStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            this.bufferRef = null;
        }

        public FilteringStateMachine getStateMachine() {
            return this.stateMachine;
        }

        public InvocationBuffer getBuffer() {
            return this.bufferRef == null ? null : (InvocationBuffer)this.bufferRef.get();
        }

        public void setBuffer(InvocationBuffer buffer) {
            this.bufferRef = new WeakReference<InvocationBuffer>(buffer);
        }
    }
}

