/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyMerger {
    private static final PolicyMerger merger = new PolicyMerger();

    private PolicyMerger() {
    }

    public static PolicyMerger getMerger() {
        return merger;
    }

    public Policy merge(Collection<Policy> policies) {
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        if (policies.size() == 1) {
            return policies.iterator().next();
        }
        LinkedList<Collection<AssertionSet>> alternativeSets = new LinkedList<Collection<AssertionSet>>();
        for (Policy policy : policies) {
            alternativeSets.add(policy.getContent());
        }
        Collection combinedAlternatives = PolicyUtils.Collections.combine(null, alternativeSets, false);
        if (combinedAlternatives == null || combinedAlternatives.isEmpty()) {
            return Policy.createNullPolicy();
        }
        ArrayList<AssertionSet> mergedSetList = new ArrayList<AssertionSet>(combinedAlternatives.size());
        for (Collection<AssertionSet> collection : combinedAlternatives) {
            mergedSetList.add(AssertionSet.createMergedAssertionSet(collection));
        }
        return Policy.createPolicy(mergedSetList);
    }
}

