/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyConstants;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.sourcemodel.ModelNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyAssertion {
    private final AssertionData data;
    private AssertionSet parameters;
    private NestedPolicy nestedPolicy;

    protected PolicyAssertion() {
        this.data = AssertionData.createAssertionData(null);
    }

    protected PolicyAssertion(AssertionData assertionData, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) {
        this.data = assertionData;
        if (nestedAlternative != null) {
            this.nestedPolicy = NestedPolicy.createNestedPolicy(nestedAlternative);
        }
        this.parameters = AssertionSet.createAssertionSet(assertionParameters);
    }

    public final QName getName() {
        return this.data.getName();
    }

    public final String getValue() {
        return this.data.getValue();
    }

    public boolean isOptional() {
        boolean result = false;
        String attributeValue = this.getAttributeValue(PolicyConstants.OPTIONAL);
        if (attributeValue != null) {
            result = Boolean.parseBoolean(attributeValue);
        }
        return result;
    }

    public final boolean isPrivate() {
        return this.data.isPrivateAttributeSet();
    }

    public final Set<Map.Entry<QName, String>> getAttributesSet() {
        return this.data.getAttributesSet();
    }

    public final Map<QName, String> getAttributes() {
        return this.data.getAttributes();
    }

    public final String getAttributeValue(QName name) {
        return this.data.getAttributeValue(name);
    }

    public final boolean hasNestedAssertions() {
        return !this.parameters.isEmpty();
    }

    public final Iterator<PolicyAssertion> getNestedAssertionsIterator() {
        return this.parameters.iterator();
    }

    boolean isParameter() {
        return this.data.getNodeType() == ModelNode.Type.ASSERTION_PARAMETER_NODE;
    }

    public final boolean hasNestedPolicy() {
        return this.nestedPolicy != null;
    }

    public final NestedPolicy getNestedPolicy() {
        return this.nestedPolicy;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    protected StringBuffer toString(int indentLevel, StringBuffer buffer) {
        String indent = PolicyUtils.Text.createIndent(indentLevel);
        String innerIndent = PolicyUtils.Text.createIndent(indentLevel + 1);
        buffer.append(indent).append("Assertion {").append(PolicyUtils.Text.NEW_LINE);
        this.data.toString(indentLevel + 1, buffer);
        buffer.append(PolicyUtils.Text.NEW_LINE);
        if (this.hasNestedAssertions()) {
            buffer.append(innerIndent).append("parameters {").append(PolicyUtils.Text.NEW_LINE);
            for (PolicyAssertion parameter : this.parameters) {
                parameter.toString(indentLevel + 2, buffer);
            }
            buffer.append(innerIndent).append('}').append(PolicyUtils.Text.NEW_LINE);
        } else {
            buffer.append(innerIndent).append("no parameters").append(PolicyUtils.Text.NEW_LINE);
        }
        if (this.hasNestedPolicy()) {
            this.nestedPolicy.toString(indentLevel + 1, buffer).append(PolicyUtils.Text.NEW_LINE);
        } else {
            buffer.append(innerIndent).append("no nested policy").append(PolicyUtils.Text.NEW_LINE);
        }
        buffer.append(indent).append('}');
        return buffer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolicyAssertion)) {
            return false;
        }
        PolicyAssertion that = (PolicyAssertion)obj;
        boolean result = true;
        result = result && this.data.equals(that.data);
        boolean bl = result = result && this.parameters.equals(that.parameters);
        result = result && (this.nestedPolicy == null ? that.nestedPolicy == null : this.nestedPolicy.equals(that.nestedPolicy));
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.data.hashCode();
        result = 37 * result + (this.hasNestedAssertions() ? 17 : 0);
        result = 37 * result + (this.hasNestedPolicy() ? 17 : 0);
        return result;
    }
}

