/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.relation;

import com.sun.cmm.CMM_Object;
import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.MfObjectFactory;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.relation.RelationMappingService;
import com.sun.mfwk.relations.Relation;
import com.sun.mfwk.relations.RelationType;
import java.lang.reflect.Field;
import org.w3c.dom.Element;

class RelationFactory {
    private ModelerContext _context = null;

    RelationFactory(ModelerContext ctx) {
        this._context = ctx;
    }

    Relation create(Element relation, RelationMappingService rms) throws Exception {
        String source = rms.getSource(relation);
        String dest = rms.getDestination(relation);
        String type = rms.getType(relation);
        CMM_MBean sMbean = this.getMBean(source);
        CMM_MBean dMbean = this.getMBean(dest);
        Class typeClass = this.getTypeName(type);
        Relation r = new Relation((CMM_Object)sMbean, (CMM_Object)dMbean, typeClass, null, this._context.getModuleName());
        return r;
    }

    Relation create(String source, String dest, String type) throws Exception {
        return this.create(source, dest, type, false);
    }

    Relation create(String source, String dest, String type, boolean anyway) throws Exception {
        CMM_MBean sMbean = this.getMBean(source);
        CMM_MBean dMbean = this.getMBean(dest);
        Class typeClass = this.getTypeName(type);
        LogDomains.getLogger().finest("source mbean = " + sMbean);
        LogDomains.getLogger().finest("dest mbean = " + dMbean);
        LogDomains.getLogger().finest("type = " + typeClass);
        if (sMbean != null && dMbean != null) {
            return new Relation((CMM_Object)sMbean, (CMM_Object)dMbean, typeClass, null, this._context.getModuleName());
        }
        if (anyway) {
            if (dMbean != null) {
                return new Relation(source, (CMM_Object)dMbean, typeClass, null, this._context.getModuleName());
            }
            if (sMbean != null) {
                return new Relation((CMM_Object)sMbean, dest, typeClass, null, this._context.getModuleName());
            }
        }
        return null;
    }

    Class getTypeName(String type) throws NoSuchFieldException, IllegalAccessException {
        Class typeName = null;
        Class<RelationType> rtClass = RelationType.class;
        Field f = rtClass.getField(type);
        Object obj = f.get(null);
        if (obj instanceof RelationType) {
            RelationType rt = (RelationType)obj;
            typeName = rt.getRelationTypeName();
        }
        return typeName;
    }

    CMM_MBean getMBean(String oid) throws Exception {
        String tokenizedOID;
        CMM_MBean mbean = null;
        MfObjectFactory factory = MfObjectFactory.getObjectFactory((String)this._context.getModuleName());
        if (factory.isObjectCreated(tokenizedOID = ObjectNameHelper.tokenize(oid, this._context.getTokens()))) {
            mbean = factory.getObject(tokenizedOID);
        }
        return mbean;
    }
}

