/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import com.sun.mfwk.MfDelegate;
import com.sun.mfwk.agent.appserv.delegate.DefaultDelegate;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.modeler.ConfigReader;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class DelegateFactory {
    private Element _mbean = null;
    private MfDelegate _delegate = null;
    private ModelerContext _context = null;
    private MBeanServerConnection _mbs = null;

    DelegateFactory(Element mbean, MfDelegate delegate, ModelerContext ctx, MBeanServerConnection mbs) {
        this._mbean = mbean;
        this._delegate = delegate;
        this._context = ctx;
        this._mbs = mbs;
    }

    Object create() throws MalformedObjectNameException, IOException, NoSuchFieldException {
        DefaultDelegate dd = null;
        if (this._delegate instanceof DefaultDelegate) {
            dd = (DefaultDelegate)this._delegate;
            LogDomains.getLogger().fine("Delegate is instanceof DefaultDelegate");
        } else {
            LogDomains.getLogger().fine("Delegate is NOT instanceof DefaultDelegate: " + this._delegate);
            dd = new DefaultDelegate();
        }
        NodeList attr = ConfigReader.getMBeanAttrMappings(this._mbean);
        int idx = attr.getLength();
        for (int i = 0; i < idx; ++i) {
            Element e = (Element)attr.item(i);
            String mfAttr = e.getAttribute("id").trim();
            String asAttr = e.getAttribute("name").trim();
            String asObjName = e.getAttribute("type").trim();
            String tokenizedON = ObjectNameHelper.tokenize(asObjName, this._context.getTokens());
            ObjectName on = ObjectNameHelper.getObjectName(tokenizedON, this._mbs);
            dd.addMappingEntry(mfAttr, asAttr, on);
        }
        String instanceName = this._context.getServerName();
        dd.setServerName(instanceName);
        return dd;
    }
}

