/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.lifecycle;

import com.sun.mfwk.agent.appserv.lifecycle.beans.Attribute;
import com.sun.mfwk.agent.appserv.lifecycle.beans.Mapping;
import com.sun.mfwk.agent.appserv.lifecycle.beans.Notifications;
import com.sun.mfwk.agent.appserv.lifecycle.beans.ObjectName;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.util.BundleReader;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

abstract class AbstractListener
implements NotificationListener {
    private static String notificationsFile = "com/sun/mfwk/agent/appserv/lifecycle/dtds/notifications.xml";
    private static Notifications notifications = null;
    private MBeanServerConnection connection = null;
    private NotificationListener client = null;
    private NotificationFilter filter = null;
    private Object handback = null;
    private Map runtimeToMonitoring;
    private String asInstance = null;
    private String asDomain = null;
    public static final int STARTING_STATE = 0;
    public static final int RUNNING_STATE = 1;
    public static final int STOPPING_STATE = 2;
    public static final int STOPPED_STATE = 3;
    public static final int FAILED_STATE = 4;

    AbstractListener(MBeanServerConnection connection, String asInstance, String asDomain, NotificationListener client, NotificationFilter filter, Object handback) {
        this.connection = connection;
        this.client = client;
        this.filter = filter;
        this.handback = handback;
        this.asInstance = asInstance;
        this.asDomain = asDomain;
        this.runtimeToMonitoring = new HashMap();
    }

    private boolean isNotificationEnabled(Notification notification) {
        javax.management.ObjectName objectName = this.getObjectName(notification);
        assert (objectName != null);
        if (objectName != null) {
            try {
                String domain;
                Notifications notifications = AbstractListener.getNotifications();
                if (notifications != null && (domain = notifications.getDomain()).equals(objectName.getDomain())) {
                    ObjectName name = null;
                    if (!this.asInstance.equals(objectName.getKeyProperty("server"))) {
                        return false;
                    }
                    for (int i = 0; i < notifications.sizeObjectName(); ++i) {
                        name = notifications.getObjectName(i);
                        Attribute attribute = null;
                        String attributeName = null;
                        String attributeValue = null;
                        String value = null;
                        boolean ofInterest = true;
                        for (int j = 0; j < name.sizeAttribute(); ++j) {
                            attribute = name.getAttribute(j);
                            attributeName = attribute.getName();
                            attributeValue = attribute.getValue();
                            value = objectName.getKeyProperty(attributeName);
                            if (attributeValue != null) {
                                if (attributeValue.equals(value)) continue;
                                ofInterest = false;
                                break;
                            }
                            if (value == null) continue;
                            ofInterest = false;
                            break;
                        }
                        if (!ofInterest) continue;
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                Utils.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return false;
    }

    public void handleNotification(Notification notification, Object handback) {
        javax.management.ObjectName objectName;
        if (this.isNotificationEnabled(notification) && (objectName = this.getObjectName(notification)) != null && this.client != null) {
            notification.setUserData(objectName);
            this.client.handleNotification(notification, handback);
        }
    }

    boolean isMatch(MBeanServerConnection connection, NotificationListener client) {
        return connection.equals(this.connection) && client.equals(this.client);
    }

    boolean isMatch(MBeanServerConnection connection, NotificationListener client, NotificationFilter filter, Object handback) {
        return this.isMatch(connection, client) && filter.equals(this.filter) && handback.equals(this.handback);
    }

    void registerListener() throws InstanceNotFoundException, IOException {
        javax.management.ObjectName objectName = this.getObjectName(this.connection);
        if (objectName != null) {
            assert (this.connection != null) : "Connection not available";
            if (this.connection != null && this.client != null) {
                if (this.filter != null) {
                    this.connection.addNotificationListener(objectName, this.client, this.filter, this.handback);
                } else {
                    this.connection.addNotificationListener(objectName, this, null, this.handback);
                }
            } else {
                Utils.log(Level.INFO, "Listener not registered. Invalid arguments");
            }
        } else {
            Utils.log(Level.INFO, "Not a valid registered Object Name");
        }
    }

    void unregisterListener(MBeanServerConnection connection, NotificationListener client) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        javax.management.ObjectName objectName = this.getObjectName(connection);
        if (objectName != null) {
            assert (connection != null) : "Connection not available";
            connection.removeNotificationListener(objectName, client);
        } else {
            Utils.log(Level.INFO, "Not a valid registered Object Name");
        }
    }

    void unregisterListener(MBeanServerConnection connection, NotificationListener client, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        javax.management.ObjectName objectName = this.getObjectName(connection);
        if (objectName != null) {
            assert (connection != null) : "Connection not available";
            if (filter != null) {
                connection.removeNotificationListener(objectName, client, filter, handback);
            } else {
                connection.removeNotificationListener(objectName, this, filter, handback);
            }
        } else {
            Utils.log(Level.INFO, "Not a valid registered Object Name");
        }
    }

    protected abstract String getObjectNameString();

    protected void printInfo(MBeanServerNotification notification) {
        System.out.println(" Notification " + notification.toString());
        System.out.println("Sequence Number: " + notification.getSequenceNumber());
        System.out.println("Time Stamp: " + notification.getTimeStamp());
        System.out.println("MBean Name: " + notification.getMBeanName().getCanonicalName());
        System.out.println("Message: " + notification.getMessage());
        System.out.println("Source: " + notification.getSource().toString());
        System.out.println("Type: " + notification.getType());
        System.out.println("UserData: " + notification.getUserData());
    }

    private void updateObjectNameMap(String domain, ObjectName name, javax.management.ObjectName objectName) {
        String template = name.getMonitoringMbeanNameTemplate();
        if (template != null) {
            template = domain + ":" + template;
            Mapping mapping = null;
            String property = null;
            String value = null;
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            for (int i = 0; i < name.sizeMapping(); ++i) {
                mapping = name.getMapping(i);
                value = objectName.getKeyProperty(mapping.getRuntimeMbeanAttributeName());
                property = mapping.getMonitoringMbeanAttributeValue();
                if (value.startsWith("//")) {
                    value = value.substring(value.lastIndexOf(47) + 1);
                }
                keyValueMap.put(property, value);
            }
            try {
                String monitoringMBeanObjectName = ObjectNameHelper.tokenize(template, keyValueMap);
                this.runtimeToMonitoring.put(objectName, monitoringMBeanObjectName);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
    }

    private javax.management.ObjectName getObjectName(Notification notification) {
        javax.management.ObjectName objectName = null;
        if (notification.getClass().getName().equals("javax.management.MBeanServerNotification")) {
            MBeanServerNotification msn = (MBeanServerNotification)notification;
            String canonicalName = msn.getMBeanName().getCanonicalName();
            try {
                objectName = new javax.management.ObjectName(canonicalName);
            }
            catch (MalformedObjectNameException ex) {
                Utils.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return objectName;
    }

    private javax.management.ObjectName getObjectName(MBeanServerConnection connection) {
        String objectNameString = this.getObjectNameString();
        if (objectNameString != null && objectNameString.length() > 0) {
            try {
                javax.management.ObjectName objectName = javax.management.ObjectName.getInstance(objectNameString);
                if (connection != null && connection.isRegistered(new javax.management.ObjectName(objectNameString))) {
                    return objectName;
                }
            }
            catch (Exception ex) {
                Utils.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return null;
    }

    private static Notifications getNotifications() {
        if (notifications == null) {
            InputStream inputStream = Utils.getInputStream(notificationsFile);
            if (inputStream != null) {
                try {
                    notifications = Notifications.read(inputStream);
                }
                catch (Exception e) {
                    Utils.log(Level.WARNING, e.getMessage(), e);
                }
            } else {
                String format = BundleReader.getValue("MSG_Unable_to_use_file");
                Object[] arguments = new Object[]{notificationsFile};
                Utils.log(Level.WARNING, MessageFormat.format(format, arguments));
            }
        }
        return notifications;
    }

    private final class HandleNotificationThread
    extends Thread {
        private final long timeOutSeconds;
        private final int startAfterSeconds;
        private boolean timeOutReached;
        private long startTime;
        private javax.management.ObjectName objectName;
        private String monitoringObjectName;
        private MBeanServerConnection connection;
        NotificationListener client;
        Notification notification;
        Object handback;
        Integer status;

        public HandleNotificationThread(long timeOutSeconds, int startAfterSeconds, javax.management.ObjectName objectName, String monitoringObjectName, MBeanServerConnection connection, NotificationListener client, Notification notification, Object handback) {
            this.timeOutSeconds = timeOutSeconds;
            this.startAfterSeconds = startAfterSeconds;
            this.objectName = objectName;
            this.monitoringObjectName = monitoringObjectName;
            this.connection = connection;
            this.timeOutReached = false;
            this.client = client;
            this.notification = notification;
            this.handback = handback;
        }

        public void run() {
            block11: {
                this.startTime = System.currentTimeMillis();
                try {
                    Thread.currentThread();
                    Thread.sleep(this.startAfterSeconds * 1000);
                    while (!this.timeOutReached() && this.keepWaiting()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            this.computeTimeOut();
                        }
                        catch (InterruptedException ie) {
                            this.timeOutReached = true;
                        }
                    }
                }
                catch (Exception e) {
                    this.timeOutReached = true;
                }
                if (this.status == 1 && this.client != null) {
                    if (this.monitoringObjectName != null) {
                        try {
                            javax.management.ObjectName objectName = javax.management.ObjectName.getInstance(this.monitoringObjectName);
                            if (this.connection == null) break block11;
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            if (this.connection.isRegistered(new javax.management.ObjectName(this.monitoringObjectName))) {
                                this.notification.setUserData(new javax.management.ObjectName(this.monitoringObjectName));
                                this.client.handleNotification(this.notification, this.handback);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        this.client.handleNotification(this.notification, this.handback);
                    }
                }
            }
        }

        private boolean timeOutReached() {
            return this.timeOutReached;
        }

        private void computeTimeOut() {
            long currentTime = System.currentTimeMillis();
            this.timeOutReached = currentTime - this.startTime >= this.timeOutSeconds * 1000L;
        }

        private boolean keepWaiting() {
            boolean returnValue = true;
            this.status = null;
            if (this.objectName != null && this.connection != null) {
                try {
                    this.status = (Integer)this.connection.getAttribute(this.objectName, "state");
                    if (this.status == 1 || this.status == 4) {
                        returnValue = false;
                    }
                }
                catch (Exception ex) {
                    this.status = null;
                    returnValue = false;
                }
            }
            return returnValue;
        }
    }
}

