/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv;

import com.sun.mfwk.agent.appserv.ASServerManager;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class ASServerManagerRegistry {
    private static Map _serverManagers = null;
    private static final ASServerManagerRegistry _instance = new ASServerManagerRegistry();

    public static ASServerManagerRegistry getInstance() {
        return _instance;
    }

    private ASServerManagerRegistry() {
        _serverManagers = new Hashtable();
    }

    public ASServerManager getASServerManager(String serverName, String domainName) throws IOException {
        String instanceName = domainName + serverName;
        ASServerManager serverManager = (ASServerManager)_serverManagers.get(instanceName);
        if (serverManager == null) {
            throw new IllegalArgumentException();
        }
        return serverManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addASServerManager(String moduleName, String serverName, String domainName) throws IOException {
        String instanceName = domainName + serverName;
        LogDomains.getLogger().fine("Setting ASServerManager for server: " + instanceName);
        ASServerManager serverManager = new ASServerManager(moduleName, serverName, domainName);
        ASServerManagerRegistry aSServerManagerRegistry = this;
        synchronized (aSServerManagerRegistry) {
            _serverManagers.put(instanceName, serverManager);
        }
    }

    public synchronized void removeASServerManager(String serverName, String domainName) {
        String instanceName = domainName + serverName;
        LogDomains.getLogger().fine("Removing ASServerManager for server: " + instanceName);
        _serverManagers.remove(instanceName);
    }
}

