/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.bean.ArchiveBean;
import com.sun.jbi.jsf.bean.DeletionBean;
import com.sun.jbi.jsf.bean.InstallationBean;
import com.sun.jbi.jsf.bean.JBIComponentConfigBean;
import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jbi.jsf.bean.LoggingBean;
import com.sun.jbi.jsf.bean.OperationBean;
import com.sun.jbi.jsf.bean.RuntimeConfigurationBean;
import com.sun.jbi.jsf.bean.ServiceUnitBean;
import com.sun.jbi.jsf.bean.ShowBean;
import com.sun.jbi.jsf.bean.TargetBean;
import com.sun.jbi.jsf.bean.UploadCopyRadioBean;
import com.sun.jbi.jsf.configuration.beans.ConfigurationBean;
import com.sun.jbi.jsf.util.ConnectionUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public final class BeanUtilities {
    private static Logger sLog = JBILogger.getInstance();
    private static JBIAdminCommands sClient;

    public static void initBeans() {
        String BEAN_NAME = "JBIConfigBean";
        String CLASS_NAME = "com.sun.jbi.jsf.bean.JBIConfigBean";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object alreadyRegisteredBean = facesContext.getExternalContext().getSessionMap().get("JBIConfigBean");
        if (null == alreadyRegisteredBean) {
            try {
                Class<?> beanClass = Class.forName("com.sun.jbi.jsf.bean.JBIConfigBean");
                Object bean = beanClass.newInstance();
                facesContext.getExternalContext().getSessionMap().put("JBIConfigBean", bean);
                sLog.fine("BeanUtilities.initBeans() BEAN_NAME=JBIConfigBean, beanClass=" + beanClass + ", bean=" + bean);
            }
            catch (Exception ex) {
                sLog.log(Level.FINE, "BeanUtilities.initBeans() caught Exception", ex);
            }
        }
    }

    public static AlertBean getAlertBean() {
        BeanUtilities.initBeans();
        AlertBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{AlertBean}", AlertBean.class);
        result = (AlertBean)ve.getValue(elCtx);
        return result;
    }

    public static DeletionBean getDeletionBean() {
        DeletionBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{DeletionBean}", DeletionBean.class);
        result = (DeletionBean)ve.getValue(elCtx);
        return result;
    }

    public static InstallationBean getInstallationBean() {
        InstallationBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{InstallationBean}", InstallationBean.class);
        result = (InstallationBean)ve.getValue(elCtx);
        return result;
    }

    public static OperationBean getOperationBean() {
        OperationBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{OperationBean}", OperationBean.class);
        result = (OperationBean)ve.getValue(elCtx);
        return result;
    }

    public static UploadCopyRadioBean getUploadCopyRadioBean() {
        UploadCopyRadioBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{UploadCopyRadioBean}", UploadCopyRadioBean.class);
        result = (UploadCopyRadioBean)ve.getValue(elCtx);
        return result;
    }

    public static ArchiveBean getArchiveBean() {
        ArchiveBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{ArchiveBean}", ArchiveBean.class);
        result = (ArchiveBean)ve.getValue(elCtx);
        return result;
    }

    public static LoggingBean getLoggingBean() {
        LoggingBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{LoggingBean}", LoggingBean.class);
        result = (LoggingBean)ve.getValue(elCtx);
        return result;
    }

    public static ConfigurationBean getConfigurationBean() {
        ConfigurationBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{ConfigurationBean}", ConfigurationBean.class);
        result = (ConfigurationBean)ve.getValue(elCtx);
        return result;
    }

    public static RuntimeConfigurationBean getRuntimeConfigurationBean() {
        RuntimeConfigurationBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{RuntimeConfigurationBean}", RuntimeConfigurationBean.class);
        result = (RuntimeConfigurationBean)ve.getValue(elCtx);
        return result;
    }

    public static ListBean getListBean() {
        BeanUtilities.initBeans();
        ListBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{ListBean}", ListBean.class);
        result = (ListBean)ve.getValue(elCtx);
        return result;
    }

    public static ServiceUnitBean getServiceUnitBean() {
        ServiceUnitBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{ServiceUnitBean}", ServiceUnitBean.class);
        result = (ServiceUnitBean)ve.getValue(elCtx);
        return result;
    }

    public static ShowBean getShowBean() {
        ShowBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{ShowBean}", ShowBean.class);
        result = (ShowBean)ve.getValue(elCtx);
        return result;
    }

    public static TargetBean getTargetBean() {
        TargetBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{TargetBean}", TargetBean.class);
        result = (TargetBean)ve.getValue(elCtx);
        sLog.fine("BeanUtitlies.getTargetBean() result=" + result);
        return result;
    }

    public static JBIAdminCommands getClient() {
        JBIAdminCommands result = null;
        if (null == sClient) {
            sClient = new ConnectionUtilities().getClient();
        }
        result = sClient;
        sLog.fine("BeanUtitlies.getClient() result=" + result);
        return result;
    }

    public static String getComponentType(String aComponentName, String aTargetName) {
        String componentType = "";
        String result = "";
        try {
            JBIAdminCommands mJac = BeanUtilities.getClient();
            componentType = "binding-component";
            result = mJac.showBindingComponent(aComponentName, "", "", "", aTargetName);
            List list = JBIComponentInfo.readFromXmlText((String)result);
            if (list.size() == 0) {
                componentType = "service-engine";
                result = mJac.showServiceEngine(aComponentName, "", "", "", aTargetName);
                list = JBIComponentInfo.readFromXmlText((String)result);
                if (list.size() == 0) {
                    componentType = "";
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return componentType;
    }

    public static String getStringPropertyUsingExpression(String anExpression) {
        String result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, anExpression, String.class);
        result = (String)ve.getValue(elCtx);
        return result;
    }

    public static void setStringPropertyUsingExpression(String aStringValue, String anExpression) {
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, anExpression, String.class);
        ve.setValue(elCtx, (Object)aStringValue);
    }

    public static boolean checkFilterOptions(String aComponentState, String aFilterState, ArrayList optionList) {
        boolean flag = true;
        if (null != aFilterState && !"Show All".equals(aFilterState)) {
            int index;
            flag = false;
            if (null != optionList && (index = optionList.indexOf(aFilterState)) != -1) {
                flag = BeanUtilities.containsIgnoreCase(aComponentState, (String)optionList.get(index));
            }
        }
        return flag;
    }

    public static JBIManagementMessage extractJBIManagementMessage(Exception ex) {
        JBIManagementMessage mgmtMsg = null;
        if (ex instanceof JBIRemoteException) {
            JBIRemoteException rEx = (JBIRemoteException)((Object)ex);
            mgmtMsg = rEx.extractJBIManagementMessage();
            sLog.fine("BeanUtitlies.extractJBIManagementMessage(...), rEx.getClass()=" + ((Object)((Object)rEx)).getClass() + ", mgmtMsg=" + mgmtMsg);
        }
        if (null == mgmtMsg) {
            String exMessage = ex.getMessage();
            sLog.fine("BeanUtitlies.extractJBIManagementMessage(...), ex.getClass()=" + ex.getClass() + ", exMessage=" + exMessage);
            if (null == exMessage) {
                exMessage = ex.toString();
                sLog.fine("BeanUtitlies.extractJBIManagementMessage(...), ex.getClass()=" + ex.getClass() + ", exMessage=" + exMessage);
            }
            mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)exMessage);
        }
        sLog.fine("BeanUtitlies.extractJBIManagementMessage(...), ex.getClass()=" + ex.getClass() + ", mgmtMsg=" + mgmtMsg);
        return mgmtMsg;
    }

    public static JBIManagementMessage extractJBIManagementMessage(String jbiResultXml) {
        JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        sLog.fine("BeanUtilities.extractJBIManagementMessage(String jbiResultXml), mgmtMsg=" + mgmtMsg);
        if (mgmtMsg != null) {
            String formattedJbiResult = jbiResultXml;
            if (!mgmtMsg.isFailedMsg()) {
                sLog.fine("BeanUtilities.extractJBIManagementMessage(String jbiResultXml), happy: isFailedMsg()=false");
            } else {
                sLog.fine("BeanUtilities.extractJBIManagementMessage(String jbiResultXml), error: isFailedMsg()=true");
            }
        }
        return mgmtMsg;
    }

    public static String addAlertFooterMessage(String aAlertMsg) {
        String footerMsg = I18nUtilities.getResourceString("jbi.alert.footer.see.log.message");
        aAlertMsg = aAlertMsg + "<br>" + footerMsg;
        return aAlertMsg;
    }

    private static boolean containsIgnoreCase(String str1, String str2) {
        String str1Upper = str1.toUpperCase();
        String str2Upper = str2.toUpperCase();
        return str1Upper.contains(str2Upper);
    }

    public static JBIComponentConfigBean getJBIComponentConfigBean() {
        JBIComponentConfigBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, "#{JBIComponentConfigBean}", JBIComponentConfigBean.class);
        result = (JBIComponentConfigBean)ve.getValue(elCtx);
        return result;
    }

    static {
        sLog.fine("BeanUtilities.<clinit>()");
        BeanUtilities.initBeans();
        sClient = null;
    }
}

