/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jbi.jsf.bean.OperationBean;
import com.sun.jbi.jsf.bean.ShowBean;
import com.sun.jbi.jsf.configuration.beans.ConfigurationBean;
import com.sun.jbi.jsf.util.AlertUtilities;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.ClusterUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.SystemLoggerUtilities;
import com.sun.jbi.jsf.util.TableUtilities;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.component.TextField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class OperationHandlers {
    private static Logger sLog = JBILogger.getInstance();
    private static String BREAK = "<br />";
    private static String NEWLINE = "\r";

    public static void jbiSetEnablementForSelectectedRows(HandlerContext handlerCtx) {
        String alertType = "";
        String alertDetails = "";
        String alertSummary = "";
        String internalError = "";
        String successResult = "";
        String failureResult = "";
        String warningResult = "";
        int countSuccessfulOperations = 0;
        int countFailedOperations = 0;
        int countWarningOperations = 0;
        boolean warningFlag = false;
        boolean failureFlag = false;
        boolean internalErrorFlag = false;
        boolean isAlertNeeded = false;
        Properties rowProperties2 = new Properties();
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String tableType = (String)handlerCtx.getInputValue("tableType");
        Boolean isEnabled = (Boolean)handlerCtx.getInputValue("isEnabled");
        sLog.fine("OperationHandlers.jbiSetEnablementForSelectedRows(...), tableType=" + tableType + ", isEnabled=" + isEnabled);
        List componentOrDeploymentRows = OperationHandlers.getSelectedComponentOrDeploymentRowProperties(trg);
        for (Properties rowProperties2 : componentOrDeploymentRows) {
            sLog.fine("OperationHandlers.jbiSetEnablementForSelectedRows(...), rowProperties=" + rowProperties2);
            String rowName = rowProperties2.getProperty("name");
            String rowType = rowProperties2.getProperty("type");
            List targets = ClusterUtilities.findTargetsForNameByType(rowName, rowType);
            sLog.fine("OperationHandlers.jbiSetEnablementForSelectedRows(...), rowName=" + rowName + ", targets=" + targets);
            if (targets.size() == 0) {
                String typeText = "";
                typeText = "bindingsEngines".equals(tableType) ? I18nUtilities.getResourceString("jbi.failed.no.target.component") : I18nUtilities.getResourceString("jbi.failed.no.target.deployment");
                failureFlag = true;
                ++countFailedOperations;
                Object[] args = new Object[]{typeText, rowName};
                failureResult = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.failed.no.target"), (Object[])args);
                alertDetails = alertDetails + failureResult + BREAK;
                continue;
            }
            rowProperties2 = isEnabled != false ? OperationHandlers.start(rowProperties2, targets) : OperationHandlers.shutDown(rowProperties2, targets);
            successResult = rowProperties2.getProperty("success-result");
            internalError = rowProperties2.getProperty("internal-error");
            warningResult = rowProperties2.getProperty("warning-result");
            if (null != internalError) {
                internalErrorFlag = true;
                break;
            }
            if (null != successResult) {
                ++countSuccessfulOperations;
            } else {
                failureFlag = true;
                ++countFailedOperations;
                failureResult = rowProperties2.getProperty("failure-result");
                alertDetails = alertDetails + failureResult + BREAK;
            }
            if (null == warningResult) continue;
            warningFlag = true;
            ++countWarningOperations;
            warningResult = rowProperties2.getProperty("warning-result");
            alertDetails = alertDetails + warningResult + BREAK;
        }
        if (failureFlag || internalErrorFlag) {
            isAlertNeeded = true;
            alertSummary = isEnabled.booleanValue() ? ("bindingsEngines".equalsIgnoreCase(tableType) ? I18nUtilities.getResourceString("jbi.enable.component.error.summary") : I18nUtilities.getResourceString("jbi.enable.deployment.error.summary")) : ("bindingsEngines".equalsIgnoreCase(tableType) ? I18nUtilities.getResourceString("jbi.disable.component.error.summary") : I18nUtilities.getResourceString("jbi.disable.deployment.error.summary"));
            alertType = "error";
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        } else if (warningFlag) {
            isAlertNeeded = true;
            alertType = "warning";
            alertSummary = rowProperties2.getProperty("warning-summary");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        }
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        sLog.fine("OperationHandlers.jbiSetEnablementForSelectedRows(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
    }

    public static void jbiOperateSelectedComponentOrDeploymentRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String tableType = (String)handlerCtx.getInputValue("tableType");
        String operation = (String)handlerCtx.getInputValue("operation");
        sLog.fine("OperationHandlers.jbiOperateSelectedRows(...) trg=" + trg + ", tableType=" + tableType + ", operation=" + operation);
        ArrayList<Properties> targets = new ArrayList<Properties>();
        Properties targetProperties = new Properties();
        targetProperties.setProperty("name", "server");
        targets.add(targetProperties);
        List componentOrDeploymentRows = OperationHandlers.getSelectedComponentOrDeploymentRowProperties(trg);
        Iterator rowIt = componentOrDeploymentRows.iterator();
        int countFailedOperations = 0;
        int countSuccessfulOperations = 0;
        String alertDetails = "";
        while (rowIt.hasNext()) {
            Properties rowProperties = (Properties)rowIt.next();
            if ("Start".equals(operation)) {
                rowProperties = OperationHandlers.start(rowProperties, targets);
            } else if ("Stop".equals(operation)) {
                rowProperties = OperationHandlers.stop(rowProperties, targets);
            } else if ("Shut Down".equals(operation)) {
                rowProperties = OperationHandlers.shutDown(rowProperties, targets);
            } else {
                String error = "internal error detected in OperationHandlers.jbiOperateSelectedRows, invalud operation=" + operation;
                sLog.fine("OperationHandlers.jbiOperateSelectedRows(...) error=" + error);
                rowProperties.setProperty("failure-result", error);
            }
            String failureResult = rowProperties.getProperty("failure-result");
            String successResult = rowProperties.getProperty("success-result");
            if (null == failureResult && null != successResult) {
                sLog.fine("OperationHandlers.jbiOperateSelectedRows(...),  success for rowProperties=" + rowProperties + ", countFailedOperations=" + countFailedOperations + ", countSuccessfulOperations=" + ++countSuccessfulOperations);
                String exceptionMessage = AlertUtilities.getMessage(successResult);
                if (!"".equals(exceptionMessage)) {
                    failureResult = successResult;
                }
            }
            if (null == failureResult) continue;
            sLog.fine("OperationHandlers.jbiOperateSelectedRows(...),  failure for rowProperties=" + rowProperties + ", countFailedOperations=" + ++countFailedOperations + ", countSuccessfulOperations=" + countSuccessfulOperations);
            String name = rowProperties.getProperty("name");
            String details = "";
            String exceptionMessage = AlertUtilities.getMessage(failureResult);
            details = "".equals(exceptionMessage) ? failureResult : exceptionMessage;
            Object[] args = new Object[]{name, operation, details};
            String alertDet = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.operation.failed"), (Object[])args);
            alertDetails = alertDetails + alertDet + BREAK;
        }
        String alertSummary = "";
        if (0 < countFailedOperations) {
            alertSummary = 0 < countSuccessfulOperations ? (1 == countFailedOperations ? I18nUtilities.getResourceString("jbi.operations.one.failed.alert.summary.text") : I18nUtilities.getResourceString("jbi.operations.some.failed.alert.summary.text")) : I18nUtilities.getResourceString("jbi.operations.all.failed.alert.summary.text");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        }
        boolean isAlertNeeded = 0 < countFailedOperations;
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("OperationHandlers.jbiOperateSelectedComponentOrDeploymentRows(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
    }

    public static void jbiOperateSelectedSingleTargetRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        String operation = (String)handlerCtx.getInputValue("operation");
        String componentOrDeploymentType = (String)handlerCtx.getInputValue("componentOrDeploymentType");
        sLog.fine("OperationHandlers.jbiOperateSelectedSingleTargetRows(...), trg=" + trg + ", targetName=" + targetName + ", operation=" + operation + ", componentOrDeploymentType=" + componentOrDeploymentType);
        List targetRows = TableUtilities.getSelectedRowProperties(trg);
        boolean failureFlag = false;
        boolean isAlertNeeded = false;
        String alertSummary = "";
        String alertDetails = "";
        String successResult = "";
        String failureResult = "";
        int countSuccessfulOperations = 0;
        int countFailedOperations = 0;
        if (0 < targetRows.size()) {
            Properties singleTargetProperties = new Properties();
            singleTargetProperties.setProperty("name", targetName);
            ArrayList<Properties> singleTargetList = new ArrayList<Properties>();
            singleTargetList.add(singleTargetProperties);
            for (Properties compOrSaRow : targetRows) {
                if ("Start".equals(operation)) {
                    compOrSaRow = OperationHandlers.start(compOrSaRow, singleTargetList);
                } else if ("Shut Down".equals(operation)) {
                    compOrSaRow = OperationHandlers.shutDown(compOrSaRow, singleTargetList);
                } else {
                    sLog.fine("OperationHandlers.jbiOperateSelectedRows invalid operation=" + operation + " ignored");
                }
                successResult = compOrSaRow.getProperty("success-result");
                if (null != successResult) {
                    ++countSuccessfulOperations;
                } else {
                    failureFlag = true;
                    ++countFailedOperations;
                    failureResult = compOrSaRow.getProperty("failure-result");
                    alertDetails = alertDetails + failureResult + BREAK;
                }
                if (failureFlag) {
                    isAlertNeeded = true;
                    alertSummary = "bindingsEngines".equalsIgnoreCase(componentOrDeploymentType) ? I18nUtilities.getResourceString("jbi.operation.component.error.summary") : I18nUtilities.getResourceString("jbi.operation.deployment.error.summary");
                    alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
                }
                String alertType = "warning";
                AlertBean alertBean = BeanUtilities.getAlertBean();
                alertBean.setAlertType(alertType);
            }
        } else {
            sLog.fine("OperationHandlers.jbiOperateSelectedRows nothing selected");
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("OperationHandlers.jbiOperateSelectedSingleTargetRows(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
    }

    public static void jbiOperateSelectedTargetRows(HandlerContext handlerCtx) {
        String alertType = "";
        String alertDetails = "";
        String alertSummary = "";
        String successResult = "";
        String failureResult = "";
        String warningResult = "";
        int countSuccessfulOperations = 0;
        int countFailedOperations = 0;
        int countWarningOperations = 0;
        boolean warningFlag = false;
        boolean failureFlag = false;
        boolean isAlertNeeded = false;
        Properties rowProperties = new Properties();
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String componentOrDeploymentType = (String)handlerCtx.getInputValue("componentOrDeploymentType");
        String componentOrDeploymentName = (String)handlerCtx.getInputValue("componentOrDeploymentName");
        String operation = (String)handlerCtx.getInputValue("operation");
        sLog.fine("OperationHandlers.jbiOperateSelectedTargetRows(...), trg=" + trg + ", componentOrDeploymentType=" + componentOrDeploymentType + ", componentOrDeploymentName=" + componentOrDeploymentName + ", operation=" + operation);
        List targetRows = OperationHandlers.getSelectedTargetRowProperties(trg);
        if (0 < targetRows.size()) {
            rowProperties.setProperty("type", componentOrDeploymentType);
            rowProperties.setProperty("name", componentOrDeploymentName);
            if ("Start".equals(operation)) {
                rowProperties = OperationHandlers.start(rowProperties, targetRows);
            } else if ("Stop".equals(operation)) {
                rowProperties = OperationHandlers.stop(rowProperties, targetRows);
            } else if ("Shut Down".equals(operation)) {
                rowProperties = OperationHandlers.shutDown(rowProperties, targetRows);
            } else {
                sLog.fine("OperationHandlers.jbiOperateSelectedRows invalid operation=" + operation + " ignored");
            }
            successResult = rowProperties.getProperty("success-result");
            warningResult = rowProperties.getProperty("warning-result");
            if (null != successResult) {
                ++countSuccessfulOperations;
            } else {
                failureFlag = true;
                ++countFailedOperations;
                failureResult = rowProperties.getProperty("failure-result");
                alertDetails = alertDetails + failureResult + BREAK;
            }
            if (null != warningResult) {
                warningFlag = true;
                ++countWarningOperations;
                warningResult = rowProperties.getProperty("warning-result");
                alertDetails = alertDetails + warningResult + BREAK;
            }
        } else {
            sLog.fine("OperationHandlers.jbiOperateSelectedRows nothing selected");
        }
        if (failureFlag) {
            isAlertNeeded = true;
            alertSummary = "bindingsEngines".equalsIgnoreCase(componentOrDeploymentType) ? I18nUtilities.getResourceString("jbi.operation.component.error.summary") : I18nUtilities.getResourceString("jbi.operation.deployment.error.summary");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        } else if (warningFlag) {
            isAlertNeeded = true;
            alertType = "warning";
            alertSummary = rowProperties.getProperty("warning-summary");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        }
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        sLog.fine("OperationHandlers.jbiOperateSelectedTargetRows(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
    }

    public static void filterTableType(HandlerContext handlerCtx) {
        String operation = (String)handlerCtx.getInputValue("operation");
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setFilterType(operation);
    }

    public static void jbiFilterTableComponentState(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String values = (String)handlerCtx.getInputValue("values");
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setFilterComponentState(value, values);
    }

    public static void jbiFilterTableAssemblyState(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String values = (String)handlerCtx.getInputValue("values");
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setFilterAssemblyState(value, values);
    }

    public static void jbiFilterTargetTableComponentState(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String values = (String)handlerCtx.getInputValue("values");
        ShowBean showBean = BeanUtilities.getShowBean();
        showBean.setFilterTargetComponentState(value, values);
    }

    public static void jbiFilterTargetTableAssemblyState(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String values = (String)handlerCtx.getInputValue("values");
        ShowBean showBean = BeanUtilities.getShowBean();
        showBean.setFilterTargetAssemblyState(value, values);
    }

    public static void jbiSaveComponentLogLevels(HandlerContext handlerCtx) {
        String propertySheetParentId = (String)handlerCtx.getInputValue("propertySheetParentId");
        String propertySheetId = (String)handlerCtx.getInputValue("propertySheetId");
        String propertySheetSectionIdTag = (String)handlerCtx.getInputValue("propertySheetSectionIdTag");
        String propertyIdTag = (String)handlerCtx.getInputValue("propertyIdTag");
        String dropDownIdTag = (String)handlerCtx.getInputValue("dropDownIdTag");
        String hiddenFieldIdTag = (String)handlerCtx.getInputValue("hiddenFieldIdTag");
        String componentName = (String)handlerCtx.getInputValue("componentName");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String alertType = "";
        String alertDetails = "";
        String alertSummary = "";
        boolean isAlertNeeded = true;
        Properties result = OperationHandlers.jbiSetComponentLogLevels(propertySheetParentId, propertySheetId, propertySheetSectionIdTag, propertyIdTag, dropDownIdTag, hiddenFieldIdTag, componentName, targetName, instanceName, handlerCtx);
        String failureResult = result.getProperty("failure-result");
        if (null != failureResult && failureResult.length() > 0) {
            alertType = "error";
            alertSummary = I18nUtilities.getResourceString("jbi.configure.loggers.failure.summary.message");
            alertDetails = failureResult;
        } else {
            alertType = "success";
            alertSummary = I18nUtilities.getResourceString("jbi.configure.loggers.success.summary.message");
            alertDetails = "";
        }
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        handlerCtx.setOutputValue("isAlertNeeded", (Object)isAlertNeeded);
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
    }

    public static void jbiSaveInstancesLogLevels(HandlerContext handlerCtx) {
        String propertySheetParentId = (String)handlerCtx.getInputValue("propertySheetParentId");
        String propertySheetId = (String)handlerCtx.getInputValue("propertySheetId");
        String propertySheetSectionIdTag = (String)handlerCtx.getInputValue("propertySheetSectionIdTag");
        String propertyIdTag = (String)handlerCtx.getInputValue("propertyIdTag");
        String dropDownIdTag = (String)handlerCtx.getInputValue("dropDownIdTag");
        String hiddenFieldIdTag = (String)handlerCtx.getInputValue("hiddenFieldIdTag");
        String componentName = (String)handlerCtx.getInputValue("componentName");
        String[] instanceNames = (String[])handlerCtx.getInputValue("instanceNames");
        String[] targetNames = (String[])handlerCtx.getInputValue("targetNames");
        String alertType = "";
        String alertSummary = "";
        String alertDetails = "";
        String failureResult = "";
        String failureResultDetails = "";
        boolean countSuccessfulOperations = false;
        int countFailedOperations = 0;
        boolean failureFlag = false;
        boolean isAlertNeeded = true;
        for (int i = 0; i < instanceNames.length; ++i) {
            Properties result = OperationHandlers.jbiSetComponentLogLevels(propertySheetParentId, propertySheetId, propertySheetSectionIdTag, propertyIdTag, dropDownIdTag, hiddenFieldIdTag, componentName, targetNames[i], instanceNames[i], handlerCtx);
            failureResult = result.getProperty("failure-result");
            if (null == failureResult || failureResult.length() <= 0) continue;
            failureFlag = true;
            ++countFailedOperations;
            failureResultDetails = failureResultDetails + failureResult + BREAK;
        }
        if (failureFlag) {
            alertType = "error";
            alertSummary = I18nUtilities.getResourceString("jbi.configure.loggers.failure.summary.message");
            alertDetails = failureResultDetails;
        } else {
            alertType = "success";
            alertSummary = I18nUtilities.getResourceString("jbi.configure.loggers.success.summary.message");
            alertDetails = "";
        }
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        handlerCtx.setOutputValue("isAlertNeeded", (Object)isAlertNeeded);
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setUpdateInstancesList(instanceNames);
    }

    public static void jbiInitUpdateList(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("instanceName");
        String[] values = new String[]{value};
        ListBean listBean = BeanUtilities.getListBean();
        listBean.setUpdateInstancesList(values);
    }

    public static void jbiSetRuntimeConfigurationParameters(HandlerContext handlerCtx) {
        String alertType = "";
        String alertSummary = "";
        String alertDetails = "";
        String target = (String)handlerCtx.getInputValue("target");
        String heartBeatInterval = (String)handlerCtx.getInputValue("heartBeatInterval");
        String autoInstallEnabled = (String)handlerCtx.getInputValue("autoInstallEnabled");
        String startOnDeploy = (String)handlerCtx.getInputValue("startOnDeploy");
        String installationTimeout = (String)handlerCtx.getInputValue("installationTimeout");
        String componentTimeout = (String)handlerCtx.getInputValue("componentTimeout");
        String serviceUnitTimeout = (String)handlerCtx.getInputValue("serviceUnitTimeout");
        Properties configurationProperties = new Properties();
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "heartBeatInterval", heartBeatInterval);
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "autoInstallEnabled", autoInstallEnabled.toString());
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "startOnDeploy", startOnDeploy.toString());
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "installationTimeout", installationTimeout);
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "componentTimeout", componentTimeout);
        configurationProperties = OperationHandlers.setPropertyIfNotNull(configurationProperties, "serviceUnitTimeout", serviceUnitTimeout);
        Properties changedConfigurationProperties = OperationHandlers.findChangedRuntimeConfigurationProperties(target, configurationProperties);
        JBIAdminCommands mJac = BeanUtilities.getClient();
        try {
            boolean restartRequired = mJac.setRuntimeConfiguration(changedConfigurationProperties, target);
            sLog.fine("OperationHandlers.jbiSetRuntimeConfigurationParameters changedConfigurationProperties=" + changedConfigurationProperties + ", target=" + target + ", restartRequired=" + restartRequired);
            if (null != configurationProperties) {
                for (Object object : configurationProperties.keySet()) {
                    String k = (String)object;
                    String v = configurationProperties.getProperty(k);
                    sLog.fine("OperationHandlers.jbiSetRuntimeConfigurationParameters k=" + k + ", v=" + v);
                }
            }
            if (restartRequired) {
                alertType = "info";
                alertSummary = I18nUtilities.getResourceString("jbi.root.configuration.restart.required.summary");
                if (target.equalsIgnoreCase("domain")) {
                    alertDetails = I18nUtilities.getResourceString("jbi.root.configuration.restart.required.all.targets.details");
                } else {
                    Object[] args = new Object[]{target};
                    alertDetails = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.root.configuration.restart.required.a.target.details"), (Object[])args);
                }
            } else {
                alertType = "success";
                alertSummary = I18nUtilities.getResourceString("jbi.configure.loggers.success.summary.message");
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            JBIManagementMessage mgmtMsg = null;
            mgmtMsg = BeanUtilities.extractJBIManagementMessage((Exception)((Object)jbiRemoteEx));
            alertType = "error";
            alertSummary = I18nUtilities.getResourceString("jbi.configure.runtime.alert.summary ");
            alertDetails = mgmtMsg.getMessage();
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        }
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        alertBean.setAlertSummary(alertSummary);
        alertBean.setAlertDetail(alertDetails);
        sLog.fine("OperationHandler.jbiSetRuntimeConfigurationParameters, alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
    }

    public static void jbiGetRuntimeConfigurationParameters(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        Properties properties = OperationHandlers.getCurrentRuntimeConfigurationProperties(target);
        String jbiHome = properties.getProperty("jbiHome");
        sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters(" + target + ") target jbiHome=" + jbiHome);
        if (null == jbiHome || "".equals(jbiHome)) {
            JBIAdminCommands mJac = BeanUtilities.getClient();
            try {
                Properties defaultProperties = null;
                if (target.equalsIgnoreCase("domain")) {
                    defaultProperties = mJac.getDefaultRuntimeConfiguration();
                    jbiHome = defaultProperties.getProperty("jbiHome");
                    sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters(" + target + ") factory-default jbiHome=" + jbiHome);
                } else {
                    defaultProperties = mJac.getRuntimeConfiguration("domain");
                    jbiHome = defaultProperties.getProperty("jbiHome");
                    sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters(" + target + ") domain-default jbiHome=" + jbiHome);
                }
            }
            catch (JBIRemoteException jbiRemoteEx) {
                jbiRemoteEx.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("heartBeatInterval", (Object)properties.getProperty("heartBeatInterval"));
        handlerCtx.setOutputValue("jbiHome", (Object)properties.getProperty("jbiHome"));
        handlerCtx.setOutputValue("autoInstallEnabled", (Object)properties.getProperty("autoInstallEnabled"));
        handlerCtx.setOutputValue("autoInstallDir", (Object)properties.getProperty("autoInstallDir"));
        handlerCtx.setOutputValue("startOnDeploy", (Object)properties.getProperty("startOnDeploy"));
        handlerCtx.setOutputValue("installationTimeout", (Object)properties.getProperty("installationTimeout"));
        handlerCtx.setOutputValue("componentTimeout", (Object)properties.getProperty("componentTimeout"));
        handlerCtx.setOutputValue("serviceUnitTimeout", (Object)properties.getProperty("serviceUnitTimeout"));
    }

    public static void jbiGetRuntimeConfigurationDefaultParameters(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        JBIAdminCommands mJac = BeanUtilities.getClient();
        try {
            Properties properties = null;
            properties = target.equalsIgnoreCase("domain") ? mJac.getDefaultRuntimeConfiguration() : mJac.getRuntimeConfiguration("domain");
            handlerCtx.setOutputValue("heartBeatInterval", (Object)properties.getProperty("heartBeatInterval"));
            handlerCtx.setOutputValue("jbiHome", (Object)properties.getProperty("jbiHome"));
            handlerCtx.setOutputValue("autoInstallEnabled", (Object)properties.getProperty("autoInstallEnabled"));
            handlerCtx.setOutputValue("autoInstallDir", (Object)properties.getProperty("autoInstallDir"));
            handlerCtx.setOutputValue("startOnDeploy", (Object)properties.getProperty("startOnDeploy"));
            handlerCtx.setOutputValue("installationTimeout", (Object)properties.getProperty("installationTimeout"));
            handlerCtx.setOutputValue("componentTimeout", (Object)properties.getProperty("componentTimeout"));
            handlerCtx.setOutputValue("serviceUnitTimeout", (Object)properties.getProperty("serviceUnitTimeout"));
        }
        catch (JBIRemoteException jbiRemoteEx) {
            jbiRemoteEx.printStackTrace();
        }
    }

    public static void jbiSetComponentConfigurationParameter(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        String value = (String)handlerCtx.getInputValue("value");
        ConfigurationBean configurationBean = BeanUtilities.getConfigurationBean();
        configurationBean.setParameterValue(key, value);
    }

    public static void jbiGetInstalledComponentCount(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        int totalCount = 0;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        String result = "";
        try {
            result = mJac.listBindingComponents(null, null, null, target);
            List list = JBIComponentInfo.readFromXmlText((String)result);
            totalCount = list.size();
            result = mJac.listServiceEngines(null, null, null, target);
            list = JBIComponentInfo.readFromXmlText((String)result);
            totalCount += list.size();
        }
        catch (JBIRemoteException jbiRemoteEx) {
            // empty catch block
        }
        handlerCtx.setOutputValue("totalCount", (Object)totalCount);
    }

    public static void jbiGetInstalledBindingCount(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        int totalCount = 0;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        String result = "";
        try {
            result = mJac.listBindingComponents(null, null, null, target);
            List list = JBIComponentInfo.readFromXmlText((String)result);
            totalCount = list.size();
        }
        catch (JBIRemoteException jbiRemoteEx) {
            // empty catch block
        }
        handlerCtx.setOutputValue("totalCount", (Object)totalCount);
    }

    public static void jbiGetInstalledEngineCount(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        int totalCount = 0;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        String result = "";
        try {
            result = mJac.listServiceEngines(null, null, null, target);
            List list = JBIComponentInfo.readFromXmlText((String)result);
            totalCount = list.size();
        }
        catch (JBIRemoteException jbiRemoteEx) {
            // empty catch block
        }
        handlerCtx.setOutputValue("totalCount", (Object)totalCount);
    }

    public static void jbiGetInstalledSharedLibraryCount(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        int totalCount = 0;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        String result = "";
        try {
            result = mJac.listSharedLibraries(null, target);
            List list = JBIComponentInfo.readFromXmlText((String)result);
            totalCount = list.size();
        }
        catch (JBIRemoteException jbiRemoteEx) {
            // empty catch block
        }
        handlerCtx.setOutputValue("totalCount", (Object)totalCount);
    }

    public static void jbiGetDeployedServiceAssemblyCount(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        int totalCount = 0;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        String result = "";
        try {
            result = mJac.listServiceAssemblies(null, null, target);
            List list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)result);
            totalCount = list.size();
        }
        catch (JBIRemoteException jbiRemoteEx) {
            // empty catch block
        }
        handlerCtx.setOutputValue("totalCount", (Object)totalCount);
    }

    public static void jbiGetSystemProperty(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        Properties pr = System.getProperties();
        String value = pr.getProperty(key);
        String newValue = "";
        for (int i = 0; i < value.length(); ++i) {
            newValue = value.charAt(i) == '\\' ? newValue + "/" : newValue + value.charAt(i);
        }
        handlerCtx.setOutputValue("value", (Object)newValue);
    }

    public static void jbiPresetValidationAlert(HandlerContext handlerCtx) {
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType("error");
        alertBean.setAlertSummary("Validation of required fields failed.");
        alertBean.setAlertDetail("");
        sLog.fine("OperationHandlers.jbiPresetValidationAlert(), alert type=" + alertBean.getAlertType() + ", alertSummary=" + alertBean.getAlertSummary() + ", alertDetail=" + alertBean.getAlertDetail());
    }

    public static void jbiSetFieldValidator(HandlerContext handlerCtx) {
        TextField textField = (TextField)handlerCtx.getInputValue("textField");
        String propertyName = (String)handlerCtx.getInputValue("propertyName");
        String label = (String)handlerCtx.getInputValue("label");
        sLog.fine("OperationHandlers.jbiSetFieldValidator textField=" + textField + ", propertyName=" + propertyName + ", label=" + label);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String textFieldId = textField.getClientId(facesContext);
        Map sessionMap = (Map)facesContext.getApplication().createValueBinding("#{sessionScope}").getValue(facesContext);
        sLog.finer("OperationHandlers.jbiSetFieldValidator before sessionMap=" + sessionMap);
        sessionMap.put(textFieldId, propertyName);
        sLog.fine("OperationHandlers.jbiSetFieldValidator updated mapping of textFieldId=" + textFieldId + " to propertyName=" + propertyName);
        Properties alertPropertyLabels = (Properties)sessionMap.get("jbiAlertPropertyLabels");
        if (null == alertPropertyLabels) {
            alertPropertyLabels = new Properties();
        }
        alertPropertyLabels.put(propertyName, label);
        sessionMap.put("jbiAlertPropertyLabels", alertPropertyLabels);
        ELContext elcontext = facesContext.getELContext();
        MethodExpression methodExpression = facesContext.getApplication().getExpressionFactory().createMethodExpression(elcontext, "#{OperationBean.validateField}", null, new Class[]{FacesContext.class, UIComponent.class, Object.class});
        textField.setValidatorExpression(methodExpression);
        sLog.fine("OperationHandlers.jbiSetFieldValidator validatorExpression=" + methodExpression);
        Properties alertDetailProperties = (Properties)sessionMap.get("jbiAlertDetailProperties");
        if (null == alertDetailProperties) {
            alertDetailProperties = new Properties();
        }
        alertDetailProperties.put(propertyName, "");
        sessionMap.put("jbiAlertDetailProperties", alertDetailProperties);
        sLog.finer("OperationHandlers.jbiSetFieldValidator after sessionMap=" + sessionMap);
    }

    public static void jbiSetValidationAlert(HandlerContext handlerCtx) {
        String alertType = (String)handlerCtx.getInputValue("alertType");
        String alertSummary = (String)handlerCtx.getInputValue("alertSummary");
        sLog.fine("OperationHandlers.jbiSetValidationAlert(), alertType=" + alertType + ", alertSummary=" + alertSummary);
        AlertBean alertBean = BeanUtilities.getAlertBean();
        alertBean.setAlertType(alertType);
        alertBean.setAlertSummary(alertSummary);
    }

    private static Properties jbiSetComponentLogLevels(String propertySheetParentId, String propertySheetId, String propertySheetSectionIdTag, String propertyIdTag, String dropDownIdTag, String hiddenFieldIdTag, String componentName, String targetName, String instanceName, HandlerContext handlerCtx) {
        int loggerFailureCount = 0;
        String propertySheetSectionId = "";
        String propertyId = "";
        String dropDownId = "";
        String hiddenFieldId = "";
        int propertySheetSectionCount = 1;
        int propertyCount = 1;
        int dropDownCount = 1;
        int hiddenFieldCount = 1;
        int loopLevel = 1;
        boolean testCounter = false;
        JBIAdminCommands mJac = BeanUtilities.getClient();
        Map originalLoggerLevels = null;
        try {
            originalLoggerLevels = mJac.getComponentLoggerLevels(componentName, targetName, instanceName);
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("jbiSetComponentLogLevels(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
            sLog.fine("jbiSetComponentLogLevels(): unable to retrieve the original log level values");
            ++loggerFailureCount;
        }
        if (loggerFailureCount == 0) {
            boolean propertySheetSectionLoop = true;
            while (propertySheetSectionLoop) {
                propertySheetSectionId = propertySheetSectionIdTag + Integer.toString(propertySheetSectionCount);
                boolean propertyLoop = true;
                while (propertyLoop) {
                    propertyId = propertyIdTag + Integer.toString(propertyCount);
                    boolean dropDownLoop = true;
                    while (dropDownLoop) {
                        String key = propertySheetParentId + ":" + propertySheetId + ":" + propertySheetSectionId + ":" + propertyId;
                        dropDownId = dropDownIdTag + Integer.toString(dropDownCount);
                        String dropDownKey = key + ":" + dropDownId;
                        String dropDownValue = (String)handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(dropDownKey);
                        if (dropDownValue == null) {
                            dropDownKey = dropDownKey + "_list";
                            dropDownValue = (String)handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(dropDownKey);
                        }
                        if (dropDownValue == null) {
                            if (++loopLevel == 2) {
                                dropDownLoop = false;
                                ++propertyCount;
                                continue;
                            }
                            if (loopLevel == 3) {
                                propertyLoop = false;
                                dropDownLoop = false;
                                ++propertySheetSectionCount;
                                continue;
                            }
                            propertySheetSectionLoop = false;
                            propertyLoop = false;
                            dropDownLoop = false;
                            continue;
                        }
                        hiddenFieldId = hiddenFieldIdTag + Integer.toString(hiddenFieldCount);
                        String hiddenFieldKey = key + ":" + hiddenFieldId;
                        Object hiddenFieldValue = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(hiddenFieldKey);
                        if (hiddenFieldValue != null) {
                            String loggerCustomName = hiddenFieldValue.toString();
                            try {
                                String loggerTagName = (String)SystemLoggerUtilities.loggerNames.get(loggerCustomName);
                                if (loggerTagName != null) {
                                    String logLevelStr = dropDownValue;
                                    String targetConfig = targetName + "-config";
                                    String originalLogLevelStr = SystemLoggerUtilities.getLogLevelValue(loggerTagName, targetConfig);
                                    if (!dropDownValue.equalsIgnoreCase(originalLogLevelStr)) {
                                        SystemLoggerUtilities.setLogLevelValue(loggerCustomName, targetName, dropDownValue);
                                        sLog.fine("OperationHandlers - jbiSaveComponentLogLevels() Updated System Logger: , loggerCustomName=" + loggerCustomName + ", dropDownValue=" + dropDownValue + ", targetName=" + targetName);
                                    }
                                } else if (null != mJac) {
                                    Level logLevel = null;
                                    if (!dropDownValue.equalsIgnoreCase(GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.DEFAULT")))) {
                                        logLevel = Level.parse(dropDownValue);
                                    }
                                    Level originalLevel = (Level)originalLoggerLevels.get(loggerCustomName);
                                    if (logLevel == null || originalLevel != null && !logLevel.getName().equalsIgnoreCase(originalLevel.getName())) {
                                        mJac.setComponentLoggerLevel(componentName, loggerCustomName, logLevel, targetName, instanceName);
                                        sLog.fine("OperationHandlers - jbiSaveComponentLogLevels() Updated JBI Logger: componentName=" + componentName + ", loggerCustomName=" + loggerCustomName + ", logLevel=" + logLevel + ", originalLevel=" + originalLevel + ", targetName=" + targetName + ", instanceName=" + instanceName);
                                    }
                                }
                            }
                            catch (JBIRemoteException jbiRemoteEx) {
                                sLog.fine("JBILogLevelsPropertySheetAdaptor(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                                ++loggerFailureCount;
                            }
                        }
                        loopLevel = 1;
                        ++dropDownCount;
                        ++hiddenFieldCount;
                    }
                }
            }
        }
        Properties result = new Properties();
        result.setProperty("name", instanceName);
        result.setProperty("failure-result", "");
        if (loggerFailureCount > 0) {
            String strCount = loggerFailureCount + "";
            Object[] args = new Object[]{strCount, instanceName};
            String msg = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.configure.loggers.failure.message"), (Object[])args);
            result.setProperty("failure-result", msg);
        }
        return result;
    }

    private static List getSelectedComponentOrDeploymentRowProperties(TableRowGroup aGroup) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        ObjectListDataProvider dp = (ObjectListDataProvider)aGroup.getSourceData();
        if (null != dp) {
            try {
                FieldKey fkName = dp.getFieldKey("name");
                FieldKey fkType = dp.getFieldKey("type");
                RowKey[] rowKeys = aGroup.getSelectedRowKeys();
                for (int cnt = 0; cnt < rowKeys.length; ++cnt) {
                    Properties selectedRowProperties = new Properties();
                    String compName = (String)dp.getValue(fkName, rowKeys[cnt]);
                    selectedRowProperties.setProperty("name", compName);
                    String compType = (String)dp.getValue(fkType, rowKeys[cnt]);
                    sLog.fine("OperationHandlers.getSelectedComponentOrDeploymentRowProperties(...), compType=" + compType);
                    if ("binding-component".equals(compType) || "service-engine".equals(compType)) {
                        selectedRowProperties.setProperty("type", compType);
                    } else {
                        selectedRowProperties.setProperty("type", "service-assembly");
                    }
                    result.add(selectedRowProperties);
                }
            }
            catch (Exception ex) {
                sLog.fine("OperationHandlers.getSelectedComponentOrDeploymentRowProperties(), caught ex=" + ex);
                ex.printStackTrace(System.err);
            }
        } else {
            sLog.fine("OperationHandlers.getSelectedComponentOrDeploymentRowProperties(), cannot process dp=" + dp);
        }
        sLog.fine("OperationHandlers.getSelectedComponentOrDeploymentRowProperties(), result=" + result);
        return result;
    }

    private static List getSelectedTargetRowProperties(TableRowGroup aGroup) {
        return TableUtilities.getSelectedRowProperties(aGroup);
    }

    private static Properties shutDown(Properties aRowProperties, List aTargetsList) {
        sLog.fine("OperationHandlers.shutDown(" + aRowProperties + ", " + aTargetsList + ")");
        OperationBean operationBean = BeanUtilities.getOperationBean();
        aRowProperties = operationBean.shutDown(aRowProperties, aTargetsList);
        aRowProperties = OperationHandlers.adjustResults(aRowProperties);
        return aRowProperties;
    }

    private static Properties start(Properties aRowProperties, List aTargetsList) {
        sLog.fine("OperationHandlers.start(" + aRowProperties + ", " + aTargetsList + ")");
        OperationBean operationBean = BeanUtilities.getOperationBean();
        aRowProperties = operationBean.start(aRowProperties, aTargetsList);
        aRowProperties = OperationHandlers.adjustResults(aRowProperties);
        return aRowProperties;
    }

    private static Properties stop(Properties aRowProperties, List aTargetsList) {
        sLog.fine("OperationHandlers.stop(" + aRowProperties + ", " + aTargetsList + ")");
        OperationBean operationBean = BeanUtilities.getOperationBean();
        aRowProperties = operationBean.stop(aRowProperties, aTargetsList);
        aRowProperties = OperationHandlers.adjustResults(aRowProperties);
        return aRowProperties;
    }

    private static Properties adjustResults(Properties aRowProperties) {
        sLog.fine("OperationHandlers.adjustResults(" + aRowProperties + ")");
        JBIManagementMessage mgmtMsg = null;
        String failureResult = aRowProperties.getProperty("failure-result");
        if (null == failureResult) {
            String failureResult2 = aRowProperties.getProperty("success-result");
            if (null == failureResult2) {
                sLog.fine("OperationHandlers.adjustResults(...) no failure or success (?!) --nothing to adjust");
            } else {
                mgmtMsg = BeanUtilities.extractJBIManagementMessage(failureResult2);
                sLog.fine("OperationHandlers.adjustResults(...) mgmtMsg=" + mgmtMsg);
                if (null != mgmtMsg && (mgmtMsg.isFailedMsg() || mgmtMsg.isWarningMsg())) {
                    sLog.fine("OperationHandlers.adjustResults(...) jbiXmlResults has failure(s) -- adjust failureResult2=" + failureResult2);
                    aRowProperties.remove("success-result");
                    String msg = mgmtMsg.getMessage();
                    msg = msg.replaceAll(NEWLINE, BREAK);
                    sLog.fine("OperationHandlers.adjustResults(...) msg=" + msg);
                    aRowProperties.setProperty("failure-result", msg);
                } else {
                    sLog.fine("OperationHandlers.adjustResults(...) jbiXmlResult success --nothing to adjust");
                }
            }
        } else {
            sLog.fine("OperationHandlers.accumulateResults(...) found failure--accumulate failureResult=" + failureResult);
            mgmtMsg = BeanUtilities.extractJBIManagementMessage(failureResult);
            if (null != mgmtMsg) {
                aRowProperties.remove("success-result");
                String msg = mgmtMsg.getMessage();
                msg = msg.replaceAll(NEWLINE, BREAK);
                aRowProperties.setProperty("failure-result", msg);
            } else {
                sLog.fine("OperationHandlers.accumulateResults(...) no management message");
            }
        }
        return aRowProperties;
    }

    private static Properties getCurrentRuntimeConfigurationProperties(String aTarget) {
        Properties result = new Properties();
        JBIAdminCommands mJac = BeanUtilities.getClient();
        try {
            result = mJac.getRuntimeConfiguration(aTarget);
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters heartBeatInterval metaData = " + mJac.getRuntimeConfigurationMetaData("heartBeatInterval"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters jbiHome metaData = " + mJac.getRuntimeConfigurationMetaData("jbiHome"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters autoInstallEnabled metaData = " + mJac.getRuntimeConfigurationMetaData("autoInstallEnabled"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters autoInstallDir metaData = " + mJac.getRuntimeConfigurationMetaData("autoInstallDir"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters startOnDeploy metaData = " + mJac.getRuntimeConfigurationMetaData("startOnDeploy"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters installationTimeout metaData = " + mJac.getRuntimeConfigurationMetaData("installationTimeout"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters componentTimeout metaData = " + mJac.getRuntimeConfigurationMetaData("componentTimeout"));
            sLog.fine("OperationHandlers.jbiGetRuntimeConfigurationParameters serviceUnitTimeout metaData = " + mJac.getRuntimeConfigurationMetaData("serviceUnitTimeout"));
            if (null != result) {
                for (Object object : result.keySet()) {
                    String k = (String)object;
                    String v = result.getProperty(k);
                    sLog.finer("OperationHandlers.getCurrentRuntimeConfigurationProperties " + k + " metaData = " + mJac.getRuntimeConfigurationMetaData(k));
                    sLog.finer("OperationHandlers.getCurrentRuntimeConfigurationProperties(" + aTarget + "), key=" + k + ", value=" + v);
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            jbiRemoteEx.printStackTrace();
        }
        sLog.fine("OperationHandlers.getCurrentRuntimeConfigurationProperties(" + aTarget + ")=" + result);
        return result;
    }

    private static Properties findChangedRuntimeConfigurationProperties(String aTarget, Properties aListOfAllProperties) {
        Properties result = new Properties();
        sLog.fine("OperationHandlers.findCurrentRuntimeConfigurationProperties(" + aTarget + ")");
        Properties currentProperties = OperationHandlers.getCurrentRuntimeConfigurationProperties(aTarget);
        if (null != aListOfAllProperties) {
            for (Object object : aListOfAllProperties.keySet()) {
                String k = (String)object;
                String newValue = aListOfAllProperties.getProperty(k);
                String currentValue = currentProperties.getProperty(k);
                sLog.finer("OperationHandlers.findCurrentRuntimeConfigurationProperties(" + aTarget + "), k=" + k + ", newValue=" + newValue + ", currentValue=" + currentValue);
                if (null == newValue || newValue.equals(currentValue)) continue;
                result.setProperty(k, newValue);
                sLog.finer("OperationHandlers.findCurrentRuntimeConfigurationProperties(" + aTarget + "), k=" + k + ", newValue=" + newValue + " added to result");
            }
        }
        sLog.fine("OperationHandlers.findCurrentRuntimeConfigurationProperties(" + aTarget + "), result=" + result);
        return result;
    }

    private static Properties setPropertyIfNotNull(Properties aProperties, String aKey, String aValue) {
        Properties result = aProperties;
        sLog.fine("OperationalHandlers.setPropertyIfNotNull(...), key=" + aKey + ", value=" + aValue);
        if (null != aValue) {
            result.setProperty(aKey, aValue);
        }
        return result;
    }
}

