/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.jbi.jsf.bean.ArchiveBean;
import com.sun.jbi.jsf.bean.InstallationBean;
import com.sun.jbi.jsf.bean.UploadCopyRadioBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.ValidationUtilities;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class JbiArchiveValidationHandler {
    public static final String JBI_TYPE_COMP = "component";
    private static Logger sLog = JBILogger.getInstance();

    public static void getUploadedFileLocation(HandlerContext handlerCtx) {
        String WIN_CLIENT_SEPARATOR = "\\";
        ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        String suffix = null;
        String prefix = null;
        if (uploadedFile != null) {
            String name = uploadedFile.getOriginalName();
            sLog.fine("JbiArchiveValidationHandler.getUploadedFileLocation() original name=" + name);
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
                sLog.fine("JbiArchiveValidationHandler.getUploadedFileLocation() truncated name=" + name);
            }
            archiveBean.setArchiveDisplayName(name);
            if (name.length() != 0) {
                suffix = name.substring(name.indexOf("."));
                prefix = name.substring(0, name.indexOf("."));
                try {
                    String tmpFolder = FileUtil.getTempDirPath();
                    File tmpFile = File.createTempFile(prefix, suffix, new File(tmpFolder));
                    uploadedFile.write(tmpFile);
                    sLog.fine("JbiArchiveValidationHandler.getUploadedFileLocation()tmpFile=" + tmpFile.getAbsolutePath());
                    handlerCtx.setOutputValue("uploadedLoc", (Object)tmpFile.getCanonicalPath());
                    archiveBean.setArchiveAbsolutePath(tmpFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    sLog.log(Level.FINE, "JbiArchiveValidationHandler.getUploadedFileLocation(...), while saving uploaded file, caught ex=", ex);
                    handlerCtx.setOutputValue("uploadedLoc", (Object)"");
                    archiveBean.setArchiveAbsolutePath("");
                }
            } else {
                handlerCtx.setOutputValue("uploadedLoc", (Object)"");
                archiveBean.setArchiveAbsolutePath("");
            }
        }
    }

    public static void getArchivePath(HandlerContext handlerCtx) {
        InstallationBean installBean = BeanUtilities.getInstallationBean();
        String filePath = (String)handlerCtx.getInputValue("filePath");
        boolean uploadChecked = (Boolean)handlerCtx.getInputValue("uploadRadio");
        sLog.fine("JbiArchiveValidationHandler.getArchivePath(...), filePath=" + filePath + ", uploadChecked=" + uploadChecked);
        if (uploadChecked) {
            installBean.setUploadPathSelected(true);
        } else {
            installBean.setUploadPathSelected(false);
            ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
            archiveBean.setArchiveAbsolutePath(filePath);
            archiveBean.setArchiveDisplayName(filePath);
        }
        handlerCtx.setOutputValue("archiveFilePath", (Object)filePath);
        sLog.fine("JbiArchiveValidationHandler.getArchivePath(...), filePath=" + filePath);
    }

    public static void isValidArchive(HandlerContext handlerContext) {
        ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
        UploadCopyRadioBean uploadCpBean = BeanUtilities.getUploadCopyRadioBean();
        String pathToFile = (String)handlerContext.getInputValue("archivePath");
        String compType = (String)handlerContext.getInputValue("compType");
        String navValid = (String)handlerContext.getInputValue("navValid");
        uploadCpBean.setNavDestValid(navValid);
        String navInvalid = (String)handlerContext.getInputValue("navInvalid");
        uploadCpBean.setNavDestInvalid(navInvalid);
        sLog.fine("JbiArchiveValidationHandler.isValidArchive(), archivePath=" + pathToFile + ", compType=" + compType + ", navValid=" + navValid + ", navInvalid=" + navInvalid);
        Document jbiMetadataDoc = ValidationUtilities.getJbiDocument();
        String componentType = ValidationUtilities.getJbiType(jbiMetadataDoc);
        sLog.fine("JbiArchiveValidationHandler.isValidArchive(), jbiMetadataDoc=" + jbiMetadataDoc + ", componentType=" + componentType);
        String invalidAlertDetail = JbiArchiveValidationHandler.checkValidArchive(pathToFile, compType);
        if (!"".equals(invalidAlertDetail)) {
            sLog.fine("JbiArchiveValidationHandler.isValidArchive(), invalidAlertDetail=" + invalidAlertDetail);
            JbiArchiveValidationHandler.setOutputInvalidAlertValue(invalidAlertDetail, handlerContext);
        } else {
            String navLoc = uploadCpBean.getNavDestValid();
            sLog.fine("JbiArchiveValidationHandler.isValidArchive(), isValid=true, isAlertNeeded=false, navLoc=" + navLoc + ", componentType=" + componentType);
            handlerContext.setOutputValue("isValid", (Object)"true");
            handlerContext.setOutputValue("isAlertNeeded", (Object)"false");
            handlerContext.setOutputValue("navLoc", (Object)navLoc);
            archiveBean.setJbiType(componentType);
        }
    }

    public static void deleteInvalidatedUploadedArchive(HandlerContext handlerContext) {
        String uploadedFileLoc = (String)handlerContext.getInputValue("archivePath");
        Boolean isValid = (Boolean)handlerContext.getInputValue("archiveStatus");
        Boolean isUpload = (Boolean)handlerContext.getInputValue("uploadSelected");
        sLog.fine("JbiArchiveValidationHandler.deleteInvalidatedUploadedArchive(...), archivePath(uploadedFileLoc)=" + uploadedFileLoc + ", archiveStatus(isValid)=" + isValid + ", uploadSelected(isUpload)=" + isUpload);
        try {
            if (isUpload.booleanValue() && !isValid.booleanValue() && null != uploadedFileLoc && !"".equals(uploadedFileLoc)) {
                sLog.fine("JbiArchiveValidationHandler.deleteInvalidatedUploadedArchive(...), deleting uploadedFileLoc=" + uploadedFileLoc);
                FileUtil.delete((String)uploadedFileLoc);
            }
        }
        catch (Exception ex) {
            sLog.log(Level.FINE, "JbiArchiveValidationHandler.deleteInvalidatedUploadedArchive(...), while deleting uploadedFileLoc=" + uploadedFileLoc + ", caught ex=", ex);
        }
    }

    private static void setOutputInvalidAlertValue(String aAlertDetail, HandlerContext aHandlerCtxt) {
        UploadCopyRadioBean uploadCpBean = BeanUtilities.getUploadCopyRadioBean();
        String navDestIfInvalid = uploadCpBean.getNavDestInValid();
        String alertSummary = I18nUtilities.getResourceString("jbi.install.wizard.invalid.alertsummary.text");
        aHandlerCtxt.setOutputValue("isValid", (Object)"false");
        aHandlerCtxt.setOutputValue("isAlertNeeded", (Object)"true");
        aHandlerCtxt.setOutputValue("alertSummaryMsg", (Object)alertSummary);
        aHandlerCtxt.setOutputValue("alertDetailMsg", (Object)aAlertDetail);
        aHandlerCtxt.setOutputValue("navLoc", (Object)navDestIfInvalid);
        sLog.fine("JbiArchiveValidationHandler.setOutputInvalidAlertValue(...), isValid=false, isAlertNeeded=true, alertSummary=" + alertSummary + ", aAlertDetail=" + aAlertDetail + ", navLoc=" + navDestIfInvalid);
    }

    public static String checkValidArchive(String aPathToFile, String aCompType) {
        ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
        archiveBean.setArchiveAbsolutePath(aPathToFile);
        String jbiType = "";
        JbiArchiveValidationHandler.resetValidationParameters();
        String alertDetailNotWellFormed = I18nUtilities.getResourceString("jbi.install.wizard.invalid.notwellformed.text");
        String alertDetailNotFound = I18nUtilities.getResourceString("jbi.install.wizard.invalid.filenotfound.text");
        String alertDetailMissingJbi = I18nUtilities.getResourceString("jbi.install.wizard.invalid.missingjbixml.text");
        String alertDetailNotSchemaValid = I18nUtilities.getResourceString("jbi.install.wizard.invalid.notschemavalid.text");
        String alertDetailMismatchArchiveWizard = I18nUtilities.getResourceString("jbi.install.wizard.invalid.mismatcharchivewizard.text");
        boolean count = false;
        boolean zipError = archiveBean.getZipFileReadError();
        boolean fileError = archiveBean.getFileReadError();
        boolean emptyInvalid = ValidationUtilities.isArchiveEmptyOrInValid();
        if (emptyInvalid || zipError || fileError) {
            return alertDetailNotFound;
        }
        ValidationUtilities.getMetaDataEntry();
        if (!archiveBean.getHasJbiXml()) {
            return alertDetailMissingJbi;
        }
        if (!ValidationUtilities.isJbiXmlWellformed()) {
            return alertDetailNotWellFormed;
        }
        String componentType = ValidationUtilities.getJbiType(ValidationUtilities.getJbiDocument());
        jbiType = componentType.equals("binding-component") || componentType.equals("service-engine") ? JBI_TYPE_COMP : componentType;
        if (!jbiType.equals(aCompType)) {
            return alertDetailMismatchArchiveWizard;
        }
        return "";
    }

    private static void resetValidationParameters() {
        ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
        archiveBean.setHasJbiXml(true);
        archiveBean.setZipFileReadError(false);
        archiveBean.setFileReadError(false);
    }
}

