/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.bean.DeletionBean;
import com.sun.jbi.jsf.bean.InstallationBean;
import com.sun.jbi.jsf.bean.InstallationTarget;
import com.sun.jbi.jsf.bean.JBIComponentConfigBean;
import com.sun.jbi.jsf.bean.OperationBean;
import com.sun.jbi.jsf.bean.ShowBean;
import com.sun.jbi.jsf.util.AlertUtilities;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.ClusterUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.TableUtilities;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class InstallationHandlers {
    public static final String KEY_ARCHIVE_NAME = "archiveName";
    public static final String KEY_PATH = "path";
    public static final String KEY_NAME = "name";
    private static final boolean IS_CLUSTER_PROFILE = ClusterUtilities.isClusterProfile();
    private static Logger sLog = JBILogger.getInstance();

    public static void jbiDeleteSelectedRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String tableType = (String)handlerCtx.getInputValue("tableType");
        sLog.fine("InstallationHandlers.jbiDeleteSelectedRows(" + trg + ", " + tableType + ")");
        List deletionRows = TableUtilities.getSelectedRowProperties(trg);
        Iterator rowIt = deletionRows.iterator();
        int countFailedDeletions = 0;
        int countSuccessfulDeletions = 0;
        int countWarningDeletions = 0;
        boolean isAlertNeeded = false;
        String alertDetails = "";
        String alertType = "";
        while (rowIt.hasNext()) {
            Properties rowProperties = (Properties)rowIt.next();
            String rowName = rowProperties.getProperty(KEY_NAME);
            String rowType = rowProperties.getProperty("type");
            ArrayList<String> targets = new ArrayList<String>();
            List listOfTargets = new ArrayList();
            if (IS_CLUSTER_PROFILE) {
                listOfTargets = ClusterUtilities.findTargetsForNameByType(rowName, rowType);
                if (listOfTargets.size() == 0) {
                    targets.add("domain");
                } else {
                    for (Properties targetProperties : listOfTargets) {
                        String tgt = targetProperties.getProperty(KEY_NAME);
                        targets.add(tgt);
                    }
                }
            } else {
                targets.add("server");
            }
            sLog.fine("InstallationHandlers.jbiDeleteSelectedRows(), targets=" + targets + ")");
            boolean retainFlag = false;
            InstallationHandlers.delete(rowProperties, retainFlag, targets);
            String successResult = rowProperties.getProperty("success-result");
            if (null != successResult) {
                sLog.fine("InstallationHandlers.jbiDeleteSelectedRows(...),  success for " + rowProperties + ", countFailedDeletions=" + countFailedDeletions + ", countSuccessfulDeletions=" + ++countSuccessfulDeletions);
                continue;
            }
            String failureResult = rowProperties.getProperty("failure-result");
            if (failureResult.trim().startsWith("WARNING")) {
                ++countWarningDeletions;
            } else {
                ++countFailedDeletions;
            }
            sLog.fine("InstallationHandlers.jbiDeleteSelectedRows(...),  failure for " + rowProperties + ", countFailedDeletions=" + countFailedDeletions + ", countSuccessfulDeletions=" + countSuccessfulDeletions);
            String details = "";
            String exceptionMessage = AlertUtilities.getMessage(failureResult);
            details = "".equals(exceptionMessage) ? failureResult : exceptionMessage;
            Object[] args = new Object[]{rowName, details};
            alertDetails = alertDetails + GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.deletion.failed.for.row"), (Object[])args) + "<br />";
        }
        String alertSummary = "";
        if (0 < countFailedDeletions) {
            alertSummary = 0 < countSuccessfulDeletions || 0 < countWarningDeletions ? (1 == countFailedDeletions ? I18nUtilities.getResourceString("jbi.delete.one.failed.alert.summary.text") : I18nUtilities.getResourceString("jbi.delete.some.failed.alert.summary.text")) : I18nUtilities.getResourceString("jbi.delete.all.failed.alert.summary.text");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        } else if (0 < countWarningDeletions) {
            alertSummary = I18nUtilities.getResourceString("jbi.deletion.warning.summary");
            alertType = "warning";
            AlertBean alertBean = BeanUtilities.getAlertBean();
            alertBean.setAlertType(alertType);
        }
        if (countFailedDeletions > 0 || countWarningDeletions > 0) {
            isAlertNeeded = true;
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("InstallationHandlers.jbiDeleteSelectedRows(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
    }

    public static void jbiInstallValidatedArchive(HandlerContext handlerCtx) {
        String redirectOnSuccess;
        String archivePath = (String)handlerCtx.getInputValue("archivePath");
        String jbiName = (String)handlerCtx.getInputValue("jbiName");
        String jbiType = (String)handlerCtx.getInputValue("jbiType");
        String redirectOnFailure = (String)handlerCtx.getInputValue("redirectOnFailure");
        String redirectTo = redirectOnSuccess = (String)handlerCtx.getInputValue("redirectOnSuccess");
        Boolean isEnabledAfterInstallOrDeploy = (Boolean)handlerCtx.getInputValue("isEnabledAfterInstallOrDeploy");
        sLog.fine("InstallationHandlers.jbiInstallValidatedArchive(), archivePath=" + archivePath + ", jbiName=" + jbiName + ", jbiType=" + jbiType + ", isEnabledAfterInstallOrDeploy=" + isEnabledAfterInstallOrDeploy + ", redirectOnFailure=" + redirectOnFailure + ", redirectOnSuccess=" + redirectOnSuccess);
        String alertDetails = "";
        String alertSummary = "";
        String internalError = "";
        String successResult = "";
        String failureResult = "";
        boolean failureFlag = false;
        boolean internalErrorFlag = false;
        boolean isAlertNeeded = false;
        boolean noTargetFlag = false;
        ArrayList<Properties> successTargets = new ArrayList<Properties>();
        List<String> targets = new ArrayList<String>();
        int countSuccessfulStart = 0;
        int countFailedStart = 0;
        int countSuccessfulInstalls = 0;
        int countFailedInstalls = 0;
        Properties installProperties = new Properties();
        installProperties.setProperty(KEY_PATH, archivePath);
        installProperties.setProperty(KEY_NAME, jbiName);
        installProperties.setProperty("type", jbiType);
        if (IS_CLUSTER_PROFILE) {
            targets = (List)handlerCtx.getInputValue("installList");
            if (targets.size() == 0) {
                targets = new ArrayList();
                targets.add("domain");
                noTargetFlag = true;
            }
        } else {
            targets.add("server");
        }
        for (String target : targets) {
            installProperties = InstallationHandlers.install(installProperties, target);
            successResult = installProperties.getProperty("success-result");
            internalError = installProperties.getProperty("internal-error");
            if (null != internalError) {
                internalErrorFlag = true;
                break;
            }
            if (null != successResult) {
                ++countSuccessfulInstalls;
                Properties succcessProperties = new Properties();
                succcessProperties.setProperty(KEY_NAME, target);
                successTargets.add(succcessProperties);
                continue;
            }
            failureFlag = true;
            ++countFailedInstalls;
            failureResult = installProperties.getProperty("failure-result");
            alertDetails = alertDetails + failureResult + "<br>";
        }
        JBIComponentConfigBean configBean = BeanUtilities.getJBIComponentConfigBean();
        configBean.invalidateCommittedDataProvider();
        if (failureFlag || internalErrorFlag) {
            isAlertNeeded = true;
            if (internalErrorFlag) {
                alertSummary = I18nUtilities.getResourceString("jbi.internal.error.summary");
                alertDetails = internalError;
            } else {
                alertSummary = "service-assembly".equals(jbiType) ? I18nUtilities.getResourceString("jbi.deployment.failed.alert.summary.text") : I18nUtilities.getResourceString("jbi.installation.failed.alert.summary.text");
            }
        } else {
            if (null != isEnabledAfterInstallOrDeploy && isEnabledAfterInstallOrDeploy.booleanValue() && countSuccessfulInstalls > 0) {
                Properties startProperties = new Properties();
                if (noTargetFlag) {
                    sLog.fine("*** noTargetFlag set");
                    isAlertNeeded = true;
                    String typeText = "";
                    typeText = jbiType.equalsIgnoreCase("bindingsEngines") ? I18nUtilities.getResourceString("jbi.failed.no.target.component") : I18nUtilities.getResourceString("jbi.failed.no.target.deployment");
                    ++countFailedStart;
                    Object[] args = new Object[]{typeText, jbiName};
                    failureResult = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.failed.no.target"), (Object[])args);
                    alertDetails = alertDetails + failureResult + "<br>";
                    alertSummary = I18nUtilities.getResourceString("jbi.failed.start.after.install");
                } else {
                    startProperties.setProperty(KEY_NAME, jbiName);
                    startProperties.setProperty("type", jbiType);
                    OperationBean operationBean = BeanUtilities.getOperationBean();
                    startProperties = operationBean.start(startProperties, successTargets);
                    successResult = startProperties.getProperty("success-result");
                    if (null != successResult) {
                        ++countSuccessfulStart;
                    } else {
                        isAlertNeeded = true;
                        ++countFailedStart;
                        failureResult = startProperties.getProperty("failure-result");
                        alertDetails = alertDetails + failureResult + "<br>";
                        alertSummary = I18nUtilities.getResourceString("jbi.failed.start.after.install");
                    }
                }
                sLog.fine("InstallationHandlers.jbiInstallValidatedArchive(...), startProperties=" + startProperties);
            }
            InstallationHandlers.deleteTempFile(archivePath);
        }
        if (countSuccessfulInstalls > 0) {
            redirectTo = redirectOnSuccess;
            if (isAlertNeeded) {
                alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
            }
        } else if (isAlertNeeded) {
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
            redirectTo = redirectOnFailure;
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        handlerCtx.setOutputValue("redirectTo", (Object)redirectTo);
        sLog.fine("InstallationHandlers.jbiInstallValidatedArchive(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails + ", redirectTo=" + redirectTo);
    }

    public static void jbiUpdateValidatedArchive(HandlerContext handlerCtx) {
        String redirectOnSuccess;
        String archivePath = (String)handlerCtx.getInputValue("archivePath");
        String jbiName = (String)handlerCtx.getInputValue("jbiName");
        String jbiType = (String)handlerCtx.getInputValue("jbiType");
        String redirectOnFailure = (String)handlerCtx.getInputValue("redirectOnFailure");
        String redirectTo = redirectOnSuccess = (String)handlerCtx.getInputValue("redirectOnSuccess");
        Boolean isEnabledAfterInstallOrDeploy = (Boolean)handlerCtx.getInputValue("isEnabledAfterInstallOrDeploy");
        sLog.fine("InstallationHandlers.jbiUpdateValidatedArchive(), archivePath=" + archivePath + ", jbiName=" + jbiName + ", jbiType=" + jbiType + ", isEnabledAfterInstallOrDeploy=" + isEnabledAfterInstallOrDeploy + ", redirectOnFailure=" + redirectOnFailure + ", redirectOnSuccess=" + redirectOnSuccess);
        String alertDetails = "";
        String alertSummary = "";
        String internalError = "";
        String successResult = "";
        String failureResult = "";
        boolean failureFlag = false;
        boolean internalErrorFlag = false;
        boolean isAlertNeeded = false;
        boolean noTargetFlag = false;
        boolean countSuccessfulStart = false;
        boolean countFailedStart = false;
        boolean countSuccessfulInstalls = false;
        boolean countFailedInstalls = false;
        Properties updateProperties = new Properties();
        updateProperties.setProperty(KEY_PATH, archivePath);
        updateProperties.setProperty(KEY_NAME, jbiName);
        updateProperties.setProperty("type", jbiType);
        successResult = updateProperties.getProperty("success-result");
        internalError = updateProperties.getProperty("internal-error");
        if (null != internalError) {
            internalErrorFlag = true;
        }
        InstallationHandlers.deleteTempFile(archivePath);
        isAlertNeeded = true;
        alertSummary = "Update Failed";
        alertDetails = "Not Yet Implemented";
        redirectTo = redirectOnFailure;
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        handlerCtx.setOutputValue("redirectTo", (Object)redirectTo);
        sLog.fine("InstallationHandlers.jbiUpdateValidatedArchive(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails + ", redirectTo=" + redirectTo);
    }

    public static void deleteUploadedArchiveFromTmpDir(HandlerContext handlerContext) {
        String archivePath = (String)handlerContext.getInputValue("archivePath");
        InstallationHandlers.deleteTempFile(archivePath);
    }

    private static void deleteTempFile(String aTempFile) {
        InstallationBean installationBean = BeanUtilities.getInstallationBean();
        if (installationBean.getUploadSelected()) {
            sLog.fine("InstallationHandlers.deleteTempFile(...), delete archive..." + aTempFile);
            Boolean deletedUploadedFileInTmpDir = FileUtil.delete((String)aTempFile);
            sLog.fine("InstallationHandlers.deleteUploadedArchiveFromTmpDir(...), deletedUploadedFileInTmpDir=" + deletedUploadedFileInTmpDir);
        }
    }

    public static void initializeTargetShowList(HandlerContext handlerCtx) {
        ShowBean showBean = BeanUtilities.getShowBean();
        showBean.initTargetNames();
    }

    public static void addListToOptions(HandlerContext handlerCtx) {
        List inputList = (List)handlerCtx.getInputValue("inputList");
        List inputOptions = (List)handlerCtx.getInputValue("inputOptions");
        ArrayList<Option> outputOptions = new ArrayList<Option>();
        if (inputOptions != null) {
            outputOptions.addAll(inputOptions);
        }
        for (int i = 0; i < inputList.size(); ++i) {
            Option o = new Option((Object)((String)inputList.get(i)), (String)inputList.get(i));
            outputOptions.add(o);
        }
        handlerCtx.setOutputValue("outputOptions", outputOptions);
    }

    public static void jbiManageTargets(HandlerContext handlerCtx) {
        List installList = (List)handlerCtx.getInputValue("installList");
        List uninstallList = (List)handlerCtx.getInputValue("uninstallList");
        ShowBean showBean = BeanUtilities.getShowBean();
        String name = showBean.getName();
        String type = showBean.getType();
        String alertDetails = "";
        String alertSummary = "";
        String internalError = "";
        String successResult = "";
        String failureResult = "";
        Properties prop = new Properties();
        prop.setProperty(KEY_NAME, name);
        prop.setProperty("type", type);
        prop.setProperty(KEY_ARCHIVE_NAME, name);
        int countFailedDeletions = 0;
        int countSuccessfulDeletions = 0;
        int countFailedInstalls = 0;
        int countSuccessfulInstalls = 0;
        boolean failureFlag = false;
        boolean internalErrorFlag = false;
        boolean isAlertNeeded = false;
        for (String target : uninstallList) {
            ArrayList<String> targetList = new ArrayList<String>();
            targetList.add(target);
            boolean retainFlag = true;
            InstallationHandlers.delete(prop, retainFlag, targetList);
            successResult = prop.getProperty("success-result");
            internalError = prop.getProperty("internal-error");
            if (null != internalError) {
                internalErrorFlag = true;
                break;
            }
            if (null != successResult) {
                ++countSuccessfulDeletions;
                continue;
            }
            failureFlag = true;
            ++countFailedDeletions;
            failureResult = prop.getProperty("failure-result");
            alertDetails = alertDetails + failureResult + "<br>";
        }
        prop = new Properties();
        prop.setProperty(KEY_NAME, name);
        prop.setProperty("type", type);
        prop.setProperty(KEY_ARCHIVE_NAME, name);
        if (!internalErrorFlag) {
            for (String target : installList) {
                prop = InstallationHandlers.install(prop, target);
                successResult = prop.getProperty("success-result");
                internalError = prop.getProperty("internal-error");
                if (null != internalError) {
                    internalErrorFlag = true;
                    break;
                }
                if (null != successResult) {
                    ++countSuccessfulInstalls;
                    continue;
                }
                failureFlag = true;
                ++countFailedInstalls;
                failureResult = prop.getProperty("failure-result");
                alertDetails = alertDetails + failureResult + "<br>";
            }
        }
        if (failureFlag || internalErrorFlag) {
            isAlertNeeded = true;
            if (internalErrorFlag) {
                alertSummary = I18nUtilities.getResourceString("jbi.internal.error.summary");
                alertDetails = internalError;
            }
            alertSummary = I18nUtilities.getResourceString("jbi.manage.targets.failure");
            alertDetails = BeanUtilities.addAlertFooterMessage(alertDetails);
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("InstallationHandlers.manageTargets(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
        sLog.fine("InstallationHandlers.manageTargets(...),  countSuccessfulDeletions=" + countSuccessfulDeletions + ", countSuccessfulInstalls=" + countSuccessfulInstalls + ", countFailedInstalls=" + countFailedInstalls + ", countFailedDeletions=" + countFailedDeletions);
    }

    public static void jbiRemoveSelectedSingleTargetRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        sLog.fine("InstallationHandlers.jbiRemoveSelectedSingleTargetRows(" + trg + ", " + targetName + ")");
        List deletionRows = TableUtilities.getSelectedRowProperties(trg);
        Iterator rowIt = deletionRows.iterator();
        int countFailedDeletions = 0;
        int countSuccessfulDeletions = 0;
        String alertDetails = "";
        String alertSummary = "";
        boolean isAlertNeeded = false;
        while (rowIt.hasNext()) {
            Properties rowProperties = (Properties)rowIt.next();
            String rowName = rowProperties.getProperty(KEY_NAME);
            String rowType = rowProperties.getProperty("type");
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(targetName);
            boolean retainFlag = true;
            InstallationHandlers.delete(rowProperties, retainFlag, targets);
            String successResult = rowProperties.getProperty("success-result");
            if (null != successResult) {
                sLog.fine("InstallationHandlers.jbiRemoveSelectedSingleTargetRows(...),  success for " + rowProperties + ", countFailedDeletions=" + countFailedDeletions + ", countSuccessfulDeletions=" + ++countSuccessfulDeletions);
                continue;
            }
            isAlertNeeded = true;
            alertSummary = I18nUtilities.getResourceString("jbi.remove.from.target.failed");
            sLog.fine("InstallationHandlers.jbiRemoveSelectedSingleTargetRows(...),  failure for " + rowProperties + ", countFailedDeletions=" + ++countFailedDeletions + ", countSuccessfulDeletions=" + countSuccessfulDeletions);
            String failureResult = rowProperties.getProperty("failure-result");
            String details = "";
            String exceptionMessage = AlertUtilities.getMessage(failureResult);
            details = "".equals(exceptionMessage) ? failureResult : exceptionMessage;
            Object[] args = new Object[]{rowName, details};
            String alertDet = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.deletion.failed.for.row"), (Object[])args);
            alertDetails = alertDetails + alertDet + "<br />";
        }
        handlerCtx.setOutputValue("isAlertNeeded", (Object)Boolean.toString(isAlertNeeded));
        handlerCtx.setOutputValue("alertSummary", (Object)alertSummary);
        handlerCtx.setOutputValue("alertDetails", (Object)alertDetails);
        sLog.fine("InstallationHandlers.jbiInstallValidatedArchive(...),  isAlertNeeded=" + isAlertNeeded + ", alertSummary=" + alertSummary + ", alertDetails=" + alertDetails);
    }

    public static void jbiGetTargetsLists(HandlerContext handlerCtx) {
        List inputList = (List)handlerCtx.getInputValue("inputList");
        List inputOptions = (List)handlerCtx.getInputValue("inputOptions");
        Boolean isJBIArcheiveAvailable = (Boolean)handlerCtx.getInputValue("isJBIArchiveAvailable");
        ArrayList<InstallationTarget> targetsList = new ArrayList<InstallationTarget>();
        ArrayList<InstallationTarget> availableTargetList = new ArrayList<InstallationTarget>();
        ArrayList<InstallationTarget> installedTargetList = new ArrayList<InstallationTarget>();
        if (inputOptions != null) {
            for (Object targetOption : inputOptions) {
                String targetName = (String)targetOption.getValue();
                InstallationTarget it = new InstallationTarget(targetName);
                if (!isJBIArcheiveAvailable.booleanValue() && targetName.equals("server")) {
                    it.setSelected(false);
                }
                targetsList.add(it);
            }
        }
        if (inputList != null) {
            for (Object targetOption : inputList) {
                InstallationTarget it = new InstallationTarget((String)targetOption);
                targetsList.add(it);
            }
        }
        if (!isJBIArcheiveAvailable.booleanValue()) {
            ShowBean showBean = BeanUtilities.getShowBean();
            for (InstallationTarget target : targetsList) {
                String targetName = target.getName();
                String status = showBean.check(targetName);
                if (null != status) {
                    installedTargetList.add(target);
                    continue;
                }
                availableTargetList.add(target);
            }
        } else {
            availableTargetList.addAll(targetsList);
        }
        handlerCtx.setOutputValue("availableTargetList", availableTargetList);
        handlerCtx.setOutputValue("installedTargetList", installedTargetList);
    }

    public static void jbiGetSelectedTargetsFromAvailableTable(HandlerContext handlerCtx) {
        ArrayList<String> selectedList = new ArrayList<String>();
        String[] targetsName = null;
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("availableTableRowGroup");
        ObjectListDataProvider dp = (ObjectListDataProvider)trg.getSourceData();
        dp.commitChanges();
        if (null != dp && dp.getRowCount() > 0) {
            FieldKey targetname = dp.getFieldKey(KEY_NAME);
            RowKey[] rowKeys = trg.getSelectedRowKeys();
            targetsName = new String[rowKeys.length];
            for (int index = 0; index < rowKeys.length; ++index) {
                String name = (String)dp.getValue(targetname, rowKeys[index]);
                selectedList.add(name);
                targetsName[index] = name;
            }
        }
        InstallationBean installationBean = BeanUtilities.getInstallationBean();
        installationBean.setTargetNames(targetsName);
        handlerCtx.setOutputValue("selectedAvailableTargetsList", selectedList);
    }

    public static void jbiGetSelectedTargetsFromInstalledTable(HandlerContext handlerCtx) {
        ArrayList<String> selectedList = new ArrayList<String>();
        String[] targetsName = null;
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("installedTableRowGroup");
        ObjectListDataProvider dp = (ObjectListDataProvider)trg.getSourceData();
        dp.commitChanges();
        if (null != dp && dp.getRowCount() > 0) {
            FieldKey targetname = dp.getFieldKey(KEY_NAME);
            RowKey[] rowKeys = trg.getSelectedRowKeys();
            targetsName = new String[rowKeys.length];
            for (int index = 0; index < rowKeys.length; ++index) {
                String name = (String)dp.getValue(targetname, rowKeys[index]);
                selectedList.add(name);
                targetsName[index] = name;
            }
        }
        InstallationBean installationBean = BeanUtilities.getInstallationBean();
        installationBean.setTargetNames(targetsName);
        handlerCtx.setOutputValue("selectedInstalledTargetsList", selectedList);
    }

    public static void jbiCreateSingleTargetList(HandlerContext handlerCtx) {
        ArrayList<String> installTargetsList = new ArrayList<String>();
        String singleTarget = (String)handlerCtx.getInputValue("singleTarget");
        installTargetsList.add(singleTarget);
        sLog.fine("InstallationHandlers.jbiCreateSingleTargetList(" + singleTarget + "): " + installTargetsList);
        handlerCtx.setOutputValue("installTargetsList", installTargetsList);
    }

    private static void delete(Properties aRowProperties, boolean aRetainFlag, List aTargetsList) {
        sLog.fine("InstallationHandlers.delete(" + aRowProperties + ", " + aTargetsList + ")");
        DeletionBean deletionBean = BeanUtilities.getDeletionBean();
        deletionBean.delete(aRowProperties, aRetainFlag, aTargetsList);
    }

    private static Properties install(Properties aProp, String aTarget) {
        InstallationBean installationBean = BeanUtilities.getInstallationBean();
        aProp = installationBean.installValidatedArchive(aProp, aTarget);
        return aProp;
    }

    private static Properties install(Properties anInstallationProperties) {
        Properties result = null;
        sLog.fine("InstallationHandlers.install()");
        InstallationBean installationBean = BeanUtilities.getInstallationBean();
        result = anInstallationProperties = installationBean.installValidatedArchive(anInstallationProperties);
        sLog.fine("InstallationHandlers.install(), result=" + result);
        return result;
    }
}

