/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services;

import com.sun.jbi.jsf.framework.connectors.LocalServerConnector;
import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.services.ServiceFactory;
import com.sun.jbi.jsf.framework.services.administration.AdministrationService;
import com.sun.jbi.jsf.framework.services.configuration.ConfigurationService;
import com.sun.jbi.jsf.framework.services.management.ManagementService;
import com.sun.jbi.jsf.framework.services.statistics.StatisticsService;
import java.io.Serializable;
import java.util.logging.Logger;

public class ServiceManager
implements Serializable {
    private ServerConnector connector;
    private static ServiceManager serviceManager;
    private static Logger logger;

    private ServiceManager() {
        this(null);
    }

    public static ServiceManager getInstance() {
        if (serviceManager == null) {
            serviceManager = new ServiceManager();
        }
        return serviceManager;
    }

    public static ServiceManager getInstance(ServerConnector serverConnector) {
        if (serviceManager == null) {
            serviceManager = new ServiceManager(serverConnector);
        }
        return serviceManager;
    }

    private ServiceManager(ServerConnector connector) {
        this.connector = connector == null ? new LocalServerConnector() : connector;
    }

    public ConfigurationService getConfigurationService(String targetName) {
        return ServiceFactory.getConfigurationService(this.connector, targetName);
    }

    public ManagementService getManagementService(String targetName) {
        return ServiceFactory.getManagementService(this.connector, targetName);
    }

    public AdministrationService getAdministrationService(String targetName) {
        return ServiceFactory.getAdministrationService(this.connector, targetName);
    }

    public StatisticsService getStatisticsService(String targetName) {
        return ServiceFactory.getStatisticsService(this.connector, targetName);
    }

    static {
        logger = Logger.getLogger(ServiceManager.class.getName());
    }
}

