/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.model;

import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.common.XmlUtils;
import com.sun.jbi.jsf.util.JBILogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class JBIDescriptor {
    protected Document xmlDoc = null;
    protected String xmlText = null;
    protected Element jbiElement = null;
    protected String version;
    protected String schemaLocation;
    protected Map namespaces = new HashMap();
    private Logger logger = JBILogger.getInstance();

    public JBIDescriptor() {
    }

    public JBIDescriptor(String xmlText) {
        this.xmlText = xmlText;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getNamespaceValue(String ns) {
        return (String)this.namespaces.get(ns);
    }

    public void parse() {
        this.xmlDoc = XmlUtils.buildDomDocument(this.xmlText);
        this.jbiElement = XmlUtils.getElement(this.xmlDoc, "jbi");
        if (this.jbiElement != null) {
            this.namespaces.clear();
            NamedNodeMap attrMap = this.jbiElement.getAttributes();
            if (attrMap != null) {
                for (int i = 0; i < attrMap.getLength(); ++i) {
                    Attr attr = (Attr)attrMap.item(i);
                    String value = attr.getValue();
                    String name = attr.getName();
                    String prefix = attr.getPrefix();
                    if (name == null) continue;
                    if (name.startsWith("xmlns:")) {
                        String n = Util.trimLeft(name, "xmlns:");
                        this.namespaces.put(n, value);
                        continue;
                    }
                    if (name.equals("version")) {
                        this.version = value;
                        continue;
                    }
                    if (!name.startsWith("xsi:schemaLocation")) continue;
                    this.schemaLocation = value;
                }
            }
        }
    }

    public static void main(String[] args) {
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi  xmlns=\"http://java.sun.com/xml/ns/jbi\" xmlns:ns1=\"http://localhost/SynchronousSample/SynchronousSample\"  xmlns:ns2=\"http://enterprise.netbeans.org/bpel/SynchronousSample/SynchronousSample_1\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.0\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi ./jbi.xsd\"> <service-assembly> <identification> <name>SynchronousSampleApplication</name> <description>Represents the Service Assembly of SynchronousSampleApplication</description> </identification> <service-unit> <identification>        <name>SynchronousSampleApplication-SynchronousSample</name> <description>Represents this Service Unit</description>   </identification> <target> <artifacts-zip>SynchronousSample.jar</artifacts-zip>       <component-name>sun-bpel-engine</component-name>  </target> </service-unit> <service-unit> <identification>        <name>SynchronousSampleApplication-sun-http-binding</name> <description>Represents this Service Unit</description>     </identification> <target> <artifacts-zip>sun-http-binding.jar</artifacts-zip>        <component-name>sun-http-binding</component-name> </target> </service-unit> <connections> <connection> <consumer  endpoint-name=\"port1\" service-name=\"ns1:service1\"/> <provider endpoint-name=\"partnerlinktyperole1_myRole\" service-name=\"ns2:SynchronousSample\"/> </connection> </connections> </service-assembly> </jbi>";
        JBIDescriptor desc = new JBIDescriptor(xmlText);
        desc.parse();
    }
}

