/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.common;

import com.sun.data.provider.TableDataProvider;
import com.sun.jbi.jsf.framework.common.resources.Messages;
import com.sun.jbi.jsf.framework.services.ServiceManager;
import com.sun.jbi.jsf.framework.services.ServiceManagerFactory;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class BaseBean
implements Serializable {
    private transient Logger logger = Logger.getLogger(BaseBean.class.getName());
    protected TableDataProvider provider = null;
    protected String componentName;
    protected String componentType;
    protected String cType;
    protected String cName;
    protected String pName;
    protected String tName;
    protected String suName;
    protected ServiceManager serviceManager;

    protected void getRequestParameters() {
        HttpServletRequest request = this.getRequest();
        this.componentName = (String)this.getParameter(request, "name");
        this.componentType = (String)this.getParameter(request, "type");
        this.cType = (String)this.getParameter(request, "ctype");
        this.cName = (String)this.getParameter(request, "cname");
        this.pName = (String)this.getParameter(request, "pname");
        this.tName = (String)this.getParameter(request, "tname");
        this.suName = (String)this.getParameter("serviceUnitName");
        this.validateRequestParameters();
    }

    protected void validateRequestParameters() {
        if (this.cType == null) {
            this.cType = "_s_";
        }
        if (this.cName == null) {
            this.cName = "_s_";
        }
    }

    protected Object getParameter(HttpServletRequest request, String paramName) {
        Object paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            paramValue = request.getSession().getAttribute(paramName);
        }
        return paramValue;
    }

    protected Object getParameter(String paramName) {
        HttpServletRequest request = this.getRequest();
        Object paramValue = this.getParameter(request, paramName);
        return paramValue;
    }

    protected void setParameter(String key, Object value) {
        HttpServletRequest request = this.getRequest();
        request.getSession().setAttribute(key, value);
    }

    protected HttpServletRequest getRequest() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext ex = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ex.getRequest();
        return request;
    }

    protected void getServiceManager() {
        this.serviceManager = ServiceManagerFactory.getServiceManager(this.componentName, this.componentType);
    }

    protected void setup() {
        this.getRequestParameters();
        this.getServiceManager();
    }

    public String getName() {
        String name = this.componentName;
        if ("service-unit".equals(this.componentType) && this.pName != null) {
            name = this.pName + "-" + this.componentName;
        }
        return name;
    }

    public String getTitle(String msgid) {
        return this.getName() + " - " + Messages.getString(msgid);
    }

    public String getTableTitle(String bcTableMsgId, String seTableMsgId, String suTableMsgId) {
        String label = "";
        if ("binding-component".equals(this.componentType)) {
            label = Messages.getString(bcTableMsgId);
        } else if ("service-engine".equals(this.componentType)) {
            label = Messages.getString(seTableMsgId);
        } else if ("service-unit".equals(this.componentType)) {
            label = Messages.getString(suTableMsgId);
        } else if ("service-assembly".equals(this.componentType)) {
            label = Messages.getString(suTableMsgId);
        }
        return label;
    }
}

