/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.SharedConstants;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class DeletionBean {
    private static Logger sLog = JBILogger.getInstance();
    private JBIAdminCommands mJac = BeanUtilities.getClient();

    public Properties delete(Properties aRequestResponse, boolean aRetainFlag, List aTargetsList) {
        sLog.fine("DeletionBean.delete(" + aRequestResponse + ", " + aTargetsList + ")");
        Properties result = aRequestResponse;
        for (String target : aTargetsList) {
            result = this.doDeleteOnTarget(aRequestResponse, aRetainFlag, target);
        }
        sLog.fine("DeletionBean.delete(...), result=" + result);
        return result;
    }

    private String shutItDown(String aType, String aName, String aTarget) throws JBIRemoteException {
        String componentDetails = "";
        String state = "";
        if ("service-assembly".equals(aType)) {
            componentDetails = this.mJac.showServiceAssembly(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_COMPONENT_CHECK, aTarget);
            if (componentDetails != null) {
                List list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)componentDetails);
                Iterator itr = list.iterator();
                ServiceAssemblyInfo saInfo = (ServiceAssemblyInfo)itr.next();
                List suInfoList = saInfo.getServiceUnitInfoList();
                state = saInfo.getState();
                if (!state.equalsIgnoreCase("Shutdown")) {
                    componentDetails = this.mJac.shutdownServiceAssembly(aName, aTarget);
                }
            }
        } else if ("binding-component".equals(aType) || "service-engine".equals(aType)) {
            List list;
            Iterator it;
            JBIComponentInfo info;
            if ("binding-component".equals(aType)) {
                componentDetails = this.mJac.showBindingComponent(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_LIBRARY_CHECK, SharedConstants.NO_DEPLOYMENT_CHECK, aTarget);
            } else if ("service-engine".equals(aType)) {
                componentDetails = this.mJac.showServiceEngine(aName, SharedConstants.NO_STATE_CHECK, SharedConstants.NO_LIBRARY_CHECK, SharedConstants.NO_DEPLOYMENT_CHECK, aTarget);
            }
            if (componentDetails != null && !(state = (info = (JBIComponentInfo)(it = (list = JBIComponentInfo.readFromXmlText((String)componentDetails)).iterator()).next()).getState()).equalsIgnoreCase("Shutdown")) {
                componentDetails = this.mJac.shutdownComponent(aName, false, aTarget);
            }
        }
        return componentDetails;
    }

    private Properties doDeleteOnTarget(Properties aRequestResponse, boolean aRetainFlag, String aTarget) {
        sLog.fine("DeletionBean.doDeleteOnTarget(" + aRequestResponse + ", " + aTarget + ")");
        Properties result = aRequestResponse;
        String jbiName = aRequestResponse.getProperty("name");
        String jbiType = aRequestResponse.getProperty("type");
        String deletionResult = "";
        String shutdownResult = "";
        try {
            if (null != this.mJac) {
                if ("service-assembly".equals(jbiType)) {
                    deletionResult = this.mJac.undeployServiceAssembly(jbiName, false, aRetainFlag, aTarget);
                    result.setProperty("success-result", deletionResult);
                } else if ("binding-component".equals(jbiType) || "service-engine".equals(jbiType)) {
                    deletionResult = this.mJac.uninstallComponent(jbiName, false, aRetainFlag, aTarget);
                    result.setProperty("success-result", deletionResult);
                } else if ("shared-library".equals(jbiType)) {
                    deletionResult = this.mJac.uninstallSharedLibrary(jbiName, false, aRetainFlag, aTarget);
                    result.setProperty("success-result", deletionResult);
                } else {
                    result.setProperty("failure-result", "unexpected or missing JBI type=" + jbiType);
                }
            } else {
                result.setProperty("failure-result", "missing JBI admin common client");
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            jbiRemoteEx.printStackTrace(System.err);
            JBIManagementMessage mgmtMsg = BeanUtilities.extractJBIManagementMessage((Exception)((Object)jbiRemoteEx));
            if (mgmtMsg == null) {
                String internalErrorMsg = I18nUtilities.getResourceString("jbi.internal.error.invalid.remote.exception");
                result.setProperty("internal-error", internalErrorMsg);
            } else {
                String msg = mgmtMsg.getMessage();
                result.setProperty("failure-result", msg);
            }
            sLog.fine("Deletion.doDeleteOnTarget(...), result=" + result);
        }
        return result;
    }
}

